/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.request.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.rest.v2.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.UpdateRole;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.rest.client.request.Operation;
import io.apicurio.rest.client.request.Request;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdminRequestsProvider {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Request<NamedLogConfiguration> removeLogConfiguration(String logger) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/loggers/%s").pathParams(List.of(logger)).responseType((TypeReference)new TypeReference<NamedLogConfiguration>(){}).build();
    }

    public static Request<NamedLogConfiguration> setLogConfiguration(String logger, LogConfiguration data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("admin/loggers/%s").pathParams(List.of(logger)).responseType((TypeReference)new TypeReference<NamedLogConfiguration>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).build();
    }

    public static Request<NamedLogConfiguration> getLogConfiguration(String logger) {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/loggers/%s").pathParams(List.of(logger)).responseType((TypeReference)new TypeReference<NamedLogConfiguration>(){}).build();
    }

    public static Request<List<NamedLogConfiguration>> listLogConfigurations() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/loggers").responseType((TypeReference)new TypeReference<List<NamedLogConfiguration>>(){}).build();
    }

    public static Request<Void> deleteGlobalRule(RuleType rule) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/rules/%s").pathParams(List.of(rule.value())).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Rule> updateGlobalRuleConfig(RuleType rule, Rule data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.PUT).path("admin/rules/%s").pathParams(List.of(rule.value())).responseType((TypeReference)new TypeReference<Rule>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).build();
    }

    public static Request<Rule> getGlobalRule(RuleType rule) {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/rules/%s").pathParams(List.of(rule.value())).responseType((TypeReference)new TypeReference<Rule>(){}).build();
    }

    public static Request<Void> deleteAllGlobalRules() {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/rules").responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<Void> createGlobalRule(Rule data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.POST).path("admin/rules").data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<List<RuleType>> listGlobalRules() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/rules").responseType((TypeReference)new TypeReference<List<RuleType>>(){}).build();
    }

    public static Request<InputStream> exportData() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/export").responseType((TypeReference)new TypeReference<InputStream>(){}).headers(new HashMap<String, String>(Map.of("Accept", "application/zip"))).build();
    }

    public static Request<Void> importData(InputStream data, boolean preserveGlobalIds, boolean preserveContentIds) {
        return new Request.RequestBuilder().operation(Operation.POST).path("admin/import").responseType((TypeReference)new TypeReference<Void>(){}).data(data).headers(new HashMap<String, String>(Map.of("Content-Type", "application/zip", "X-Registry-Preserve-GlobalId", Boolean.toString(preserveGlobalIds), "X-Registry-Preserve-ContentId", Boolean.toString(preserveContentIds)))).build();
    }

    public static Request<Void> createRoleMapping(RoleMapping data) throws JsonProcessingException {
        return new Request.RequestBuilder().operation(Operation.POST).path("admin/roleMappings").data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)data))).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<List<RoleMapping>> listRoleMappings() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/roleMappings").responseType((TypeReference)new TypeReference<List<RoleMapping>>(){}).build();
    }

    public static Request<Void> updateRoleMapping(String principalId, RoleType role) throws JsonProcessingException {
        UpdateRole update = new UpdateRole();
        update.setRole(role);
        return new Request.RequestBuilder().operation(Operation.PUT).path("admin/roleMappings/%s").pathParams(List.of(principalId)).responseType((TypeReference)new TypeReference<Void>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)update))).build();
    }

    public static Request<Void> deleteRoleMapping(String principalId) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/roleMappings/%s").pathParams(List.of(principalId)).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }

    public static Request<RoleMapping> getRoleMapping(String principalId) {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/roleMappings/%s").pathParams(List.of(principalId)).responseType((TypeReference)new TypeReference<RoleMapping>(){}).build();
    }

    public static Request<List<ConfigurationProperty>> listConfigProperties() {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/config/properties").responseType((TypeReference)new TypeReference<List<ConfigurationProperty>>(){}).build();
    }

    public static Request<ConfigurationProperty> getConfigProperty(String propertyName) {
        return new Request.RequestBuilder().operation(Operation.GET).path("admin/config/properties/%s").pathParams(List.of(propertyName)).responseType((TypeReference)new TypeReference<ConfigurationProperty>(){}).build();
    }

    public static Request<Void> setConfigProperty(String propertyName, String propertyValue) throws JsonProcessingException {
        UpdateConfigurationProperty property = new UpdateConfigurationProperty();
        property.setValue(propertyValue);
        return new Request.RequestBuilder().operation(Operation.PUT).path("admin/config/properties/%s").pathParams(List.of(propertyName)).responseType((TypeReference)new TypeReference<Void>(){}).data(IoUtil.toStream((byte[])mapper.writeValueAsBytes((Object)property))).build();
    }

    public static Request<Void> deleteConfigProperty(String propertyName) {
        return new Request.RequestBuilder().operation(Operation.DELETE).path("admin/config/properties/%s").pathParams(List.of(propertyName)).responseType((TypeReference)new TypeReference<Void>(){}).build();
    }
}

