/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class KeyspaceTable
implements DataCollectionId {
    public final String keyspace;
    public final String table;

    public KeyspaceTable(String keyspace, String table) {
        this.keyspace = keyspace;
        this.table = table;
    }

    public KeyspaceTable(TableMetadata tableMetadata) {
        this.keyspace = tableMetadata.getKeyspace().toString();
        this.table = tableMetadata.getName().toString();
    }

    public String name() {
        return this.keyspace + "." + this.table;
    }

    public List<String> parts() {
        return Collect.arrayListOf((Object)this.keyspace, (Object[])new String[]{this.table});
    }

    public List<String> databaseParts() {
        return Collections.emptyList();
    }

    public List<String> schemaParts() {
        return Collect.arrayListOf((Object)this.keyspace, (Object[])new String[]{this.table});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyspaceTable that = (KeyspaceTable)o;
        return this.keyspace.equals(that.keyspace) && this.table.equals(that.table);
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.table);
    }

    public String toString() {
        return this.name();
    }

    public String identifier() {
        return this.keyspace + "." + this.table;
    }
}

