/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class DecimalTypeDeserializer
extends LogicalTypeDeserializer {
    private final Schema schema = VariableScaleDecimal.builder().build();
    private CassandraTypeDeserializer.DecimalMode mode = CassandraTypeDeserializer.DecimalMode.DOUBLE;

    public DecimalTypeDeserializer(DebeziumTypeDeserializer deserializer, Object abstractType) {
        super(deserializer, (Integer)6, abstractType);
    }

    @Override
    public Object deserialize(Object abstractType, ByteBuffer bb) {
        Object value = super.deserialize(abstractType, bb);
        return this.formatDeserializedValue(abstractType, value);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(Object abstractType) {
        switch (this.mode) {
            case DOUBLE: {
                return CassandraTypeKafkaSchemaBuilders.DOUBLE_TYPE;
            }
            case PRECISE: {
                return VariableScaleDecimal.builder();
            }
            case STRING: {
                return CassandraTypeKafkaSchemaBuilders.STRING_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown decimalHandlingMode");
    }

    @Override
    public Object formatDeserializedValue(Object abstractType, Object value) {
        BigDecimal decimal = (BigDecimal)value;
        switch (this.mode) {
            case DOUBLE: {
                return decimal.doubleValue();
            }
            case PRECISE: {
                return VariableScaleDecimal.fromLogical((Schema)this.schema, (SpecialValueDecimal)new SpecialValueDecimal(decimal));
            }
            case STRING: {
                return decimal.toPlainString();
            }
        }
        throw new IllegalArgumentException("Unknown decimalHandlingMode");
    }

    public void setMode(CassandraTypeDeserializer.DecimalMode mode) {
        this.mode = mode;
    }
}

