/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import binlogdata.Binlogdata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Vgtid {
    public static final String CURRENT_GTID = "current";
    public static final String EMPTY_GTID = "";
    public static final String KEYSPACE_KEY = "keyspace";
    public static final String SHARD_KEY = "shard";
    public static final String GTID_KEY = "gtid";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Binlogdata.VGtid rawVgtid;
    private final List<ShardGtid> shardGtids = new ArrayList<ShardGtid>();

    private Vgtid(Binlogdata.VGtid rawVgtid) {
        this.rawVgtid = rawVgtid;
        for (Binlogdata.ShardGtid shardGtid : rawVgtid.getShardGtidsList()) {
            this.shardGtids.add(new ShardGtid(shardGtid.getKeyspace(), shardGtid.getShard(), shardGtid.getGtid()));
        }
    }

    private Vgtid(List<ShardGtid> shardGtids) {
        this.shardGtids.addAll(shardGtids);
        Binlogdata.VGtid.Builder builder = Binlogdata.VGtid.newBuilder();
        for (ShardGtid shardGtid : shardGtids) {
            builder.addShardGtids(Binlogdata.ShardGtid.newBuilder().setKeyspace(shardGtid.getKeyspace()).setShard(shardGtid.getShard()).setGtid(shardGtid.getGtid()).build());
        }
        this.rawVgtid = builder.build();
    }

    public static Vgtid of(String shardGtidsInJson) {
        try {
            List shardGtids = (List)MAPPER.readValue(shardGtidsInJson, (TypeReference)new TypeReference<List<ShardGtid>>(){});
            return Vgtid.of(shardGtids);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Vgtid of(Binlogdata.VGtid rawVgtid) {
        return new Vgtid(rawVgtid);
    }

    public static Vgtid of(List<ShardGtid> shardGtids) {
        return new Vgtid(shardGtids);
    }

    public Binlogdata.VGtid getRawVgtid() {
        return this.rawVgtid;
    }

    public List<ShardGtid> getShardGtids() {
        return this.shardGtids;
    }

    public boolean isSingleShard() {
        return this.rawVgtid.getShardGtidsCount() == 1;
    }

    public String toString() {
        try {
            return MAPPER.writeValueAsString(this.shardGtids);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vgtid vgtid = (Vgtid)o;
        return Objects.equals(this.rawVgtid, vgtid.rawVgtid) && Objects.equals(this.shardGtids, vgtid.shardGtids);
    }

    public int hashCode() {
        return Objects.hash(this.rawVgtid, this.shardGtids);
    }

    @JsonPropertyOrder(value={"keyspace", "shard", "gtid"})
    public static class ShardGtid {
        private final String keyspace;
        private final String shard;
        private final String gtid;

        @JsonCreator
        public ShardGtid(@JsonProperty(value="keyspace") String keyspace, @JsonProperty(value="shard") String shard, @JsonProperty(value="gtid") String gtid) {
            this.keyspace = keyspace;
            this.shard = shard;
            this.gtid = gtid;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getShard() {
            return this.shard;
        }

        public String getGtid() {
            return this.gtid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardGtid shardGtid = (ShardGtid)o;
            return Objects.equals(this.keyspace, shardGtid.keyspace) && Objects.equals(this.shard, shardGtid.shard) && Objects.equals(this.gtid, shardGtid.gtid);
        }

        public int hashCode() {
            return Objects.hash(this.keyspace, this.shard, this.gtid);
        }
    }
}

