/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.config.Configuration;
import io.debezium.connector.common.RelationalBaseSourceConnector;
import io.debezium.connector.vitess.Module;
import io.debezium.connector.vitess.Vgtid;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.VitessConnectorTask;
import io.debezium.connector.vitess.VitessPartition;
import io.debezium.connector.vitess.connection.VitessReplicationConnection;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Strings;
import io.grpc.StatusRuntimeException;
import io.vitess.proto.Query;
import io.vitess.proto.Vtgate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnectorContext;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessConnector
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessConnector.class);
    private Map<String, String> properties;
    private VitessConnectorConfig connectorConfig;

    public void start(Map<String, String> props) {
        LOGGER.info("Starting Vitess Connector");
        this.properties = Collections.unmodifiableMap(props);
        this.connectorConfig = new VitessConnectorConfig(Configuration.from(this.properties));
    }

    public Class<? extends Task> taskClass() {
        return VitessConnectorTask.class;
    }

    protected Map<String, String> getGtidPerShardFromStorage(int numTasks, int gen, boolean expectsOffset) {
        if (this.context == null || !(this.context instanceof SourceConnectorContext) || this.context().offsetStorageReader() == null) {
            LOGGER.warn("Context {} is not setup for the connector, this can happen in unit tests.", (Object)this.context);
            return null;
        }
        OffsetStorageReader offsetStorageReader = this.context().offsetStorageReader();
        HashMap<String, String> gtidsPerShard = new HashMap<String, String>();
        for (int i = 0; i < numTasks; ++i) {
            String taskKey = VitessConnector.getTaskKeyName(i, numTasks, gen);
            VitessPartition par = new VitessPartition(this.connectorConfig.getLogicalName(), taskKey);
            Map offset = offsetStorageReader.offset(par.getSourcePartition());
            if (offset == null && gen == 0) {
                LOGGER.info("No previous offset for partition: {}, fall back to only server key", (Object)par);
                par = new VitessPartition(this.connectorConfig.getLogicalName(), null);
                offset = offsetStorageReader.offset(par.getSourcePartition());
            }
            if (offset == null) {
                if (expectsOffset) {
                    throw new IllegalArgumentException(String.format("No offset found for %s", par));
                }
                LOGGER.warn("No offset found for task key: {}", (Object)taskKey);
                continue;
            }
            String vgtidStr = (String)offset.get("vgtid");
            Objects.requireNonNull(vgtidStr, String.format("No vgtid from %s", offset));
            List<Vgtid.ShardGtid> shardGtids = Vgtid.of(vgtidStr).getShardGtids();
            for (Vgtid.ShardGtid shardGtid : shardGtids) {
                gtidsPerShard.put(shardGtid.getShard(), shardGtid.getGtid());
            }
        }
        return gtidsPerShard;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        LOGGER.info("Calculating taskConfigs for {} tasks", (Object)maxTasks);
        List<String> shards = null;
        if (this.connectorConfig.offsetStoragePerTask() && (shards = this.connectorConfig.getShard()) == null) {
            shards = VitessConnector.getVitessShards(this.connectorConfig);
        }
        return this.taskConfigs(maxTasks, shards);
    }

    public static boolean hasSameShards(Collection<String> shardsOne, Collection<String> shardsTwo) {
        if (shardsOne == null) {
            return shardsTwo == null;
        }
        if (shardsTwo == null) {
            return shardsOne == null;
        }
        if (shardsOne.size() != shardsTwo.size()) {
            return false;
        }
        HashSet<String> setOne = new HashSet<String>(shardsOne);
        HashSet<String> setTwo = new HashSet<String>(shardsTwo);
        return setOne.equals(setTwo);
    }

    public List<Map<String, String>> taskConfigs(int maxTasks, List<String> currentShards) {
        LOGGER.info("Calculating taskConfigs for {} tasks and shards: {}", (Object)maxTasks, currentShards);
        if (this.connectorConfig.offsetStoragePerTask()) {
            Set<String> previousShards;
            int prevNumTasks = this.connectorConfig.getPrevNumTasks();
            int gen = this.connectorConfig.getOffsetStorageTaskKeyGen();
            int tasks = Math.min(maxTasks, currentShards == null ? Integer.MAX_VALUE : currentShards.size());
            LOGGER.info("There are {} vitess shards for maxTasks: {}, we will use {} tasks", new Object[]{currentShards == null ? null : Integer.valueOf(currentShards.size()), maxTasks, tasks});
            Map<String, String> prevGtidsPerShard = gen > 0 ? this.getGtidPerShardFromStorage(prevNumTasks, gen - 1, true) : null;
            LOGGER.info("Previous gtids Per shard: {}", prevGtidsPerShard);
            Set<String> set = previousShards = prevGtidsPerShard != null ? prevGtidsPerShard.keySet() : null;
            if (gen > 0 && tasks == prevNumTasks && VitessConnector.hasSameShards(previousShards, currentShards)) {
                throw new IllegalArgumentException(String.format("Previous num.tasks: %s and current num.tasks: %s are the same. And previous shards: %s and current shards: %s are the same. Please choose different tasks.max or have different number of vitess shards if you want to change the task parallelism.  Otherwise please reset the offset.storage.task.key.gen config to its original value", prevNumTasks, tasks, previousShards, currentShards));
            }
            if (prevGtidsPerShard != null && !VitessConnector.hasSameShards(prevGtidsPerShard.keySet(), currentShards)) {
                LOGGER.warn("Some shards for the previous generation {} are not persisted.  Expected shards: {}", prevGtidsPerShard.keySet(), currentShards);
                if (prevGtidsPerShard.keySet().containsAll(currentShards)) {
                    throw new IllegalArgumentException(String.format("Previous shards: %s is the superset of current shards: %s.  We will lose gtid positions for some shards if we continue", prevGtidsPerShard.keySet(), currentShards));
                }
            }
            String keyspace = this.connectorConfig.getKeyspace();
            Map<String, String> gtidsPerShard = this.getGtidPerShardFromStorage(tasks, gen, false);
            if (gtidsPerShard != null && !VitessConnector.hasSameShards(gtidsPerShard.keySet(), currentShards)) {
                LOGGER.warn("Some shards for the current generation {} are not persisted.  Expected shards: {}", gtidsPerShard.keySet(), currentShards);
                if (!currentShards.containsAll(gtidsPerShard.keySet())) {
                    LOGGER.warn("Shards from persisted offset: {} not contained within current db shards: {}", gtidsPerShard.keySet(), currentShards);
                    gtidsPerShard = this.getGtidPerShardFromStorage(tasks, gen, true);
                }
            }
            List<String> shards = null;
            if (gtidsPerShard != null && gtidsPerShard.size() == 0) {
                if (prevGtidsPerShard != null && prevGtidsPerShard.size() != 0 && !currentShards.containsAll(prevGtidsPerShard.keySet())) {
                    LOGGER.info("Using shards from persisted offset from prev gen: {}", prevGtidsPerShard.keySet());
                    shards = new ArrayList<String>(prevGtidsPerShard.keySet());
                } else {
                    LOGGER.warn("No persisted offset for current or previous gen, using current shards from db: {}", currentShards);
                    shards = currentShards;
                }
            } else if (gtidsPerShard != null && !currentShards.containsAll(gtidsPerShard.keySet())) {
                LOGGER.info("Persisted offset has different shards, Using shards from persisted offset: {}", gtidsPerShard.keySet());
                shards = new ArrayList<String>(gtidsPerShard.keySet());
            } else {
                LOGGER.warn("Current db shards is the superset of persisted offset, using current shards from db: {}", currentShards);
                shards = currentShards;
            }
            Map<String, String> configGtidsPerShard = this.getConfigGtidsPerShard(shards);
            shards.sort(Comparator.naturalOrder());
            HashMap<Integer, List> shardsPerTask = new HashMap<Integer, List>();
            int taskId = 0;
            for (String shard : shards) {
                List taskShards = shardsPerTask.computeIfAbsent(taskId, k -> new ArrayList());
                taskShards.add(shard);
                taskId = (taskId + 1) % tasks;
            }
            LOGGER.info("Shards task distribution: {}", shardsPerTask);
            ArrayList<Map<String, String>> allTaskProps = new ArrayList<Map<String, String>>();
            Iterator iterator = shardsPerTask.keySet().iterator();
            while (iterator.hasNext()) {
                int tid = (Integer)iterator.next();
                List taskShards = (List)shardsPerTask.get(tid);
                HashMap<String, String> taskProps = new HashMap<String, String>(this.properties);
                taskProps.put("vitess.task.key", VitessConnector.getTaskKeyName(tid, tasks, gen));
                taskProps.put("vitess.task.shards", String.join((CharSequence)",", taskShards));
                ArrayList<Vgtid.ShardGtid> shardGtids = new ArrayList<Vgtid.ShardGtid>();
                for (String shard : taskShards) {
                    String gtidStr;
                    String string = gtidStr = gtidsPerShard != null ? gtidsPerShard.get(shard) : null;
                    if (gtidStr == null) {
                        LOGGER.warn("No current gtid found for shard: {}, fallback to previous gen", (Object)shard);
                        String string2 = gtidStr = prevGtidsPerShard != null ? prevGtidsPerShard.get(shard) : null;
                    }
                    if (gtidStr == null) {
                        gtidStr = configGtidsPerShard.get(shard);
                        LOGGER.warn("No previous gtid found either for shard: {}, fallback to '{}'", (Object)shard, (Object)gtidStr);
                    }
                    shardGtids.add(new Vgtid.ShardGtid(keyspace, shard, gtidStr));
                }
                taskProps.put("vitess.task.vgtid", Vgtid.of(shardGtids).toString());
                allTaskProps.add(taskProps);
            }
            LOGGER.info("taskConfigs are: {}", allTaskProps);
            return allTaskProps;
        }
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    private Map<String, String> getConfigGtidsPerShard(List<String> shards) {
        List<String> gtids = this.connectorConfig.getGtid();
        Map<String, String> configGtidsPerShard = null;
        if (shards != null && gtids.equals(VitessConnectorConfig.EMPTY_GTID_LIST)) {
            Function<Integer, String> emptyGtid = x -> "";
            configGtidsPerShard = VitessConnector.buildMap(shards, emptyGtid);
        } else if (shards != null && gtids.equals(VitessConnectorConfig.DEFAULT_GTID_LIST)) {
            Function<Integer, String> currentGtid = x -> "current";
            configGtidsPerShard = VitessConnector.buildMap(shards, currentGtid);
        } else if (shards != null) {
            configGtidsPerShard = VitessConnector.buildMap(shards, gtids::get);
        }
        LOGGER.info("Found GTIDs per shard in config {}", configGtidsPerShard);
        return configGtidsPerShard;
    }

    private static Map<String, String> buildMap(List<String> keys, Function<Integer, String> function) {
        return IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(keys::get, function));
    }

    protected static final String getTaskKeyName(int tid, int numTasks, int gen) {
        return String.format("task%d_%d_%d", tid, numTasks, gen);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return VitessConnectorConfig.configDef();
    }

    public String version() {
        return Module.version();
    }

    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        VitessConnectorConfig connectionConfig = new VitessConnectorConfig(config);
        try (VitessReplicationConnection connection = new VitessReplicationConnection(connectionConfig, null);){
            try {
                connection.execute("SHOW DATABASES");
                LOGGER.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
            }
            catch (StatusRuntimeException e) {
                LOGGER.info("Failed testing connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
                hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error validating the database connection", (Throwable)e);
            hostnameValue.addErrorMessage("Unable to validate connection: " + e.getMessage());
        }
    }

    private static List<String> getRowsFromQuery(VitessConnectorConfig connectionConfig, String query) {
        List<String> list;
        VitessReplicationConnection connection = new VitessReplicationConnection(connectionConfig, null);
        try {
            Vtgate.ExecuteResponse response = connection.execute(query);
            LOGGER.info("Got response: {} for query: {}", (Object)response, (Object)query);
            assert (response != null && !response.hasError() && response.hasResult()) : String.format("Error response: %s", response);
            Query.QueryResult result = response.getResult();
            List rows = result.getRowsList();
            assert (!rows.isEmpty()) : String.format("Empty response: %s", response);
            list = rows.stream().map(s -> s.getValues().toStringUtf8()).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unexpected error while running query: %s", query), e);
            }
        }
        connection.close();
        return list;
    }

    public static List<String> getIncludedTables(String keyspace, String tableIncludeList, List<String> allTables) {
        List patterns = Strings.listOfRegex((String)tableIncludeList, (int)2);
        ArrayList<String> includedTables = new ArrayList<String>();
        block0: for (String ksTable : allTables) {
            for (Pattern pattern : patterns) {
                if (!pattern.asPredicate().test(String.format("%s.%s", keyspace, ksTable))) continue;
                includedTables.add(ksTable);
                continue block0;
            }
        }
        return includedTables;
    }

    public static List<String> getKeyspaceTables(VitessConnectorConfig connectionConfig) {
        String query = String.format("SHOW TABLES FROM %s", connectionConfig.getKeyspace());
        List<String> tables = VitessConnector.getRowsFromQuery(connectionConfig, query);
        LOGGER.info("All tables from keyspace {} are: {}", (Object)connectionConfig.getKeyspace(), tables);
        return tables;
    }

    public static List<String> getVitessShards(VitessConnectorConfig connectionConfig) {
        String query = String.format("SHOW VITESS_SHARDS LIKE '%s/%%'", connectionConfig.getKeyspace());
        List<String> rows = VitessConnector.getRowsFromQuery(connectionConfig, query);
        List<String> shards = rows.stream().map(fieldValue -> {
            String[] parts = fieldValue.split("/");
            assert (parts != null && parts.length == 2) : String.format("Wrong field format: %s", fieldValue);
            return parts[1];
        }).collect(Collectors.toList());
        LOGGER.info("Shards: {}", shards);
        return shards;
    }

    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        String configName;
        LOGGER.info("Validating config: {}", (Object)config);
        Map results = config.validate(VitessConnectorConfig.ALL_FIELDS);
        Integer maxTasks = config.getInteger("tasks.max");
        VitessConnectorConfig tempConnectorConfig = new VitessConnectorConfig(config);
        if (maxTasks != null && maxTasks > 1 && !tempConnectorConfig.offsetStoragePerTask()) {
            configName = VitessConnectorConfig.OFFSET_STORAGE_PER_TASK.name();
            results.computeIfAbsent(configName, k -> new ConfigValue(configName));
            ((ConfigValue)results.get(configName)).addErrorMessage(String.format("%s needs to be enabled when %s > 1", configName, "tasks.max"));
        }
        if (tempConnectorConfig.offsetStoragePerTask() && tempConnectorConfig.getOffsetStorageTaskKeyGen() < 0) {
            configName = VitessConnectorConfig.OFFSET_STORAGE_TASK_KEY_GEN.name();
            results.computeIfAbsent(configName, k -> new ConfigValue(configName));
            ((ConfigValue)results.get(configName)).addErrorMessage(String.format("%s needs to be enabled when %s is specified", configName, VitessConnectorConfig.OFFSET_STORAGE_PER_TASK.name()));
        }
        if (tempConnectorConfig.getOffsetStorageTaskKeyGen() >= 0 && tempConnectorConfig.getPrevNumTasks() <= 0) {
            configName = VitessConnectorConfig.PREV_NUM_TASKS.name();
            results.computeIfAbsent(configName, k -> new ConfigValue(configName));
            ((ConfigValue)results.get(configName)).addErrorMessage(String.format("%s needs to be enabled when %s is specified", configName, VitessConnectorConfig.OFFSET_STORAGE_TASK_KEY_GEN.name()));
        }
        return results;
    }
}

