/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.grpc;

import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.opentracing.contrib.grpc.ClientTracingInterceptor;
import io.vitess.client.Context;
import io.vitess.client.RpcClient;
import io.vitess.client.RpcClientFactory;
import io.vitess.client.grpc.GrpcClient;
import io.vitess.client.grpc.RetryingInterceptor;
import io.vitess.client.grpc.RetryingInterceptorConfig;
import io.vitess.client.grpc.tls.TlsOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.net.ssl.SSLException;

public class GrpcClientFactory
implements RpcClientFactory {
    private RetryingInterceptorConfig config;
    private final boolean useTracing;
    private CallCredentials callCredentials;
    private String loadBalancerPolicy;
    private NameResolver.Factory nameResolverFactory;

    public GrpcClientFactory() {
        this(RetryingInterceptorConfig.noOpConfig(), true);
    }

    public GrpcClientFactory(RetryingInterceptorConfig config, boolean useTracing) {
        this.config = config;
        this.useTracing = useTracing;
    }

    public GrpcClientFactory setCallCredentials(CallCredentials value) {
        this.callCredentials = value;
        return this;
    }

    public GrpcClientFactory setLoadBalancerFactory(LoadBalancer.Factory value) {
        VitessLoadBalancer provider = new VitessLoadBalancer(value);
        LoadBalancerRegistry registry = LoadBalancerRegistry.getDefaultRegistry();
        registry.deregister((LoadBalancerProvider)provider);
        registry.register((LoadBalancerProvider)provider);
        this.loadBalancerPolicy = "vitess_lb";
        return this;
    }

    public GrpcClientFactory setNameResolverFactory(NameResolver.Factory value) {
        this.nameResolverFactory = value;
        return this;
    }

    public RpcClient create(Context ctx, String target) {
        ClientInterceptor[] interceptors = this.getClientInterceptors();
        NettyChannelBuilder channel = (NettyChannelBuilder)this.channelBuilder(target).negotiationType(NegotiationType.PLAINTEXT).intercept(interceptors);
        if (this.loadBalancerPolicy != null) {
            channel.defaultLoadBalancingPolicy(this.loadBalancerPolicy);
        }
        if (this.nameResolverFactory != null) {
            channel.nameResolverFactory(this.nameResolverFactory);
        }
        return this.callCredentials != null ? new GrpcClient(channel.build(), this.callCredentials, ctx) : new GrpcClient(channel.build(), ctx);
    }

    private ClientInterceptor[] getClientInterceptors() {
        ClientInterceptor[] interceptors;
        RetryingInterceptor retryingInterceptor = new RetryingInterceptor(this.config);
        if (this.useTracing) {
            ClientTracingInterceptor tracingInterceptor = new ClientTracingInterceptor();
            interceptors = new ClientInterceptor[]{retryingInterceptor, tracingInterceptor};
        } else {
            interceptors = new ClientInterceptor[]{retryingInterceptor};
        }
        return interceptors;
    }

    protected NettyChannelBuilder channelBuilder(String target) {
        return NettyChannelBuilder.forTarget((String)target);
    }

    public RpcClient createTls(Context ctx, String target, TlsOptions tlsOptions) {
        SslContext sslContext;
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
        KeyStore trustStore = this.loadKeyStore(tlsOptions.getTrustStore(), tlsOptions.getTrustStorePassword());
        if (trustStore == null) {
            throw new RuntimeException("Could not load trustStore");
        }
        X509Certificate[] trustCertCollection = tlsOptions.getTrustAlias() == null ? this.loadCertCollection(trustStore) : this.loadCertCollectionForAlias(trustStore, tlsOptions.getTrustAlias());
        sslContextBuilder.trustManager(trustCertCollection);
        KeyStore keyStore = this.loadKeyStore(tlsOptions.getKeyStore(), tlsOptions.getKeyStorePassword());
        if (keyStore != null) {
            PrivateKeyWrapper privateKeyWrapper;
            PrivateKeyWrapper privateKeyWrapper2 = privateKeyWrapper = tlsOptions.getKeyAlias() == null ? this.loadPrivateKeyEntry(keyStore, tlsOptions.getKeyStorePassword(), tlsOptions.getKeyPassword()) : this.loadPrivateKeyEntryForAlias(keyStore, tlsOptions.getKeyAlias(), tlsOptions.getKeyStorePassword(), tlsOptions.getKeyPassword());
            if (privateKeyWrapper == null) {
                throw new RuntimeException("Could not retrieve private key and certificate chain from keyStore");
            }
            sslContextBuilder.keyManager(privateKeyWrapper.getPrivateKey(), privateKeyWrapper.getPassword(), privateKeyWrapper.getCertificateChain());
        }
        try {
            sslContext = sslContextBuilder.build();
        }
        catch (SSLException exc) {
            throw new RuntimeException(exc);
        }
        ClientInterceptor[] interceptors = this.getClientInterceptors();
        return new GrpcClient(((NettyChannelBuilder)this.channelBuilder(target).negotiationType(NegotiationType.TLS).sslContext(sslContext).intercept(interceptors)).build(), ctx);
    }

    private KeyStore loadKeyStore(File keyStoreFile, String keyStorePassword) {
        if (keyStoreFile == null) {
            return null;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            char[] password = keyStorePassword == null ? null : keyStorePassword.toCharArray();
            try (FileInputStream fis = new FileInputStream(keyStoreFile);){
                keyStore.load(fis, password);
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exc) {
            return null;
        }
    }

    private X509Certificate[] loadCertCollectionForAlias(KeyStore keyStore, String alias) {
        if (keyStore == null) {
            return null;
        }
        try {
            return new X509Certificate[]{(X509Certificate)keyStore.getCertificate(alias)};
        }
        catch (ClassCastException | KeyStoreException exc) {
            return null;
        }
    }

    private X509Certificate[] loadCertCollection(KeyStore keyStore) {
        Enumeration<String> aliases;
        if (keyStore == null) {
            return null;
        }
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException exc) {
            return null;
        }
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate[] certCollection = this.loadCertCollectionForAlias(keyStore, alias);
            if (certCollection == null) continue;
            return certCollection;
        }
        return null;
    }

    private PrivateKeyWrapper loadPrivateKeyEntryForAlias(KeyStore keyStore, String alias, String keyStorePassword, String keyPassword) {
        if (keyStore == null || alias == null) {
            return null;
        }
        try {
            if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                return null;
            }
        }
        catch (KeyStoreException exc) {
            return null;
        }
        try {
            char[] pass = keyPassword == null ? null : keyPassword.toCharArray();
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(pass));
            return new PrivateKeyWrapper(entry.getPrivateKey(), keyPassword, entry.getCertificateChain());
        }
        catch (KeyStoreException | NoSuchAlgorithmException exc) {
            return null;
        }
        catch (UnrecoverableEntryException exc) {
            char[] pass = keyStorePassword == null ? null : keyStorePassword.toCharArray();
            try {
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(pass));
                return new PrivateKeyWrapper(entry.getPrivateKey(), keyPassword, entry.getCertificateChain());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e1) {
                return null;
            }
        }
    }

    private PrivateKeyWrapper loadPrivateKeyEntry(KeyStore keyStore, String keyStorePassword, String keyPassword) {
        Enumeration<String> aliases;
        if (keyStore == null) {
            return null;
        }
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException exc) {
            return null;
        }
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            PrivateKeyWrapper privateKeyWrapper = this.loadPrivateKeyEntryForAlias(keyStore, alias, keyStorePassword, keyPassword);
            if (privateKeyWrapper == null) continue;
            return privateKeyWrapper;
        }
        return null;
    }

    private class VitessLoadBalancer
    extends LoadBalancerProvider {
        private LoadBalancer.Factory base;

        public VitessLoadBalancer(LoadBalancer.Factory base) {
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return this.base.newLoadBalancer(helper);
        }

        public boolean isAvailable() {
            return true;
        }

        public int getPriority() {
            return 10;
        }

        public String getPolicyName() {
            return "vitess_lb";
        }
    }

    private class PrivateKeyWrapper {
        private PrivateKey privateKey;
        private String password;
        private X509Certificate[] certificateChain;

        public PrivateKeyWrapper(PrivateKey privateKey, String password, Certificate[] certificateChain) {
            this.privateKey = privateKey;
            this.password = password;
            this.certificateChain = (X509Certificate[])Arrays.copyOf(certificateChain, certificateChain.length, X509Certificate[].class);
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getPassword() {
            return this.password;
        }

        public X509Certificate[] getCertificateChain() {
            return this.certificateChain;
        }
    }
}

