/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.control.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Duration;
import lombok.Generated;

public class ControllerImplConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int initialBackoffMillis;
    private final int maxBackoffMillis;
    private final int retryAttempts;
    private final int backoffMultiple;
    private final long timeoutMillis;
    private final ClientConfig clientConfig;

    @ConstructorProperties(value={"initialBackoffMillis", "maxBackoffMillis", "retryAttempts", "backoffMultiple", "timeoutMillis", "clientConfig"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    ControllerImplConfig(int initialBackoffMillis, int maxBackoffMillis, int retryAttempts, int backoffMultiple, long timeoutMillis, ClientConfig clientConfig) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.retryAttempts = retryAttempts;
        this.backoffMultiple = backoffMultiple;
        this.timeoutMillis = timeoutMillis;
        this.clientConfig = clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ControllerImplConfigBuilder builder() {
        return new ControllerImplConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBackoffMultiple() {
        return this.backoffMultiple;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControllerImplConfig)) {
            return false;
        }
        ControllerImplConfig other = (ControllerImplConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialBackoffMillis() != other.getInitialBackoffMillis()) {
            return false;
        }
        if (this.getMaxBackoffMillis() != other.getMaxBackoffMillis()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        if (this.getBackoffMultiple() != other.getBackoffMultiple()) {
            return false;
        }
        if (this.getTimeoutMillis() != other.getTimeoutMillis()) {
            return false;
        }
        ClientConfig this$clientConfig = this.getClientConfig();
        ClientConfig other$clientConfig = other.getClientConfig();
        return !(this$clientConfig == null ? other$clientConfig != null : !((Object)this$clientConfig).equals(other$clientConfig));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ControllerImplConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialBackoffMillis();
        result = result * 59 + this.getMaxBackoffMillis();
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getBackoffMultiple();
        long $timeoutMillis = this.getTimeoutMillis();
        result = result * 59 + (int)($timeoutMillis >>> 32 ^ $timeoutMillis);
        ClientConfig $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : ((Object)$clientConfig).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ControllerImplConfig(initialBackoffMillis=" + this.getInitialBackoffMillis() + ", maxBackoffMillis=" + this.getMaxBackoffMillis() + ", retryAttempts=" + this.getRetryAttempts() + ", backoffMultiple=" + this.getBackoffMultiple() + ", timeoutMillis=" + this.getTimeoutMillis() + ", clientConfig=" + this.getClientConfig() + ")";
    }

    public static final class ControllerImplConfigBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ClientConfig clientConfig;
        private int initialBackoffMillis = 1;
        private int maxBackoffMillis = 20000;
        private int retryAttempts = 10;
        private int backoffMultiple = 10;
        private long timeoutMillis = Duration.ofMinutes(5L).toMillis();
        private ClientConfig config = ClientConfig.builder().controllerURI(null).credentials(null).trustStore("").build();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ControllerImplConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerImplConfigBuilder initialBackoffMillis(int initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerImplConfigBuilder maxBackoffMillis(int maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerImplConfigBuilder retryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerImplConfigBuilder backoffMultiple(int backoffMultiple) {
            this.backoffMultiple = backoffMultiple;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerImplConfigBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerImplConfigBuilder clientConfig(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ControllerImplConfig build() {
            return new ControllerImplConfig(this.initialBackoffMillis, this.maxBackoffMillis, this.retryAttempts, this.backoffMultiple, this.timeoutMillis, this.clientConfig);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ControllerImplConfig.ControllerImplConfigBuilder(initialBackoffMillis=" + this.initialBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", retryAttempts=" + this.retryAttempts + ", backoffMultiple=" + this.backoffMultiple + ", timeoutMillis=" + this.timeoutMillis + ", clientConfig=" + this.clientConfig + ")";
        }
    }
}

