/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.cloud.grpc.GcpManagedChannel;
import com.google.cloud.grpc.GcpManagedChannelOptions;
import com.google.cloud.grpc.proto.ApiConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class GcpManagedChannelBuilder
extends ForwardingChannelBuilder<GcpManagedChannelBuilder> {
    private static final Logger logger = Logger.getLogger(GcpManagedChannelBuilder.class.getName());
    private final ManagedChannelBuilder<?> delegate;
    private int poolSize = 0;
    private GcpManagedChannelOptions options;
    @VisibleForTesting
    ApiConfig apiConfig;

    private GcpManagedChannelBuilder(ManagedChannelBuilder<?> delegate) {
        this.delegate = delegate;
        this.options = new GcpManagedChannelOptions();
    }

    private ApiConfig parseConfigFromJsonFile(File file) {
        JsonFormat.Parser parser = JsonFormat.parser();
        ApiConfig.Builder apiConfig = ApiConfig.newBuilder();
        try {
            BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
            parser.merge((Reader)reader, (Message.Builder)apiConfig);
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            return null;
        }
        return apiConfig.build();
    }

    public static GcpManagedChannelBuilder forDelegateBuilder(ManagedChannelBuilder<?> delegate) {
        return new GcpManagedChannelBuilder(delegate);
    }

    public GcpManagedChannelBuilder setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    public GcpManagedChannelBuilder withApiConfig(ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
        return this;
    }

    public GcpManagedChannelBuilder withApiConfigJsonFile(File file) {
        this.apiConfig = this.parseConfigFromJsonFile(file);
        return this;
    }

    public GcpManagedChannelBuilder withApiConfigJsonString(String jsonString) {
        JsonFormat.Parser parser = JsonFormat.parser();
        ApiConfig.Builder apiConfig = ApiConfig.newBuilder();
        try {
            parser.merge(jsonString, (Message.Builder)apiConfig);
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            return null;
        }
        this.apiConfig = apiConfig.build();
        return this;
    }

    public GcpManagedChannelBuilder withOptions(@Nullable GcpManagedChannelOptions options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    protected ManagedChannelBuilder<?> delegate() {
        return this.delegate;
    }

    public ManagedChannel build() {
        return new GcpManagedChannel(this.delegate, this.apiConfig, this.poolSize, this.options);
    }
}

