/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CassandraTypeProvider;
import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.DurationTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.ListTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.MapTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.SetTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.TupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.UserDefinedTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.BasicTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.DecimalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.InetAddressDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TimeUUIDTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TimestampTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.UUIDTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.VarIntTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class Cassandra4TypeProvider
implements CassandraTypeProvider {
    public List<AbstractTypeDeserializer> deserializers() {
        DebeziumTypeDeserializer deserializer = new DebeziumTypeDeserializer(){

            public Object deserialize(Object abstractType, ByteBuffer bb) {
                return ((AbstractType)abstractType).getSerializer().deserialize(bb);
            }
        };
        List<AbstractTypeDeserializer> deserializers = Arrays.asList(new AbstractTypeDeserializer[]{new BasicTypeDeserializer(deserializer, Integer.valueOf(4), (Object)BooleanType.instance, CassandraTypeKafkaSchemaBuilders.BOOLEAN_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(13), (Object)UTF8Type.instance, CassandraTypeKafkaSchemaBuilders.STRING_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(1), (Object)AsciiType.instance, CassandraTypeKafkaSchemaBuilders.STRING_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(20), (Object)ByteType.instance, CassandraTypeKafkaSchemaBuilders.BYTE_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(3), (Object)BytesType.instance, CassandraTypeKafkaSchemaBuilders.BYTES_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(8), (Object)FloatType.instance, CassandraTypeKafkaSchemaBuilders.FLOAT_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(7), (Object)DoubleType.instance, CassandraTypeKafkaSchemaBuilders.DOUBLE_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(9), (Object)Int32Type.instance, CassandraTypeKafkaSchemaBuilders.INT_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(19), (Object)ShortType.instance, CassandraTypeKafkaSchemaBuilders.SHORT_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(2), (Object)LongType.instance, CassandraTypeKafkaSchemaBuilders.LONG_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(18), (Object)TimeType.instance, CassandraTypeKafkaSchemaBuilders.LONG_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(5), (Object)CounterColumnType.instance, CassandraTypeKafkaSchemaBuilders.LONG_TYPE), new BasicTypeDeserializer(deserializer, Integer.valueOf(17), (Object)SimpleDateType.instance, CassandraTypeKafkaSchemaBuilders.DATE_TYPE), new InetAddressDeserializer(deserializer, (Object)InetAddressType.instance), new TimestampTypeDeserializer(deserializer, (Object)TimestampType.instance), new UUIDTypeDeserializer(deserializer, (Object)UUIDType.instance), new TimeUUIDTypeDeserializer(deserializer, (Object)TimeUUIDType.instance), new DecimalTypeDeserializer(deserializer, (Object)DecimalType.instance), new VarIntTypeDeserializer(deserializer, (Object)IntegerType.instance), new DurationTypeDeserializer(deserializer), new ListTypeDeserializer(deserializer), new SetTypeDeserializer(deserializer), new MapTypeDeserializer(deserializer), new TupleTypeDeserializer(deserializer), new UserDefinedTypeDeserializer(deserializer)});
        return Collections.unmodifiableList(deserializers);
    }

    public Function<Object, Object> baseTypeForReversedType() {
        return abstractType -> ((AbstractType)abstractType).isReversed() ? ((ReversedType)abstractType).baseType : abstractType;
    }

    public String getClusterName() {
        return DatabaseDescriptor.getClusterName();
    }
}

