/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.build;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;

public class BuildMetricsDevUIController {
    private static final Logger LOG = Logger.getLogger((String)BuildMetricsDevUIController.class.getName());
    private static final BuildMetricsDevUIController INSTANCE = new BuildMetricsDevUIController();
    private Path buildMetricsPath;
    private volatile Map<String, Object> buildStepsMetrics;

    public static BuildMetricsDevUIController get() {
        return INSTANCE;
    }

    private BuildMetricsDevUIController() {
    }

    void setBuildMetricsPath(Path buildMetricsPath) {
        this.buildMetricsPath = buildMetricsPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getBuildStepsMetrics() {
        if (this.buildStepsMetrics != null) {
            return this.buildStepsMetrics;
        }
        BuildMetricsDevUIController buildMetricsDevUIController = this;
        synchronized (buildMetricsDevUIController) {
            if (this.buildStepsMetrics != null) {
                return this.buildStepsMetrics;
            }
            this.buildStepsMetrics = this.prepareBuildStepsMetrics();
            return this.buildStepsMetrics;
        }
    }

    public Map<String, Object> prepareBuildStepsMetrics() {
        long currentSlot;
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        HashMap<String, JsonObject> stepIdToRecord = new HashMap<String, JsonObject>();
        HashMap<Integer, JsonObject> recordIdToRecord = new HashMap<Integer, JsonObject>();
        HashMap<String, ArrayList<JsonObject>> threadToRecords = new HashMap<String, ArrayList<JsonObject>>();
        long buildDuration = 0L;
        LocalTime buildStarted = null;
        if (Files.isReadable(this.buildMetricsPath)) {
            try {
                JsonObject data = new JsonObject(Files.readString(this.buildMetricsPath));
                buildDuration = data.getLong("duration");
                buildStarted = LocalDateTime.parse(data.getString("started"), DateTimeFormatter.ISO_LOCAL_DATE_TIME).toLocalTime();
                JsonArray records = data.getJsonArray("records");
                for (Object record : records) {
                    JsonObject recordObj = (JsonObject)record;
                    recordObj.put("encodedStepId", (Object)URLEncoder.encode(recordObj.getString("stepId"), StandardCharsets.UTF_8.toString()));
                    String thread = recordObj.getString("thread");
                    stepIdToRecord.put(recordObj.getString("stepId"), recordObj);
                    recordIdToRecord.put(recordObj.getInteger("id"), recordObj);
                    ArrayList<JsonObject> steps = (ArrayList<JsonObject>)threadToRecords.get(thread);
                    if (steps == null) {
                        steps = new ArrayList<JsonObject>();
                        threadToRecords.put(thread, steps);
                    }
                    steps.add(recordObj);
                }
                metrics.put("records", records);
                metrics.put("items", data.getJsonArray("items"));
                metrics.put("itemsCount", data.getInteger("itemsCount"));
                metrics.put("duration", buildDuration);
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        HashMap<String, JsonObject> dependencyGraphs = new HashMap<String, JsonObject>();
        for (Map.Entry e : stepIdToRecord.entrySet()) {
            dependencyGraphs.put((String)e.getKey(), this.buildDependencyGraph((JsonObject)e.getValue(), stepIdToRecord, recordIdToRecord).toJson());
        }
        metrics.put("dependencyGraphs", dependencyGraphs);
        long slotDuration = Math.max(10L, buildDuration / 100L);
        ArrayList<Long> slots = new ArrayList<Long>();
        for (currentSlot = slotDuration; currentSlot < buildDuration; currentSlot += slotDuration) {
            slots.add(currentSlot);
        }
        if (currentSlot != buildDuration) {
            slots.add(buildDuration);
        }
        metrics.put("slots", slots);
        HashMap threadToSlotRecords = new HashMap();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        for (Map.Entry entry : threadToRecords.entrySet()) {
            String thread = (String)entry.getKey();
            List records = (List)entry.getValue();
            ArrayList threadSlots = new ArrayList();
            for (Long slot : slots) {
                ArrayList<String> slotRecords = new ArrayList<String>();
                for (JsonObject record : records) {
                    LocalTime started = LocalTime.parse(record.getString("started"), formatter);
                    long startAt = Duration.between(buildStarted, started).toMillis();
                    if (startAt >= slot || slot - slotDuration >= startAt + record.getLong("duration")) continue;
                    slotRecords.add(record.getString("stepId"));
                }
                threadSlots.add(slotRecords);
            }
            threadToSlotRecords.put(thread, threadSlots);
        }
        metrics.put("threadSlotRecords", threadToSlotRecords);
        return metrics;
    }

    DependencyGraph buildDependencyGraph(JsonObject step, Map<String, JsonObject> stepIdToRecord, Map<Integer, JsonObject> recordIdToRecord) {
        HashSet<DependencyGraph.Node> nodes = new HashSet<DependencyGraph.Node>();
        HashSet<DependencyGraph.Link> links = new HashSet<DependencyGraph.Link>();
        this.addNodesDependents(step, nodes, links, step, stepIdToRecord, recordIdToRecord);
        this.addNodeDependencies(step, nodes, links, step, stepIdToRecord, recordIdToRecord);
        return new DependencyGraph(nodes, links);
    }

    void addNodesDependents(JsonObject root, Set<DependencyGraph.Node> nodes, Set<DependencyGraph.Link> links, JsonObject record, Map<String, JsonObject> stepIdToRecord, Map<Integer, JsonObject> recordIdToRecord) {
        String stepId = record.getString("stepId");
        nodes.add(new DependencyGraph.Node(stepId, record.getString("encodedStepId")));
        for (Object dependentRecordId : record.getJsonArray("dependents")) {
            int recordId = (Integer)dependentRecordId;
            if (recordId == record.getInteger("id")) continue;
            JsonObject dependentRecord = recordIdToRecord.get(recordId);
            String dependentStepId = dependentRecord.getString("stepId");
            links.add(DependencyGraph.Link.dependent(root.equals((Object)record), dependentStepId, stepId));
            nodes.add(new DependencyGraph.Node(dependentStepId, dependentRecord.getString("encodedStepId")));
        }
    }

    void addNodeDependencies(JsonObject root, Set<DependencyGraph.Node> nodes, Set<DependencyGraph.Link> links, JsonObject record, Map<String, JsonObject> stepIdToRecord, Map<Integer, JsonObject> recordIdToRecord) {
        for (Map.Entry<String, JsonObject> entry : stepIdToRecord.entrySet()) {
            for (Object dependentRecordId : entry.getValue().getJsonArray("dependents")) {
                int recordId = (Integer)dependentRecordId;
                if (record.getInteger("id") != recordId) continue;
                links.add(DependencyGraph.Link.dependency(root.equals((Object)record), record.getString("stepId"), entry.getValue().getString("stepId")));
                nodes.add(new DependencyGraph.Node(entry.getValue().getString("stepId"), entry.getValue().getString("encodedStepId")));
            }
        }
    }

    public static class DependencyGraph {
        public final Set<Node> nodes;
        public final Set<Link> links;

        public DependencyGraph(Set<Node> nodes, Set<Link> links) {
            this.nodes = nodes;
            this.links = links;
        }

        public JsonObject toJson() {
            JsonObject dependencyGraph = new JsonObject();
            JsonArray nodes = new JsonArray();
            JsonArray links = new JsonArray();
            for (Node node : this.nodes) {
                nodes.add((Object)node.toJson());
            }
            for (Link link : this.links) {
                links.add((Object)link.toJson());
            }
            dependencyGraph.put("nodes", (Object)nodes);
            dependencyGraph.put("links", (Object)links);
            return dependencyGraph;
        }

        public static class Link {
            public final String source;
            public final String target;
            public final String type;

            static Link dependent(boolean direct, String source, String target) {
                return new Link(source, target, direct ? "directDependent" : "dependency");
            }

            static Link dependency(boolean direct, String source, String target) {
                return new Link(source, target, direct ? "directDependency" : "dependency");
            }

            public Link(String source, String target, String type) {
                this.source = source;
                this.target = target;
                this.type = type;
            }

            public JsonObject toJson() {
                JsonObject link = new JsonObject();
                link.put("source", (Object)this.source);
                link.put("target", (Object)this.target);
                link.put("type", (Object)this.type);
                return link;
            }

            public int hashCode() {
                return Objects.hash(this.source, this.target);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Link other = (Link)obj;
                return Objects.equals(this.source, other.source) && Objects.equals(this.target, other.target);
            }
        }

        public static class Node {
            public final String stepId;
            public final String simpleName;
            public final String encodedStepId;

            public Node(String stepId, String encodedStepId) {
                this.stepId = stepId;
                this.encodedStepId = encodedStepId;
                int lastDot = stepId.lastIndexOf(46);
                Object simple = lastDot > 0 ? stepId.substring(lastDot + 1) : stepId;
                int hash = ((String)simple).indexOf(35);
                if (hash > 0) {
                    char[] chars;
                    StringBuilder sb = new StringBuilder();
                    for (char c : chars = ((String)simple).substring(0, hash).toCharArray()) {
                        if (!Character.isUpperCase(c)) continue;
                        sb.append(c);
                    }
                    simple = sb + ((String)simple).substring(hash);
                }
                this.simpleName = simple;
            }

            public JsonObject toJson() {
                JsonObject node = new JsonObject();
                node.put("stepId", (Object)this.stepId);
                node.put("simpleName", (Object)this.simpleName);
                node.put("encodedStepId", (Object)this.encodedStepId);
                return node;
            }

            public int hashCode() {
                return Objects.hash(this.stepId);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Node other = (Node)obj;
                return Objects.equals(this.stepId, other.stepId);
            }
        }
    }
}

