/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.SchemaResolverConfigurer;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.converter.json.FormatStrategy;
import io.apicurio.registry.utils.converter.json.JsonConverterMetadata;
import io.apicurio.registry.utils.converter.json.JsonConverterRecord;
import io.apicurio.registry.utils.converter.json.PrettyFormatStrategy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;

public class ExtJsonConverter
extends SchemaResolverConfigurer<JsonNode, Object>
implements Converter,
SchemaParser<JsonNode, Object>,
AutoCloseable {
    private final JsonConverter jsonConverter = new JsonConverter();
    private final ObjectMapper mapper = new ObjectMapper();
    private FormatStrategy formatStrategy = new PrettyFormatStrategy();
    private boolean isKey;

    public ExtJsonConverter() {
        this(null);
    }

    public ExtJsonConverter(RegistryClient client) {
        super(client);
    }

    public ExtJsonConverter setFormatStrategy(FormatStrategy formatStrategy) {
        this.formatStrategy = Objects.requireNonNull(formatStrategy);
        return this;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey, (SchemaParser)this);
        this.isKey = isKey;
        HashMap wrapper = new HashMap(configs);
        wrapper.put("schemas.enable", false);
        this.jsonConverter.configure(wrapper, isKey);
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        return this.fromConnectData(topic, null, schema, value);
    }

    public byte[] fromConnectData(String topic, Headers headers, Schema schema, Object value) {
        if (schema == null && value == null) {
            return null;
        }
        JsonConverterRecord<Object> record = new JsonConverterRecord<Object>(new JsonConverterMetadata(topic, this.isKey, headers, schema), value);
        SchemaLookupResult schemaLookupResult = this.getSchemaResolver().resolveSchema(record);
        byte[] payload = this.jsonConverter.fromConnectData(topic, schema, value);
        return this.formatStrategy.fromConnectData(schemaLookupResult.getGlobalId(), payload);
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        FormatStrategy.IdPayload ip = this.formatStrategy.toConnectData(value);
        long globalId = ip.getGlobalId();
        SchemaLookupResult schemaLookupResult = this.getSchemaResolver().resolveSchemaByArtifactReference((ArtifactReference)ArtifactReference.builder().globalId(Long.valueOf(globalId)).build());
        Schema schema = this.jsonConverter.asConnectSchema((JsonNode)schemaLookupResult.getParsedSchema().getParsedSchema());
        byte[] payload = ip.getPayload();
        SchemaAndValue sav = this.jsonConverter.toConnectData(topic, payload);
        return new SchemaAndValue(schema, sav.value());
    }

    public String artifactType() {
        return "KCONNECT";
    }

    public JsonNode parseSchema(byte[] rawSchema, Map<String, ParsedSchema<JsonNode>> resolvedReferences) {
        try {
            return this.mapper.readTree(rawSchema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ParsedSchema<JsonNode> getSchemaFromData(Record<Object> data) {
        JsonConverterRecord jcr = (JsonConverterRecord)data;
        ObjectNode jsonSchema = this.jsonConverter.asJsonSchema(jcr.metadata().getSchema());
        String schemaString = jsonSchema != null ? jsonSchema.toString() : null;
        return new ParsedSchemaImpl().setParsedSchema((Object)jsonSchema).setRawSchema(IoUtil.toBytes((String)schemaString));
    }

    @Override
    public void close() throws Exception {
        this.jsonConverter.close();
    }
}

