/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class ClusterConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ClusterConfiguration> {
    private final List<ServerConfigurationBuilder> servers = new ArrayList<ServerConfigurationBuilder>();
    private final String clusterName;
    private ClientIntelligence intelligence;

    protected ClusterConfigurationBuilder(ConfigurationBuilder builder, String clusterName) {
        super(builder);
        this.clusterName = clusterName;
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterConfigurationBuilder addClusterNode(String host, int port) {
        ServerConfigurationBuilder serverBuilder = new ServerConfigurationBuilder(this.builder);
        this.servers.add(serverBuilder.host(host).port(port));
        return this;
    }

    public ClusterConfigurationBuilder addClusterNodes(String serverList) {
        ConfigurationBuilder.parseServers(serverList, (host, port) -> {
            ServerConfigurationBuilder serverBuilder = new ServerConfigurationBuilder(this.builder);
            this.servers.add(serverBuilder.host((String)host).port((int)port));
        });
        return this;
    }

    public ClusterConfigurationBuilder clusterClientIntelligence(ClientIntelligence intelligence) {
        this.intelligence = intelligence;
        return this;
    }

    public void validate() {
        if (this.clusterName == null || this.clusterName.isEmpty()) {
            throw Log.HOTROD.missingClusterNameDefinition();
        }
        if (this.servers.isEmpty()) {
            throw Log.HOTROD.missingClusterServersDefinition(this.clusterName);
        }
        for (ServerConfigurationBuilder serverConfigBuilder : this.servers) {
            serverConfigBuilder.validate();
        }
    }

    public ClusterConfiguration create() {
        List<ServerConfiguration> serverCluster = this.servers.stream().map(ServerConfigurationBuilder::create).collect(Collectors.toList());
        return new ClusterConfiguration(serverCluster, this.clusterName, this.intelligence);
    }

    public Builder<?> read(ClusterConfiguration template) {
        template.getCluster().forEach(server -> this.addClusterNode(server.host(), server.port()));
        this.clusterClientIntelligence(template.getClientIntelligence());
        return this;
    }
}

