/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree;

import org.psjava.ds.array.DynamicArray;
import org.psjava.util.AssertStatus;
import org.psjava.util.BooleanIterable;

public class BinaryTreeByArray<T> {
    private DynamicArray<T> array = DynamicArray.create();

    public int createRoot(T value) {
        this.array.clear();
        this.array.addToLast(value);
        return 0;
    }

    public boolean hasRoot() {
        return this.hasNode(0);
    }

    public int getRootPointer() {
        this.assertHasNode(0);
        return 0;
    }

    public T getValue(int pointer) {
        this.assertHasNode(pointer);
        return this.array.get(pointer);
    }

    public void setValue(int pointer, T value) {
        this.assertHasNode(pointer);
        this.array.set(pointer, value);
    }

    public boolean hasChild(int pointer, boolean edge) {
        this.assertHasNode(pointer);
        return this.hasNode(BinaryTreeByArray.calcChildPointer(pointer, edge));
    }

    public int getLeft(int node) {
        return this.getChild(node, false);
    }

    public int getRight(int node) {
        return this.getChild(node, true);
    }

    private int getChild(int node, boolean edge) {
        this.assertHasNode(node);
        int c = BinaryTreeByArray.calcChildPointer(node, edge);
        this.assertHasNode(c);
        return c;
    }

    public int putChild(int pointer, boolean edge, T value) {
        this.assertHasNode(pointer);
        int childIndex = BinaryTreeByArray.calcChildPointer(pointer, edge);
        while (this.array.size() <= childIndex) {
            this.array.addToLast(null);
        }
        this.array.set(childIndex, value);
        return childIndex;
    }

    public void remove(int pointer) {
        this.assertHasNode(pointer);
        for (boolean v : BooleanIterable.getInstance()) {
            if (!this.hasChild(pointer, v)) continue;
            this.remove(this.getChild(pointer, v));
        }
        this.array.set(pointer, null);
    }

    private void assertHasNode(int pointer) {
        AssertStatus.assertTrue(this.hasNode(pointer));
    }

    private boolean hasNode(int pointer) {
        return pointer < this.array.size() && this.array.get(pointer) != null;
    }

    private static int calcChildPointer(int index, boolean edge) {
        return index * 2 + (edge ? 2 : 1);
    }

    public String toString() {
        if (this.hasRoot()) {
            return BinaryTreeByArray.toString(this, this.getRootPointer());
        }
        return "empty";
    }

    private static <T> String toString(BinaryTreeByArray<T> tree, int pointer) {
        String r = "";
        for (boolean b : BooleanIterable.getInstance()) {
            if (!tree.hasChild(pointer, b)) continue;
            r = r.length() == 0 ? r + "(" : r + ",";
            r = r + (b ? 1 : 0) + ":" + BinaryTreeByArray.toString(tree, super.getChild(pointer, b));
        }
        if (r.length() > 0) {
            r = r + ")";
        }
        return tree.getValue(pointer) + r;
    }
}

