/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.bindings.kafka;

import io.debezium.annotation.Immutable;
import io.debezium.data.Envelope;
import io.debezium.sink.DebeziumSinkRecord;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.util.Strings;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

@Immutable
public class KafkaDebeziumSinkRecord
implements DebeziumSinkRecord {
    protected final SinkRecord originalKafkaRecord;

    public KafkaDebeziumSinkRecord(SinkRecord record) {
        this.originalKafkaRecord = record;
    }

    @Override
    public String topicName() {
        return this.originalKafkaRecord.topic();
    }

    @Override
    public Integer partition() {
        return this.originalKafkaRecord.kafkaPartition();
    }

    @Override
    public long offset() {
        return this.originalKafkaRecord.kafkaOffset();
    }

    @Override
    public List<String> keyFieldNames() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Object key() {
        return this.originalKafkaRecord.key();
    }

    @Override
    public Schema keySchema() {
        return this.originalKafkaRecord.keySchema();
    }

    @Override
    public Object value() {
        return this.originalKafkaRecord.value();
    }

    @Override
    public Schema valueSchema() {
        return this.originalKafkaRecord.valueSchema();
    }

    @Override
    public boolean isDebeziumMessage() {
        return this.originalKafkaRecord.value() != null && this.originalKafkaRecord.valueSchema().name() != null && this.originalKafkaRecord.valueSchema().name().contains("Envelope");
    }

    @Override
    public boolean isSchemaChange() {
        return this.originalKafkaRecord.valueSchema() != null && !Strings.isNullOrEmpty((String)this.originalKafkaRecord.valueSchema().name()) && this.originalKafkaRecord.valueSchema().name().contains("SchemaChangeValue");
    }

    public boolean isFlattened() {
        return !this.isTombstone() && (this.originalKafkaRecord.valueSchema().name() == null || !this.originalKafkaRecord.valueSchema().name().contains("Envelope"));
    }

    @Override
    public boolean isTombstone() {
        return this.originalKafkaRecord.value() == null && this.originalKafkaRecord.valueSchema() == null;
    }

    @Override
    public boolean isDelete() {
        if (!this.isDebeziumMessage()) {
            return this.originalKafkaRecord.value() == null;
        }
        if (this.originalKafkaRecord.value() != null) {
            Struct value = (Struct)this.originalKafkaRecord.value();
            return Envelope.Operation.DELETE.equals((Object)Envelope.Operation.forCode((String)value.getString("op")));
        }
        return false;
    }

    @Override
    public boolean isTruncate() {
        if (this.isDebeziumMessage()) {
            Struct value = (Struct)this.originalKafkaRecord.value();
            return Envelope.Operation.TRUNCATE.equals((Object)Envelope.Operation.forCode((String)value.getString("op")));
        }
        return false;
    }

    @Override
    public Struct getPayload() {
        if (this.isDebeziumMessage()) {
            return ((Struct)this.originalKafkaRecord.value()).getStruct("after");
        }
        return (Struct)this.originalKafkaRecord.value();
    }

    @Override
    public Struct getKeyStruct(SinkConnectorConfig.PrimaryKeyMode primaryKeyMode) {
        if (!this.keyFieldNames().isEmpty()) {
            switch (primaryKeyMode) {
                case RECORD_KEY: {
                    Schema keySchema = this.originalKafkaRecord.keySchema();
                    if (keySchema != null && Schema.Type.STRUCT.equals((Object)keySchema.type())) {
                        return (Struct)this.originalKafkaRecord.key();
                    }
                    throw new ConnectException("No struct-based primary key defined for record key.");
                }
                case RECORD_VALUE: {
                    Schema valueSchema = this.originalKafkaRecord.valueSchema();
                    if (valueSchema != null && Schema.Type.STRUCT.equals((Object)valueSchema.type())) {
                        return this.getPayload();
                    }
                    throw new ConnectException("No struct-based primary key defined for record value.");
                }
                case RECORD_HEADER: {
                    SchemaBuilder headerSchemaBuilder = SchemaBuilder.struct();
                    this.originalKafkaRecord.headers().forEach(header -> headerSchemaBuilder.field(header.key(), header.schema()));
                    Schema headerSchema = headerSchemaBuilder.build();
                    Struct headerStruct = new Struct(headerSchema);
                    this.originalKafkaRecord.headers().forEach(header -> headerStruct.put(header.key(), header.value()));
                    return headerStruct;
                }
            }
        }
        return null;
    }

    public SinkRecord getOriginalKafkaRecord() {
        return this.originalKafkaRecord;
    }
}

