/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.jdbc.history;

import io.debezium.DebeziumException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.storage.jdbc.RetriableConnection;
import io.debezium.storage.jdbc.history.JdbcSchemaHistoryConfig;
import io.debezium.util.FunctionalReadWriteLock;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Incubating
public final class JdbcSchemaHistory
extends AbstractSchemaHistory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSchemaHistory.class);
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();
    private final DocumentWriter writer = DocumentWriter.defaultWriter();
    private final DocumentReader reader = DocumentReader.defaultReader();
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicInteger recordInsertSeq = new AtomicInteger(0);
    private RetriableConnection conn;
    private JdbcSchemaHistoryConfig config;

    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        this.config = new JdbcSchemaHistoryConfig(config);
        if (this.running.get()) {
            throw new IllegalStateException("Database history already initialized db: " + this.config.getJdbcUrl());
        }
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
        try {
            this.conn = new RetriableConnection(this.config.getJdbcUrl(), this.config.getUser(), this.config.getPassword(), this.config.getWaitRetryDelay(), this.config.getMaxRetryCount());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to connect " + this.config.getJdbcUrl(), e);
        }
    }

    public void start() {
        super.start();
        this.lock.write(() -> {
            if (this.running.compareAndSet(false, true)) {
                if (!this.conn.isOpen()) {
                    throw new IllegalStateException("Database connection must be set before it is started");
                }
                try {
                    if (!this.storageExists()) {
                        this.initializeStorage();
                    }
                }
                catch (Exception e) {
                    throw new SchemaHistoryException("Unable to create history table " + this.config.getJdbcUrl() + ": " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    protected void storeRecord(HistoryRecord record) throws SchemaHistoryException {
        if (record == null) {
            return;
        }
        this.lock.write(() -> {
            if (!this.running.get()) {
                throw new IllegalStateException("The history has been stopped and will not accept more records");
            }
            try {
                this.conn.executeWithRetry(conn -> {
                    String line = null;
                    try {
                        line = this.writer.write(record.document());
                    }
                    catch (IOException e) {
                        throw new DebeziumException((Throwable)e);
                    }
                    Timestamp currentTs = new Timestamp(System.currentTimeMillis());
                    List<String> substrings = JdbcSchemaHistory.split(line, 65000);
                    int partSeq = 0;
                    for (String dataPart : substrings) {
                        PreparedStatement sql = conn.prepareStatement(this.config.getTableInsert());
                        try {
                            sql.setString(1, UUID.randomUUID().toString());
                            sql.setString(2, dataPart);
                            sql.setInt(3, partSeq);
                            sql.setTimestamp(4, currentTs);
                            sql.setInt(5, this.recordInsertSeq.incrementAndGet());
                            sql.executeUpdate();
                            ++partSeq;
                        }
                        finally {
                            if (sql == null) continue;
                            sql.close();
                        }
                    }
                    conn.commit();
                }, "store history record", true);
            }
            catch (SQLException e) {
                throw new SchemaHistoryException("Failed to store record: " + record, (Throwable)e);
            }
        });
    }

    private static List<String> split(String s, int chunkSize) {
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i < s.length(); i += chunkSize) {
            chunks.add(s.substring(i, Math.min(s.length(), i + chunkSize)));
        }
        return chunks;
    }

    public void stop() {
        this.running.set(false);
        super.stop();
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Exception during stop", (Throwable)e);
        }
    }

    protected synchronized void recoverRecords(Consumer<HistoryRecord> records) {
        this.lock.write(() -> {
            try {
                if (this.exists()) {
                    this.conn.executeWithRetry(conn -> {
                        try (Statement stmt = conn.createStatement();){
                            ResultSet rs = stmt.executeQuery(this.config.getTableSelect());
                            block12: while (true) {
                                while (rs.next()) {
                                    String historyData = rs.getString("history_data");
                                    if (historyData.isEmpty()) continue;
                                    try {
                                        records.accept(new HistoryRecord(this.reader.read(historyData)));
                                        continue block12;
                                    }
                                    catch (IOException e) {
                                        throw new DebeziumException((Throwable)e);
                                        return;
                                    }
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                    }, "recover history records", false);
                } else {
                    LOG.error("Storage does not exist when recovering records");
                }
            }
            catch (SQLException e) {
                throw new SchemaHistoryException("Failed to recover records", (Throwable)e);
            }
        });
    }

    public boolean storageExists() {
        try {
            return this.conn.executeWithRetry(conn -> {
                boolean exists = false;
                DatabaseMetaData dbMeta = conn.getMetaData();
                String databaseName = this.config.getDatabaseName();
                try (ResultSet tableExists = dbMeta.getTables(databaseName, null, this.config.getTableName(), null);){
                    if (tableExists.next()) {
                        exists = true;
                    }
                    Boolean bl = exists;
                    return bl;
                }
            }, "history storage exists", false);
        }
        catch (SQLException e) {
            throw new SchemaHistoryException("Failed to check database history storage", (Throwable)e);
        }
    }

    public boolean exists() {
        if (!this.storageExists()) {
            return false;
        }
        try {
            return this.conn.executeWithRetry(conn -> {
                boolean isExists = false;
                try (Statement stmt = conn.createStatement();){
                    Boolean bl;
                    block13: {
                        ResultSet rs = stmt.executeQuery(this.config.getTableDataExistsSelect());
                        try {
                            while (rs.next()) {
                                isExists = true;
                            }
                            bl = isExists;
                            if (rs == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl;
                }
            }, "history records exist check", false);
        }
        catch (SQLException e) {
            throw new SchemaHistoryException("Failed to recover records", (Throwable)e);
        }
    }

    JdbcSchemaHistoryConfig getConfig() {
        return this.config;
    }

    public String toString() {
        return "Jdbc database: " + (this.config != null ? this.config.getJdbcUrl() : "(unstarted)");
    }

    public void initializeStorage() {
        try {
            this.conn.executeWithRetry(conn -> {
                DatabaseMetaData dbMeta = conn.getMetaData();
                try (ResultSet tableExists = dbMeta.getTables(null, null, this.config.getTableName(), null);){
                    if (tableExists.next()) {
                        return;
                    }
                    LOG.info("Creating table {} to store database history", (Object)this.config.getTableName());
                    try (PreparedStatement ps = conn.prepareStatement(this.config.getTableCreate());){
                        ps.execute();
                        LOG.info("Created table in given database...");
                    }
                    conn.commit();
                }
            }, "initialize storage", false);
        }
        catch (SQLException e) {
            throw new SchemaHistoryException("Error initializing Database history storage", (Throwable)e);
        }
    }
}

