/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.jdbc.history;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.storage.jdbc.JdbcCommonConfig;
import io.debezium.util.Collect;
import java.util.List;

public class JdbcSchemaHistoryConfig
extends JdbcCommonConfig {
    private static final String DEFAULT_TABLE_NAME = "debezium_database_history";
    public static final Field PROP_TABLE_NAME = Field.create((String)"jdbc.schema.history.table.name").withDescription("The database key that will be used to store the database schema history").withDefault("debezium_database_history");
    private static final String DEFAULT_TABLE_DDL = "CREATE TABLE %s(id VARCHAR(36) NOT NULL,history_data VARCHAR(65000),history_data_seq INTEGER,record_insert_ts TIMESTAMP NOT NULL,record_insert_seq INTEGER NOT NULL)";
    public static final Field PROP_TABLE_DDL = Field.create((String)"jdbc.schema.history.table.ddl").withDescription("CREATE TABLE statement for schema history table").withDefault("CREATE TABLE %s(id VARCHAR(36) NOT NULL,history_data VARCHAR(65000),history_data_seq INTEGER,record_insert_ts TIMESTAMP NOT NULL,record_insert_seq INTEGER NOT NULL)");
    private static final String DEFAULT_TABLE_SELECT = "SELECT id, history_data, history_data_seq FROM %s ORDER BY record_insert_ts, record_insert_seq, id, history_data_seq";
    public static final Field PROP_TABLE_SELECT = Field.create((String)"jdbc.schema.history.table.select").withDescription("SELECT statement to get the schema history from a database table").withDefault("SELECT id, history_data, history_data_seq FROM %s ORDER BY record_insert_ts, record_insert_seq, id, history_data_seq");
    private static final String DEFAULT_TABLE_DATA_EXISTS_SELECT = "SELECT * FROM %s LIMIT 1";
    public static final Field PROP_TABLE_DATA_EXISTS_SELECT = Field.create((String)"jdbc.schema.history.table.select").withDescription("SELECT statement to check existence of the storage table").withDefault("SELECT * FROM %s LIMIT 1");
    private static final String DEFAULT_TABLE_DATA_INSERT = "INSERT INTO %s(id, history_data, history_data_seq, record_insert_ts, record_insert_seq) VALUES ( ?, ?, ?, ?, ? )";
    public static final Field PROP_TABLE_DATA_INSERT = Field.create((String)"jdbc.schema.history.table.insert").withDescription("INSERT statement to add new records to the schema storage table").withDefault("INSERT INTO %s(id, history_data, history_data_seq, record_insert_ts, record_insert_seq) VALUES ( ?, ?, ?, ?, ? )");
    private String tableName;
    private String tableCreate;
    private String tableSelect;
    private String tableDataExistsSelect;
    private String tableInsert;
    private String databaseName;

    public JdbcSchemaHistoryConfig(Configuration config) {
        super(config, "schema.history.internal.");
    }

    @Override
    protected void init(Configuration config) {
        super.init(config);
        this.splitDatabaseAndTableName(config.getString(PROP_TABLE_NAME));
        this.tableCreate = String.format(config.getString(PROP_TABLE_DDL), this.tableName);
        this.tableSelect = String.format(config.getString(PROP_TABLE_SELECT), this.tableName);
        this.tableDataExistsSelect = String.format(config.getString(PROP_TABLE_DATA_EXISTS_SELECT), this.tableName);
        this.tableInsert = String.format(config.getString(PROP_TABLE_DATA_INSERT), this.tableName);
    }

    @Override
    protected List<Field> getAllConfigurationFields() {
        List fields = Collect.arrayListOf((Object)PROP_TABLE_NAME, (Object[])new Field[]{PROP_TABLE_DDL, PROP_TABLE_SELECT, PROP_TABLE_DATA_EXISTS_SELECT, PROP_TABLE_DATA_INSERT});
        fields.addAll(super.getAllConfigurationFields());
        return fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableCreate() {
        return this.tableCreate;
    }

    public String getTableSelect() {
        return this.tableSelect;
    }

    public String getTableDataExistsSelect() {
        return this.tableDataExistsSelect;
    }

    public String getTableInsert() {
        return this.tableInsert;
    }

    void splitDatabaseAndTableName(String databaseAndTableName) {
        if (databaseAndTableName != null) {
            String[] parts = databaseAndTableName.split("\\.");
            if (parts.length == 2) {
                this.databaseName = parts[0];
                this.tableName = parts[1];
            } else {
                this.tableName = databaseAndTableName;
            }
        }
    }
}

