/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.openshift.tools.ConfigProperties;
import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.debezium.testing.openshift.tools.registry.RegistryDeployer;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryController.class);
    private final ApicurioRegistry registry;
    private final OpenShiftClient ocp;
    private final OkHttpClient http;
    private final String project;
    private final OpenShiftUtils ocpUtils;

    public RegistryController(ApicurioRegistry registry, OpenShiftClient ocp, OkHttpClient http) {
        this.registry = registry;
        this.ocp = ocp;
        this.http = http;
        this.project = registry.getMetadata().getNamespace();
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public String getRegistryAddress() {
        Service s = this.getRegistryService();
        return "http://" + s.getMetadata().getName() + "." + ConfigProperties.OCP_PROJECT_REGISTRY + ".svc.cluster.local:8080";
    }

    public String getRegistryApiAddress() {
        return this.getRegistryAddress() + "/api";
    }

    public String getPublicRegistryAddress() {
        List items = ((RouteList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.routes().inNamespace(this.project)).withLabel("apicur.io/name=", this.registry.getMetadata().getName())).list()).getItems();
        if (items.isEmpty()) {
            throw new IllegalStateException("No route for registry '" + this.registry.getMetadata().getName() + "'");
        }
        String host = ((Route)items.get(0)).getSpec().getHost();
        return "http://" + host;
    }

    private Service getRegistryService() {
        List items = ((ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withLabel("app", this.registry.getMetadata().getName())).list()).getItems();
        if (items.isEmpty()) {
            throw new IllegalStateException("No service for registry '" + this.registry.getMetadata().getName() + "'");
        }
        return (Service)items.get(0);
    }

    public boolean undeployRegistry() {
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.ocp.apiextensions().v1().customResourceDefinitions().load(RegistryDeployer.class.getResourceAsStream("/apicur.io_apicurioregistries_crd.yaml"))).get();
        CustomResourceDefinitionContext context = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        return ((NonNamespaceOperation)this.ocp.customResources(context, ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project)).delete((Object[])new ApicurioRegistry[]{this.registry});
    }
}

