/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.util;

import io.debezium.testing.testcontainers.util.PortResolver;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledPortResolver
implements PortResolver {
    private final Logger LOGGER = LoggerFactory.getLogger(PooledPortResolver.class);
    protected final Set<Integer> ports = new HashSet<Integer>();
    protected final Set<Integer> usedPorts = new HashSet<Integer>();

    public PooledPortResolver(Set<Integer> ports) {
        if (ports == null || ports.isEmpty()) {
            throw new IllegalStateException("Expected a non empty set of ports");
        }
        this.ports.addAll(ports);
    }

    @Override
    public synchronized int resolveFreePort() {
        Optional<Integer> port = this.ports.stream().filter(Predicate.not(this.usedPorts::contains)).findFirst();
        port.ifPresent(this.usedPorts::add);
        return port.orElseThrow(() -> new IllegalStateException("No free ports remaining"));
    }

    @Override
    public synchronized void releasePort(int port) {
        this.usedPorts.remove(port);
    }
}

