/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.verify.Require;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    private static final FileFilter DIRECTORY_FILE_FILTER = File::isDirectory;
    private static final File[] EMPTY_DIRECTORY_ARRAY = new File[0];
    private static final FilenameFilter DIRECTORY_FILENAME_FILTER = (dir, name) -> new File(dir, name).isDirectory();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final char URI_SEPARATOR_CHAR = '/';
    public static final String URI_SEPARATOR = "/";
    public static final String REPEATED_URI_SEPARATOR = "//";
    public static final Pattern REPEATED_URI_SEPARATOR_PATTERN = Pattern.compile("//+");
    public static final String FILE_URI_SCHEME = "file";

    public static void cleanDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtils.cleanDirectory(files[i]);
                }
                if (files[i].delete()) continue;
                throw new RuntimeException("Couldn't delete " + files[i].getAbsolutePath());
            }
        }
    }

    public static void deleteRecursively(File file) {
        File[] files;
        if (!Files.exists(file.toPath(), LinkOption.NOFOLLOW_LINKS)) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                FileUtils.deleteRecursively(child);
            }
        }
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not delete file: " + file.getAbsolutePath(), e);
        }
    }

    public static void moveRecursively(File source, File destination, @Nullable FileFilter filter, boolean allowReplace) {
        Require.neqNull(source, "source");
        Require.requirement(source.isDirectory(), "source.isDirectory()");
        Require.neqNull(destination, "destination");
        Require.requirement(!destination.exists() || destination.isDirectory(), "!destination.exists() || destination.isDirectory()");
        FileUtils.moveRecursivelyInternal(source, destination, new RecursingNormalFileFilter(filter), allowReplace);
    }

    private static void moveRecursivelyInternal(File source, File destination, FileFilter filter, boolean allowReplace) {
        boolean sourceIsDirectory = source.isDirectory();
        if (sourceIsDirectory) {
            for (File file : source.listFiles(filter)) {
                FileUtils.moveRecursivelyInternal(file, new File(destination, file.getName()), filter, allowReplace);
            }
            return;
        }
        if (!allowReplace && destination.exists()) {
            return;
        }
        File destinationParent = destination.getParentFile();
        if (!destinationParent.isDirectory()) {
            if (destinationParent.exists()) {
                throw new IllegalArgumentException("Destination parent " + destinationParent.getAbsolutePath() + " exists but is not a directory,  when moving " + source.getAbsolutePath());
            }
            if (!destinationParent.mkdirs()) {
                throw new RuntimeException("Failed to create missing destination parent directory " + destinationParent.getAbsolutePath() + " when moving " + source.getAbsolutePath());
            }
        }
        if (!source.renameTo(destination)) {
            throw new RuntimeException("Failed to move file " + source.getAbsolutePath() + " to " + destination.getAbsolutePath());
        }
    }

    public static void deleteRecursivelyOnNFS(File file) {
        FileUtils.deleteRecursivelyOnNFS(new File(file.getParentFile(), "." + file.getName() + ".trash"), file);
    }

    public static void deleteRecursivelyOnNFS(File trashFile, File fileToBeDeleted) {
        if (fileToBeDeleted.isDirectory()) {
            File[] contents = fileToBeDeleted.listFiles();
            if (contents != null) {
                for (File childFile : contents) {
                    FileUtils.deleteRecursivelyOnNFS(trashFile, childFile);
                }
            }
            if (!fileToBeDeleted.delete()) {
                throw new RuntimeException("Failed to delete expected empty directory " + fileToBeDeleted.getAbsolutePath());
            }
        } else if (fileToBeDeleted.exists()) {
            if (!fileToBeDeleted.renameTo(trashFile)) {
                throw new RuntimeException("Failed to move file " + fileToBeDeleted.getAbsolutePath() + " to temporary location " + trashFile.getAbsolutePath());
            }
            if (!trashFile.delete()) {
                throw new RuntimeException("Failed to delete temporary location " + trashFile.getAbsolutePath() + " for file " + fileToBeDeleted.getAbsolutePath());
            }
        }
    }

    public static File[] findAllFiles(File dir) {
        ArrayList<File> results = new ArrayList<File>();
        FileUtils.__findAllSubDirectories(results, dir);
        return results.toArray(new File[results.size()]);
    }

    private static void __findAllSubDirectories(ArrayList<File> results, File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                FileUtils.__findAllSubDirectories(results, f);
                continue;
            }
            results.add(f);
        }
    }

    public static File[] missingSafeListFiles(File directory) {
        File[] result = Require.neqNull(directory, "directory").listFiles();
        return result == null ? EMPTY_DIRECTORY_ARRAY : result;
    }

    public static File[] missingSafeListFiles(File directory, FileFilter filter) {
        File[] result = Require.neqNull(directory, "directory").listFiles(filter);
        return result == null ? EMPTY_DIRECTORY_ARRAY : result;
    }

    public static File[] missingSafeListSubDirectories(File directory) {
        return FileUtils.missingSafeListFiles(directory, DIRECTORY_FILE_FILTER);
    }

    public static String[] missingSafeListFilenames(File directory) {
        String[] result = Require.neqNull(directory, "directory").list();
        return result == null ? EMPTY_STRING_ARRAY : result;
    }

    public static String[] missingSafeListFilenames(File directory, FilenameFilter filter) {
        String[] result = Require.neqNull(directory, "directory").list(filter);
        return result == null ? EMPTY_STRING_ARRAY : result;
    }

    public static String[] missingSafeListSubDirectoryNames(File directory) {
        return FileUtils.missingSafeListFilenames(directory, DIRECTORY_FILENAME_FILTER);
    }

    public static String readTextFile(File txtFile) throws IOException {
        if (!txtFile.exists()) {
            throw new IllegalArgumentException("File " + txtFile.getName() + " doesn't exist.");
        }
        if (txtFile.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("File " + txtFile.getName() + " exceeds the 2 GB limit.");
        }
        StringBuilder buffer = new StringBuilder((int)txtFile.length());
        FileInputStream in = new FileInputStream(txtFile);
        byte[] byteBuffer = new byte[(int)txtFile.length()];
        ((InputStream)in).read(byteBuffer);
        buffer.append(new String(byteBuffer));
        ((InputStream)in).close();
        return buffer.toString().trim();
    }

    public static String readTextFile(InputStream txtFile) throws IOException {
        StringBuilder buffer = new StringBuilder();
        byte[] byteBuffer = new byte[65536];
        int readAmount = txtFile.read(byteBuffer);
        while (readAmount > 0) {
            buffer.append(new String(byteBuffer, 0, readAmount));
            readAmount = txtFile.read(byteBuffer);
        }
        txtFile.close();
        return buffer.toString().trim();
    }

    public static URI convertToURI(String source, boolean isDirectory) {
        URI uri;
        if (source.isEmpty()) {
            throw new IllegalArgumentException("Cannot convert empty source to URI");
        }
        try {
            boolean endsWithSlash;
            uri = new URI(source);
            if (uri.getScheme() == null) {
                return FileUtils.convertToURI(new File(source), isDirectory);
            }
            if (uri.getScheme().equals(FILE_URI_SCHEME)) {
                return FileUtils.convertToURI(new File(uri), isDirectory);
            }
            Object path = uri.getPath();
            boolean bl = endsWithSlash = ((String)path).charAt(((String)path).length() - 1) == '/';
            if (!isDirectory && endsWithSlash) {
                throw new IllegalArgumentException("Non-directory URI should not end with a slash: " + uri);
            }
            boolean isUpdated = false;
            if (isDirectory && !endsWithSlash) {
                path = (String)path + URI_SEPARATOR;
                isUpdated = true;
            }
            if (((String)path).contains(REPEATED_URI_SEPARATOR)) {
                path = REPEATED_URI_SEPARATOR_PATTERN.matcher((CharSequence)path).replaceAll(URI_SEPARATOR);
                isUpdated = true;
            }
            if (isUpdated) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), (String)path, uri.getQuery(), uri.getFragment());
            }
        }
        catch (URISyntaxException e) {
            return FileUtils.convertToURI(new File(source), isDirectory);
        }
        return uri;
    }

    public static URI convertToURI(File file, boolean isDirectory) {
        Object absPath = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            absPath = ((String)absPath).replace(File.separatorChar, '/');
        }
        if (isDirectory && ((String)absPath).charAt(((String)absPath).length() - 1) != '/') {
            absPath = (String)absPath + URI_SEPARATOR;
        }
        if (((String)absPath).charAt(0) != '/') {
            absPath = URI_SEPARATOR + (String)absPath;
        }
        try {
            return new URI(FILE_URI_SCHEME, null, (String)absPath, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to convert file to URI: " + file, e);
        }
    }

    public static URI convertToURI(Path path, boolean isDirectory) {
        return FileUtils.convertToURI(path.toFile(), isDirectory);
    }

    private static class RecursingNormalFileFilter
    implements FileFilter {
        private final FileFilter normalFileFilter;

        private RecursingNormalFileFilter(FileFilter normalFileFilter) {
            this.normalFileFilter = normalFileFilter;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.isFile() && (this.normalFileFilter == null || this.normalFileFilter.accept(pathname));
        }
    }
}

