/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.MathUtil;
import io.deephaven.base.Predicate;
import io.deephaven.base.queue.ConcurrentQueue;
import io.deephaven.base.queue.ProducerConsumer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class LockFreeArrayQueue<T>
implements ConcurrentQueue<T>,
ProducerConsumer.MultiProducerConsumer<T> {
    final int cap;
    final int mask;
    final int shift;
    final AtomicInteger head;
    final AtomicInteger tail;
    final AtomicReferenceArray<Object> nodes;
    private static final int LOG2CAP_MIN = 4;
    private static final int LOG2CAP_MAX = 28;
    private final Object[] NULLS = new Object[2];
    private volatile boolean stopped = false;

    public static int getMinAllowedCapacity() {
        return 9;
    }

    public static int getMaxAllowedCapacity() {
        return 0x10000000;
    }

    public static <T> LockFreeArrayQueue<T> of(int desiredSize) {
        int maxAllowedCapacity = LockFreeArrayQueue.getMaxAllowedCapacity();
        if (desiredSize > maxAllowedCapacity) {
            throw new IllegalArgumentException(String.format("desiredSize > maxAllowedCapacity: %d > %d", desiredSize, maxAllowedCapacity));
        }
        int log2cap = MathUtil.ceilLog2(desiredSize);
        return new LockFreeArrayQueue<T>(Math.max(4, log2cap));
    }

    public LockFreeArrayQueue(int log2cap) {
        if (log2cap < 4 || log2cap > 28) {
            throw new IllegalArgumentException("log2cap must be in [4,28], got " + log2cap + ".");
        }
        this.cap = 1 << log2cap;
        this.mask = this.cap - 1;
        this.shift = log2cap;
        this.head = new AtomicInteger(0);
        this.tail = new AtomicInteger(1);
        this.NULLS[0] = new Object(){

            public String toString() {
                return "N0";
            }
        };
        this.NULLS[1] = new Object(){

            public String toString() {
                return "N1";
            }
        };
        this.nodes = new AtomicReferenceArray(this.cap);
        for (int i = 0; i < this.cap; ++i) {
            this.nodes.set(i, this.NULLS[1]);
        }
        this.nodes.set(0, this.NULLS[0]);
    }

    public void init() {
        this.head.set(0);
        this.tail.set(1);
        for (int i = 0; i < this.cap; ++i) {
            this.nodes.set(i, this.NULLS[1]);
        }
        this.nodes.set(0, this.NULLS[0]);
    }

    public int capacity() {
        return this.cap;
    }

    private Object get_node(int n) {
        return this.nodes.get(n & this.mask);
    }

    private boolean cas_node(int n, Object old_val, Object new_val) {
        return this.nodes.compareAndSet(n & this.mask, old_val, new_val);
    }

    private Object get_null(int head) {
        return this.NULLS[head >> this.shift & 1];
    }

    private boolean same_slot(int a, int b) {
        return (a & this.mask) == (b & this.mask);
    }

    private boolean is_null(Object value) {
        return value == this.NULLS[0] || value == this.NULLS[1];
    }

    private int pass_number(int index) {
        return index >> this.shift;
    }

    @Override
    public boolean enqueue(T new_value) {
        int new_tail;
        int tail0;
        if (new_value == null) {
            throw new IllegalArgumentException("TsigasZhangQueue cannot contain null elements");
        }
        while (true) {
            tail0 = this.tail.get();
            int head0 = this.head.get();
            int actual_tail = tail0;
            Object old_value = this.get_node(actual_tail);
            new_tail = actual_tail + 1;
            while (!this.is_null(old_value) && tail0 == this.tail.get() && !this.same_slot(new_tail, head0)) {
                actual_tail = new_tail++;
                old_value = this.get_node(actual_tail);
            }
            if (tail0 != this.tail.get()) continue;
            if (this.same_slot(new_tail, head0)) {
                actual_tail = new_tail + 1;
                old_value = this.get_node(actual_tail);
                if (!this.is_null(old_value)) {
                    return false;
                }
                this.head.compareAndSet(head0, head0 + 1);
                continue;
            }
            if (tail0 == this.tail.get() && this.cas_node(actual_tail, old_value, new_value)) break;
        }
        if (new_tail % 2 == 0) {
            this.tail.compareAndSet(tail0, new_tail);
        }
        return true;
    }

    @Override
    public boolean enqueue(T new_value, long spins_between_yields) {
        if (this.enqueue(new_value)) {
            return true;
        }
        int spins = 0;
        while (!this.enqueue(new_value)) {
            if ((long)(++spins) <= spins_between_yields) continue;
            Thread.yield();
            spins = 0;
        }
        return true;
    }

    public boolean enqueue(T new_value, long timeoutMicros, long maxSpins) {
        if (this.enqueue(new_value)) {
            return true;
        }
        int spins = 0;
        long t0 = System.nanoTime();
        long deadline = t0 + timeoutMicros * 1000L;
        while (!this.enqueue(new_value)) {
            if ((long)(++spins) <= maxSpins) continue;
            if (System.nanoTime() > deadline) {
                return false;
            }
            Thread.yield();
            spins = 0;
        }
        return true;
    }

    @Override
    public T dequeue() {
        return this.do_dequeue(false, null, null);
    }

    @Override
    public T peek() {
        return this.do_dequeue(true, null, null);
    }

    public T dequeueThisObject(T expected) {
        return this.do_dequeue(false, expected, null);
    }

    public T dequeueIf(Predicate.Unary<T> predicate) {
        return this.do_dequeue(false, null, predicate);
    }

    private T do_dequeue(boolean peek, T expected, Predicate.Unary<T> predicate) {
        Object val;
        int actual_head;
        int head0;
        while (true) {
            head0 = this.head.get();
            int tail0 = this.tail.get();
            actual_head = head0 + 1;
            val = this.get_node(actual_head);
            while (this.is_null(val) && head0 == this.head.get()) {
                if (this.same_slot(actual_head, tail0)) {
                    return null;
                }
                val = this.get_node(++actual_head);
            }
            if (head0 != this.head.get()) continue;
            if (this.same_slot(actual_head, tail0)) {
                this.tail.compareAndSet(tail0, tail0 + 1);
                continue;
            }
            Object tnull = this.get_null(actual_head);
            if (head0 != this.head.get()) continue;
            if (peek) {
                return (T)val;
            }
            if (expected != null && val != expected) {
                return null;
            }
            if (predicate != null && !predicate.call(val)) {
                return null;
            }
            if (this.cas_node(actual_head, val, tnull)) break;
        }
        if (actual_head % 2 == 0) {
            this.head.compareAndSet(head0, actual_head);
        }
        return (T)val;
    }

    @Override
    public void put(T new_value) {
        while (!this.enqueue(new_value)) {
        }
    }

    @Override
    public T take() {
        T deq;
        while ((deq = this.dequeue()) == null) {
        }
        return deq;
    }

    @Override
    public boolean produce(T t) {
        return this.enqueue(t);
    }

    @Override
    public T consume() {
        return this.dequeue();
    }

    private void debug_stop() {
    }

    private void debug_go() {
    }

    private void debug_check(String what) {
    }

    private void debug_dump(int h, int t, int h0, int t0, int at, Object new_value, int scan_count) {
        if (scan_count > 0) {
            System.out.println("LFAQ.enqueuing " + new_value + ": scanned " + scan_count + " slots looking for actual tail, h0=" + h0 + "=" + h0 % this.cap + "/" + (h0 >> this.shift) + "/" + this.get_null(h0) + ", t0=" + t0 + "=" + t0 % this.cap + "/" + (t0 >> this.shift) + "/" + this.get_null(t0) + ", h=" + h + "=" + h % this.cap + "/" + (h >> this.shift) + "/" + this.get_null(h) + ", t=" + t + "=" + t % this.cap + "/" + (t >> this.shift) + "/" + this.get_null(t) + ", at=" + at + "=" + at % this.cap + "/" + (at >> this.shift) + "/" + this.get_null(at));
        }
        for (int i = 0; i < this.cap; ++i) {
            if (this.same_slot(i, t)) {
                System.out.print(" *T*");
            }
            if (this.same_slot(i, h)) {
                System.out.print(" *H*");
            }
            if (this.same_slot(i, t0)) {
                System.out.print(" *T0*");
            }
            if (this.same_slot(i, h0)) {
                System.out.print(" *H0*");
            }
            if (this.same_slot(i, at)) {
                System.out.print(" *AT*");
            }
            System.out.print(" " + this.get_node(i));
        }
        System.out.println();
    }
}

