/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LowGarbageArraySet<T>
extends HashSet<T> {
    private T[] m_elements;
    private int m_nElements;
    private final MyIterator m_iterator = new MyIterator();

    public LowGarbageArraySet() {
        super(0);
        this.m_elements = new Object[16];
    }

    private LowGarbageArraySet(T[] elements, int nElements) {
        super(0);
        this.m_elements = elements;
        this.m_nElements = nElements;
    }

    @Override
    public Iterator<T> iterator() {
        this.m_iterator.reset();
        return this.m_iterator;
    }

    @Override
    public int size() {
        return this.m_nElements;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.m_nElements;
    }

    @Override
    public boolean contains(Object o) {
        for (int nIndex = 0; nIndex < this.m_nElements; ++nIndex) {
            if ((null != o || null != this.m_elements[nIndex]) && (null == o || !o.equals(this.m_elements[nIndex]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(T t) {
        for (int nIndex = 0; nIndex < this.m_nElements; ++nIndex) {
            if ((null != t || null != this.m_elements[nIndex]) && (null == t || !t.equals(this.m_elements[nIndex]))) continue;
            return false;
        }
        if (this.m_elements.length == this.m_nElements) {
            Object[] elements = new Object[this.m_elements.length * 2];
            System.arraycopy(this.m_elements, 0, elements, 0, this.m_nElements);
            this.m_elements = elements;
        }
        this.m_elements[this.m_nElements++] = t;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        for (int nIndex = 0; nIndex < this.m_nElements; ++nIndex) {
            if ((null != o || null != this.m_elements[nIndex]) && (null == o || !o.equals(this.m_elements[nIndex]))) continue;
            this.m_elements[nIndex] = this.m_elements[--this.m_nElements];
            this.m_elements[this.m_nElements] = null;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Arrays.fill(this.m_elements, 0, this.m_nElements, null);
        this.m_nElements = 0;
    }

    @Override
    public LowGarbageArraySet<T> clone() {
        return new LowGarbageArraySet<Object>((Object[])this.m_elements.clone(), this.m_nElements);
    }

    private class MyIterator
    implements Iterator<T> {
        private int m_nNextIndex;
        private boolean m_bCanRemove;

        private MyIterator() {
        }

        public void reset() {
            this.m_nNextIndex = 0;
            this.m_bCanRemove = false;
        }

        @Override
        public boolean hasNext() {
            return this.m_nNextIndex < LowGarbageArraySet.this.m_nElements;
        }

        @Override
        public T next() {
            if (this.m_nNextIndex == LowGarbageArraySet.this.m_nElements) {
                throw new NoSuchElementException();
            }
            this.m_bCanRemove = true;
            return LowGarbageArraySet.this.m_elements[this.m_nNextIndex++];
        }

        @Override
        public void remove() {
            if (!this.m_bCanRemove) {
                throw new IllegalStateException();
            }
            this.m_bCanRemove = false;
            LowGarbageArraySet.this.m_elements[--this.m_nNextIndex] = LowGarbageArraySet.this.m_elements[--LowGarbageArraySet.this.m_nElements];
            LowGarbageArraySet.this.m_elements[LowGarbageArraySet.this.m_nElements] = null;
        }
    }
}

