/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

public class MathUtil {
    public static final int MAX_POWER_OF_2 = 0x40000000;
    private static final int[] tenToThe = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] base10guessFromBase2Digits = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9};

    public static int ceilLog2(int x) {
        return 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static int floorLog2(int x) {
        return 31 - Integer.numberOfLeadingZeros(x);
    }

    public static int ceilLog2(long x) {
        return 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public static int floorLog2(long x) {
        return 63 - Long.numberOfLeadingZeros(x);
    }

    public static int gcd(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    public static int pow10(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("n = " + n);
        }
        return tenToThe[n];
    }

    public static int base10digits(int n) {
        int baseTwoDigits = 32 - Integer.numberOfLeadingZeros(n);
        int base10guess = base10guessFromBase2Digits[baseTwoDigits];
        if (n >= MathUtil.pow10(base10guess)) {
            return 1 + base10guess;
        }
        return base10guess;
    }

    public static int roundUpPowerOf2(int x) {
        return Math.max(Integer.highestOneBit(x - 1) << 1, 1);
    }

    public static int roundUpArraySize(int size) {
        return size <= 0x40000000 ? MathUtil.roundUpPowerOf2(size) : 0x7FFFFFF7;
    }
}

