/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.cache;

import gnu.trove.impl.PrimeFinder;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class OpenAddressedCanonicalizationCache {
    private static final Adapter<?, ?> DEFAULT_ADAPTER = new DefaultAdapter();
    private final float loadFactor;
    private ItemReference<?>[] storage;
    private int occupancyThreshold;
    private int occupiedSlots;
    private int emptySlots;
    private final ReferenceQueue<Object> cleanupQueue = new ReferenceQueue();

    public OpenAddressedCanonicalizationCache(int minimumInitialCapacity, float loadFactor) {
        this.loadFactor = Require.inRange(loadFactor, 0.0f, 1.0f, "loadFactor");
        this.initialize(OpenAddressedCanonicalizationCache.computeInitialCapacity(minimumInitialCapacity, loadFactor));
    }

    public OpenAddressedCanonicalizationCache(int minimumInitialCapacity) {
        this(minimumInitialCapacity, 0.5f);
    }

    public OpenAddressedCanonicalizationCache() {
        this(10, 0.5f);
    }

    private void initialize(int capacity) {
        this.storage = new ItemReference[capacity];
        this.occupancyThreshold = OpenAddressedCanonicalizationCache.computeOccupancyThreshold(capacity, this.loadFactor);
        this.occupiedSlots = 0;
        this.emptySlots = capacity;
    }

    int getOccupancyThreshold() {
        return this.occupancyThreshold;
    }

    int getOccupiedSlots() {
        return this.occupiedSlots;
    }

    public synchronized <INPUT_OUTPUT_TYPE> INPUT_OUTPUT_TYPE getCachedItem(@NotNull INPUT_OUTPUT_TYPE item) {
        return (INPUT_OUTPUT_TYPE)this.getCachedItem(item, DEFAULT_ADAPTER);
    }

    public synchronized <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE getCachedItem(@NotNull INPUT_TYPE item, @NotNull Adapter<INPUT_TYPE, OUTPUT_TYPE> adapter) {
        this.cleanup();
        return this.getOrInsertCachedItem(item, adapter);
    }

    private void cleanup() {
        ItemReference itemReference;
        while ((itemReference = (ItemReference)this.cleanupQueue.poll()) != null) {
            Assert.eqNull(itemReference.get(), "itemReference.get()");
            this.maybeReclaim(itemReference);
        }
    }

    private void maybeReclaim(@NotNull ItemReference<?> itemReference) {
        if (!itemReference.reclaimed()) {
            --this.occupiedSlots;
            itemReference.markReclaimed();
        }
    }

    private <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE getOrInsertCachedItem(@NotNull INPUT_TYPE item, @NotNull Adapter<INPUT_TYPE, OUTPUT_TYPE> adapter) {
        int length = this.storage.length;
        int hashCode = adapter.hashCode(item) & Integer.MAX_VALUE;
        int probeInterval = OpenAddressedCanonicalizationCache.computeProbeInterval(hashCode, length);
        int slot = hashCode % length;
        int firstDeletedSlot = -1;
        while (true) {
            ItemReference<?> candidateReference;
            if ((candidateReference = this.storage[slot]) == null) {
                OUTPUT_TYPE cacheableItem = adapter.makeCacheableItem(item);
                if (firstDeletedSlot == -1) {
                    --this.emptySlots;
                    this.storage[slot] = new ItemReference<Object>(cacheableItem, this.cleanupQueue);
                } else {
                    this.storage[firstDeletedSlot] = new ItemReference<Object>(cacheableItem, this.cleanupQueue);
                }
                ++this.occupiedSlots;
                this.maybeRehash();
                return cacheableItem;
            }
            Object candidate = candidateReference.get();
            if (candidate == null) {
                if (firstDeletedSlot == -1) {
                    firstDeletedSlot = slot;
                }
                this.maybeReclaim(candidateReference);
            } else if (adapter.equals(item, candidate)) {
                return (OUTPUT_TYPE)candidate;
            }
            if ((slot -= probeInterval) >= 0) continue;
            slot += length;
        }
    }

    private void maybeRehash() {
        int newCapacity;
        if (this.occupiedSlots > this.occupancyThreshold) {
            newCapacity = OpenAddressedCanonicalizationCache.computeNextCapacity(this.storage.length);
        } else if (this.emptySlots == 0) {
            newCapacity = this.storage.length;
        } else {
            return;
        }
        this.rehash(newCapacity);
        this.cleanup();
    }

    private void rehash(int newCapacity) {
        ItemReference<?>[] oldStorage = this.storage;
        this.initialize(newCapacity);
        for (ItemReference<?> itemReference : oldStorage) {
            if (itemReference == null || itemReference.reclaimed()) continue;
            Object item = itemReference.get();
            if (item != null) {
                this.insertReferenceForRehash(itemReference, item);
                continue;
            }
            if (itemReference.reclaimed()) continue;
            itemReference.markReclaimed();
        }
    }

    private void insertReferenceForRehash(ItemReference<?> itemReference, Object item) {
        int length = this.storage.length;
        int hashCode = item.hashCode() & Integer.MAX_VALUE;
        int probeInterval = OpenAddressedCanonicalizationCache.computeProbeInterval(hashCode, length);
        int slot = hashCode % length;
        int firstDeletedSlot = -1;
        while (true) {
            ItemReference<?> candidateReference;
            if ((candidateReference = this.storage[slot]) == null) {
                if (firstDeletedSlot == -1) {
                    --this.emptySlots;
                    this.storage[slot] = itemReference;
                } else {
                    this.storage[firstDeletedSlot] = itemReference;
                }
                ++this.occupiedSlots;
                return;
            }
            if (candidateReference.get() == null) {
                if (firstDeletedSlot == -1) {
                    firstDeletedSlot = slot;
                }
                this.maybeReclaim(candidateReference);
            }
            if ((slot -= probeInterval) >= 0) continue;
            slot += length;
        }
    }

    private static int computeInitialCapacity(int minimumInitialCapacity, float loadFactor) {
        return PrimeFinder.nextPrime((int)((int)Math.ceil((float)minimumInitialCapacity / loadFactor) + 1));
    }

    private static int computeNextCapacity(int capacity) {
        return PrimeFinder.nextPrime((int)(capacity << 1));
    }

    private static int computeOccupancyThreshold(int capacity, float loadFactor) {
        return Math.min(capacity - 1, (int)Math.floor((float)capacity * loadFactor));
    }

    private static int computeProbeInterval(int hashCode, int length) {
        return 1 + hashCode % (length - 2);
    }

    private static class ItemReference<T>
    extends WeakReference<T> {
        private boolean reclaimed = false;

        ItemReference(@NotNull T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
        }

        boolean reclaimed() {
            return this.reclaimed;
        }

        void markReclaimed() {
            this.reclaimed = true;
        }
    }

    private static class DefaultAdapter
    implements Adapter<Object, Object> {
        private DefaultAdapter() {
        }

        @Override
        public boolean equals(@NotNull Object inputItem, @NotNull Object cachedItem) {
            return inputItem.equals(cachedItem);
        }

        @Override
        public int hashCode(@NotNull Object inputItem) {
            return inputItem.hashCode();
        }

        @Override
        public Object makeCacheableItem(@NotNull Object inputItem) {
            return inputItem;
        }
    }

    public static interface Adapter<INPUT_TYPE, OUTPUT_TYPE> {
        public boolean equals(@NotNull INPUT_TYPE var1, @NotNull Object var2);

        public int hashCode(@NotNull INPUT_TYPE var1);

        public OUTPUT_TYPE makeCacheableItem(@NotNull INPUT_TYPE var1);
    }
}

