/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.formatters;

import io.deephaven.base.log.LogOutputAppendable;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class FormatBitSet {
    public static LogOutputAppendable formatBitSet(BitSet bitSet) {
        return logOutput -> {
            logOutput.append("{");
            boolean first = true;
            int runStart = 0;
            while (runStart < bitSet.size()) {
                if (bitSet.get(runStart)) {
                    int runEnd;
                    if (first) {
                        first = false;
                    } else {
                        logOutput.append(", ");
                    }
                    logOutput.append(runStart);
                    for (runEnd = runStart + 1; runEnd < bitSet.size() && bitSet.get(runEnd); ++runEnd) {
                    }
                    if (runEnd > runStart + 1) {
                        logOutput.append("-").append(runEnd - 1);
                    }
                    runStart = runEnd;
                    continue;
                }
                ++runStart;
            }
            logOutput.append("}");
            return logOutput;
        };
    }

    public static String formatBitSetAsString(BitSet bitSet) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean first = true;
        int runStart = 0;
        while (runStart < bitSet.size()) {
            if (bitSet.get(runStart)) {
                int runEnd;
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(runStart);
                for (runEnd = runStart + 1; runEnd < bitSet.size() && bitSet.get(runEnd); ++runEnd) {
                }
                if (runEnd > runStart + 1) {
                    builder.append("-").append(runEnd - 1);
                }
                runStart = runEnd;
                continue;
            }
            ++runStart;
        }
        builder.append("}");
        return builder.toString();
    }

    @NotNull
    public static BitSet arrayToBitSet(Object[] array) {
        if (array == null) {
            return new BitSet();
        }
        BitSet populated = new BitSet(array.length);
        for (int ii = 0; ii < array.length; ++ii) {
            if (array[ii] == null) continue;
            populated.set(ii);
        }
        return populated;
    }

    @NotNull
    public static LogOutputAppendable arrayToLog(Object[] array) {
        if (array == null) {
            return FormatBitSet.formatBitSet(new BitSet());
        }
        BitSet populated = new BitSet(array.length);
        for (int ii = 0; ii < array.length; ++ii) {
            if (array[ii] == null) continue;
            populated.set(ii);
        }
        return FormatBitSet.formatBitSet(populated);
    }
}

