/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.log;

import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.base.text.TimestampBufferMicros;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.TimeZone;

public interface LogOutput {
    public static final TimestampBuffer millisFormatter = new TimestampBuffer(TimeZone.getDefault());
    public static final ObjFormatter<Object> BASIC_FORMATTER = (logOutput, o) -> {
        if (o == null) {
            logOutput.append("null");
        } else {
            logOutput.append(o.getClass().getName()).append('@').append(o.hashCode());
        }
    };
    public static final ObjFormatter<SocketAddress> SOCKADDR_FORMATTER = (logOutput, sockaddr) -> {
        if (sockaddr instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)sockaddr;
            if (addr.getAddress() == null) {
                logOutput.append("null");
            } else {
                byte[] b = addr.getAddress().getAddress();
                logOutput.append(b[0] & 0xFF);
                for (int i = 1; i < b.length; ++i) {
                    logOutput.append('.').append(b[i] & 0xFF);
                }
                logOutput.append(':').append(addr.getPort());
            }
        } else {
            BASIC_FORMATTER.format(logOutput, sockaddr);
        }
    };
    public static final ObjFormatter<int[]> INT_ARRAY_FORMATTER = (logOutput, array) -> {
        if (array == null) {
            logOutput.append("null");
        } else if (((int[])array).length == 0) {
            logOutput.append("{}");
        } else {
            int delim = 123;
            for (int i = 0; i < ((int[])array).length; ++i) {
                logOutput.append((char)delim).append(array[i]);
                delim = 44;
            }
            logOutput.append('}');
        }
    };
    public static final ObjFormatter<String[]> STRING_ARRAY_FORMATTER = (logOutput, array) -> {
        if (array == null) {
            logOutput.append("null");
        } else if (((String[])array).length == 0) {
            logOutput.append("{}");
        } else {
            int delim = 123;
            for (int i = 0; i < ((String[])array).length; ++i) {
                logOutput.append((char)delim).append(array[i]);
                delim = 44;
            }
            logOutput.append('}');
        }
    };
    public static final ObjFormatter<Collection<String>> STRING_COLLECTION_FORMATTER = (logOutput, collection) -> {
        if (collection == null) {
            logOutput.append("null");
        } else if (collection.isEmpty()) {
            logOutput.append("{}");
        } else {
            int delim = 123;
            for (String elem : collection) {
                logOutput.append((char)delim).append(elem);
                delim = 44;
            }
            logOutput.append('}');
        }
    };
    public static final ObjFormatter<LogOutputAppendable[]> APPENDABLE_ARRAY_FORMATTER = (logOutput, collection) -> {
        if (collection == null) {
            logOutput.append("null");
        } else if (((LogOutputAppendable[])collection).length == 0) {
            logOutput.append("{}");
        } else {
            int delim = 123;
            for (LogOutputAppendable elem : collection) {
                logOutput.append((char)delim).append(elem);
                delim = 44;
            }
            logOutput.append('}');
        }
    };
    public static final ObjFormatter<Collection<? extends LogOutputAppendable>> APPENDABLE_COLLECTION_FORMATTER = (logOutput, collection) -> {
        if (collection == null) {
            logOutput.append("null");
        } else if (collection.isEmpty()) {
            logOutput.append("{}");
        } else {
            int delim = 123;
            for (LogOutputAppendable elem : collection) {
                logOutput.append((char)delim).append(elem);
                delim = 44;
            }
            logOutput.append('}');
        }
    };
    public static final ObjFormatter<boolean[]> BOOLEAN_ARRAY_FORMATTER = (logOutput, array) -> {
        if (array == null) {
            logOutput.append("null");
        } else if (((boolean[])array).length == 0) {
            logOutput.append("{}");
        } else {
            int delim = 123;
            for (int i = 0; i < ((boolean[])array).length; ++i) {
                logOutput.append((char)delim).append(array[i]);
                delim = 44;
            }
            logOutput.append('}');
        }
    };
    public static final ObjFormatter<byte[]> NULL_TERMINATED_STRING_FORMATTER = (logOutput, array) -> {
        if (array == null) {
            logOutput.append("null");
        } else {
            for (int i = 0; i < ((byte[])array).length && array[i] != 0; ++i) {
                logOutput.append((char)array[i]);
            }
        }
    };
    public static final ObjFormatter<LocalDateTime> LOCAL_DATE_TIME_FORMATTER = (logOutput, localDateTime) -> {
        if (localDateTime == null) {
            logOutput.append("null");
        } else {
            logOutput.append(millisFormatter.getTimestamp(localDateTime.atZone(TimeZone.getDefault().toZoneId()).toInstant().toEpochMilli()));
        }
    };
    public static final LongFormatter MILLIS_FROM_EPOCH_FORMATTER = (logOutput, millis) -> logOutput.append(millisFormatter.getTimestamp(millis));
    public static final Null NULL = new Null();

    public LogOutput start();

    public LogOutput append(boolean var1);

    public LogOutput append(char var1);

    public LogOutput append(short var1);

    public LogOutput append(int var1);

    public LogOutput append(long var1);

    public LogOutput appendDouble(double var1);

    public LogOutput append(LogOutputAppendable var1);

    public LogOutput append(LongFormatter var1, long var2);

    public <T> LogOutput append(ObjFormatter<T> var1, T var2);

    public <T> LogOutput append(ObjIntIntFormatter<T> var1, T var2, int var3, int var4);

    public <T, U> LogOutput append(ObjObjFormatter<T, U> var1, T var2, U var3);

    public LogOutput append(CharSequence var1);

    public LogOutput append(CharSequence var1, int var2, int var3);

    public LogOutput append(ByteBuffer var1);

    public LogOutput appendTimestamp(long var1, TimestampBuffer var3);

    public LogOutput appendTimestampMicros(long var1, TimestampBufferMicros var3);

    public LogOutput append(Throwable var1);

    public LogOutput append(byte[] var1);

    public LogOutput append(byte[] var1, int var2, int var3);

    public LogOutput append(byte[] var1, byte var2);

    default public LogOutput append(Boolean b) {
        return b == null ? this.append("null") : this.append((boolean)b);
    }

    default public LogOutput append(Character c) {
        return c == null ? this.append("null") : this.append(c.charValue());
    }

    default public LogOutput append(Short s) {
        return s == null ? this.append("null") : this.append((short)s);
    }

    default public LogOutput append(Integer i) {
        return i == null ? this.append("null") : this.append((int)i);
    }

    default public LogOutput append(Long l) {
        return l == null ? this.append("null") : this.append((long)l);
    }

    default public LogOutput appendDouble(Double f) {
        return f == null ? this.append("null") : this.appendDouble((double)f);
    }

    public LogOutput markEndOfHeader();

    public int getEndOfHeaderOffset();

    public LogOutput nf();

    public LogOutput nl();

    public LogOutput close();

    public int relativeSize();

    public int size();

    public int getBufferCount();

    public ByteBuffer getBuffer(int var1);

    public LogOutput clear();

    public static class Null
    implements LogOutput {
        @Override
        public LogOutput start() {
            return this;
        }

        @Override
        public LogOutput append(boolean b) {
            return this;
        }

        @Override
        public LogOutput append(char c) {
            return this;
        }

        @Override
        public LogOutput append(short s) {
            return this;
        }

        @Override
        public LogOutput append(int i) {
            return this;
        }

        @Override
        public LogOutput append(long l) {
            return this;
        }

        @Override
        public LogOutput appendDouble(double f) {
            return this;
        }

        private LogOutput appendDouble(double f, int digits, boolean forceScientific, boolean trailingZeroes) {
            return this;
        }

        @Override
        public LogOutput append(LogOutputAppendable appendable) {
            return this;
        }

        @Override
        public <T> LogOutput append(ObjFormatter<T> objFormatter, T t) {
            return this;
        }

        @Override
        public <T> LogOutput append(ObjIntIntFormatter<T> objFormatter, T t, int nOffset, int nLength) {
            return this;
        }

        @Override
        public <T, U> LogOutput append(ObjObjFormatter<T, U> objObjFormatter, T t, U u) {
            return this;
        }

        @Override
        public LogOutput append(LongFormatter formatter, long n) {
            return this;
        }

        @Override
        public LogOutput append(CharSequence seq) {
            return this;
        }

        @Override
        public LogOutput append(CharSequence seq, int start, int length) {
            return this;
        }

        @Override
        public LogOutput append(ByteBuffer bb) {
            return this;
        }

        @Override
        public LogOutput appendTimestamp(long utcMillis, TimestampBuffer tb) {
            return this;
        }

        @Override
        public LogOutput appendTimestampMicros(long utcMicros, TimestampBufferMicros tb) {
            return this;
        }

        @Override
        public LogOutput append(Throwable t) {
            return this;
        }

        @Override
        public LogOutput append(byte[] ba) {
            return this;
        }

        @Override
        public LogOutput append(byte[] ba, int pos, int length) {
            return this;
        }

        @Override
        public LogOutput append(byte[] ba, byte terminator) {
            return this;
        }

        @Override
        public LogOutput markEndOfHeader() {
            return this;
        }

        @Override
        public int getEndOfHeaderOffset() {
            return 0;
        }

        @Override
        public LogOutput nf() {
            return this;
        }

        @Override
        public LogOutput nl() {
            return this;
        }

        @Override
        public LogOutput close() {
            return this;
        }

        @Override
        public int relativeSize() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int getBufferCount() {
            return 0;
        }

        @Override
        public ByteBuffer getBuffer(int i) {
            return null;
        }

        @Override
        public LogOutput clear() {
            return this;
        }
    }

    public static interface ObjObjFormatter<T, U> {
        public void format(LogOutput var1, T var2, U var3);
    }

    public static interface ObjIntIntFormatter<T> {
        public void format(LogOutput var1, T var2, int var3, int var4);
    }

    public static interface ObjFormatter<T> {
        public void format(LogOutput var1, T var2);
    }

    public static interface LongFormatter {
        public void format(LogOutput var1, long var2);
    }
}

