/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.map;

import io.deephaven.base.Copyable;
import io.deephaven.base.array.FastArray;
import io.deephaven.base.map.KeyValuePair;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.function.Supplier;

public class FastArrayMap<K extends Comparable<K> & Externalizable, V extends Externalizable & Copyable<V>>
implements Copyable<FastArrayMap<K, V>> {
    private FastArray<KeyValuePair<K, V>> array;

    public FastArrayMap() {
    }

    public FastArrayMap(Supplier<? extends KeyValuePair<K, V>> newInstance) {
        this.array = new FastArray<KeyValuePair<K, V>>(newInstance);
    }

    public FastArray<KeyValuePair<K, V>> getArray() {
        return this.array;
    }

    public int size() {
        return this.array.getLength();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int findThisKeyIndex(K key) {
        for (int i = 0; i < this.array.getLength(); ++i) {
            if (!((Comparable)this.array.getUnsafeArray()[i].getKey()).equals(key)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(K key) {
        return this.findThisKeyIndex(key) >= 0;
    }

    public V get(K key) {
        int index = this.findThisKeyIndex(key);
        if (index < 0) {
            return null;
        }
        return this.array.getUnsafeArray()[index].getValue();
    }

    public V put(K key, V value) {
        int index = this.findThisKeyIndex(key);
        if (index >= 0) {
            V oldValue = this.array.getUnsafeArray()[index].getValue();
            this.array.getUnsafeArray()[index].setValue(value);
            return oldValue;
        }
        KeyValuePair<K, V> newItem = new KeyValuePair<K, V>(key, value);
        this.insertNewlyAllocatedItemIntoArray(newItem);
        return null;
    }

    private void insertNewlyAllocatedItemIntoArray(KeyValuePair<K, V> item) {
        this.array.add(item);
        this.sortArray();
    }

    private void sortArray() {
        Arrays.sort(this.array.getUnsafeArray(), 0, this.array.getLength());
    }

    public V remove(K key) {
        int index = this.findThisKeyIndex(key);
        if (index >= 0) {
            V oldValue = this.array.getUnsafeArray()[index].getValue();
            this.array.removeThisIndex(index);
            return oldValue;
        }
        return null;
    }

    public void clear() {
        this.array.quickReset();
    }

    public FastArrayMap<K, V> cloneDeep() {
        FastArrayMap<K, V> copy = new FastArrayMap<K, V>();
        copy.array = FastArray.cloneDeep(this.getArray());
        return copy;
    }

    @Override
    public void copyValues(FastArrayMap<K, V> other) {
        FastArray.copyValuesDeep(this.array, other.array);
    }

    @Override
    public FastArrayMap<K, V> safeClone() {
        FastArrayMap<K, V> result = new FastArrayMap<K, V>(this.array.getNewInstance());
        result.array = FastArray.cloneDeep(this.array);
        return result;
    }

    public static <K extends Externalizable & Comparable<K>, V extends Externalizable & Copyable<V>> void writeExternal(FastArrayMap<K, V> THIS, ObjectOutput out, FastArray.WriteExternalFunction<KeyValuePair<K, V>> writeExternalFunction) throws IOException {
        if (THIS == null) {
            throw new IllegalArgumentException("FastArray.writeExternal(): THIS was null and is not supported");
        }
        out.writeInt(THIS.array.getLength());
        for (int i = 0; i < THIS.array.getLength(); ++i) {
            writeExternalFunction.writeExternal(out, THIS.array.getUnsafeArray()[i]);
        }
    }

    public static <K extends Externalizable & Comparable<K>, V extends Externalizable & Copyable<V>> void readExternal(FastArrayMap<K, V> THIS, ObjectInput in, FastArray.ReadExternalFunction<KeyValuePair<K, V>> readExternalFunction) throws IOException, ClassNotFoundException {
        if (THIS == null) {
            throw new IllegalArgumentException("FastArray.readExternal(): THIS was null and is not supported");
        }
        THIS.array.quickReset();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            KeyValuePair<K, V> nextKeyValuePair = THIS.array.next();
            readExternalFunction.readExternal(in, nextKeyValuePair);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastArrayMap)) {
            return false;
        }
        FastArrayMap that = (FastArrayMap)o;
        return !(this.array != null ? !this.array.equals(that.array) : that.array != null);
    }

    public int hashCode() {
        return this.array != null ? this.array.hashCode() : 0;
    }

    public String toString() {
        return this.toStringXml("");
    }

    public String toStringXml(String pre) {
        StringBuilder msg = new StringBuilder();
        String extra = "   ";
        msg.append(pre).append("<FastArrayMap>\n");
        msg.append(pre).append(extra).append("<array>\n");
        msg.append(this.array.toStringXml(pre + extra));
        msg.append(pre).append(extra).append("</array>\n");
        msg.append(pre).append("</FastArrayMap>\n");
        return msg.toString();
    }
}

