/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.pool;

import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.MathUtil;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.verify.Require;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ThreadSafeFixedSizePool<T>
implements Pool<T> {
    public static Pool.Factory FACTORY = new Pool.Factory(){

        @Override
        public <T> Pool<T> create(int nSize, Supplier<T> itemFactory, Consumer<T> clearingProcedure) {
            return new ThreadSafeFixedSizePool<T>(Require.geq(nSize, "nSize", 7, "MIN_SIZE"), Require.neqNull(itemFactory, "itemFactory"), clearingProcedure);
        }
    };
    public static final int MIN_SIZE = 7;
    private static final int SPIN_COUNT = 10000;
    protected final LockFreeArrayQueue<T> pool;
    private final Consumer<T> clearingProcedure;

    public ThreadSafeFixedSizePool(int size, Supplier<T> factory, Consumer<T> clearingProcedure) {
        this(size, Require.neqNull(factory, "factory"), clearingProcedure, false);
    }

    protected ThreadSafeFixedSizePool(int size, Consumer<T> clearingProcedure) {
        this(size, null, clearingProcedure, false);
    }

    private ThreadSafeFixedSizePool(int size, @Nullable Supplier<T> factory, Consumer<T> clearingProcedure, boolean dummy) {
        Require.geq(size, "size", 7, "MIN_SIZE");
        this.clearingProcedure = clearingProcedure;
        this.pool = new LockFreeArrayQueue(MathUtil.ceilLog2(size + 2));
        if (factory == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            T element = factory.get();
            while (!this.pool.enqueue(element)) {
            }
        }
    }

    @Override
    public void give(T item) {
        if (null == item) {
            return;
        }
        if (null != this.clearingProcedure) {
            this.clearingProcedure.accept(item);
        }
        if (this.pool.enqueue(item)) {
            return;
        }
        int spins = 0;
        while (!this.pool.enqueue(item)) {
            if (++spins <= 10000) continue;
            Thread.yield();
            spins = 0;
        }
    }

    @Override
    public T take() {
        T item = this.pool.dequeue();
        if (item != null) {
            return item;
        }
        int spins = 0;
        while ((item = this.pool.dequeue()) == null) {
            if (++spins <= 10000) continue;
            Thread.yield();
            spins = 0;
        }
        return item;
    }
}

