/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.pool;

import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.MathUtil;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.stats.Counter;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.verify.Require;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ThreadSafeLenientFixedSizePool<T>
implements Pool.MultiPool<T> {
    public static Pool.Factory FACTORY = new Pool.Factory(){

        @Override
        public <T> Pool<T> create(int nSize, Supplier<T> itemFactory, Consumer<T> clearingProcedure) {
            return new ThreadSafeLenientFixedSizePool<T>(Require.geq(nSize, "nSize", 7, "MIN_SIZE"), Require.neqNull(itemFactory, "itemFactory"), clearingProcedure);
        }
    };
    public static final int MIN_SIZE = 7;
    private final LockFreeArrayQueue<T> pool;
    private final Function<ThreadSafeLenientFixedSizePool<T>, T> factory;
    private final Consumer<? super T> clearingProcedure;
    private final Counter extraFactoryCalls;

    private static <T> Function<ThreadSafeLenientFixedSizePool<T>, T> makeNullaryFactoryAdapter(Supplier<T> factory) {
        return arg -> factory.get();
    }

    public ThreadSafeLenientFixedSizePool(int size, Supplier<T> factory, Consumer<? super T> clearingProcedure) {
        this(Require.geq(size, "size", 7, "MIN_SIZE"), ThreadSafeLenientFixedSizePool.makeNullaryFactoryAdapter(Require.neqNull(factory, "factory")), clearingProcedure);
    }

    public ThreadSafeLenientFixedSizePool(String name, int size, Supplier<T> factory, Consumer<? super T> clearingProcedure) {
        this(name, Require.geq(size, "size", 7, "MIN_SIZE"), ThreadSafeLenientFixedSizePool.makeNullaryFactoryAdapter(Require.neqNull(factory, "factory")), clearingProcedure);
    }

    public ThreadSafeLenientFixedSizePool(int size, Function<ThreadSafeLenientFixedSizePool<T>, T> factory, Consumer<? super T> clearingProcedure) {
        this(null, size, factory, clearingProcedure);
    }

    public ThreadSafeLenientFixedSizePool(String name, int size, Function<ThreadSafeLenientFixedSizePool<T>, T> factory, Consumer<? super T> clearingProcedure) {
        Require.geq(size, "size", 7, "MIN_SIZE");
        Require.neqNull(factory, "factory");
        this.factory = factory;
        this.clearingProcedure = clearingProcedure;
        this.pool = new LockFreeArrayQueue(MathUtil.ceilLog2(size + 2));
        for (int i = 0; i < size; ++i) {
            this.pool.enqueue(factory.apply(this));
        }
        this.extraFactoryCalls = name == null ? null : Stats.makeItem(name, "extraFactoryCalls", Counter.FACTORY).getValue();
    }

    @Override
    public T take() {
        T item = this.pool.dequeue();
        if (item == null) {
            if (this.extraFactoryCalls != null) {
                this.extraFactoryCalls.sample(1L);
            }
            return this.factory.apply(this);
        }
        return item;
    }

    @Override
    public void give(T item) {
        this.giveInternal(item);
    }

    protected boolean giveInternal(T item) {
        if (null == item) {
            return false;
        }
        if (null != this.clearingProcedure) {
            this.clearingProcedure.accept(item);
        }
        return this.pool.enqueue(item);
    }

    public T takeMaybeNull() {
        return this.pool.dequeue();
    }
}

