/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.reference;

import io.deephaven.base.reference.SimpleReference;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.NotNull;

public class SwappableDelegatingReference<T>
implements SimpleReference<T> {
    private static final AtomicReferenceFieldUpdater<SwappableDelegatingReference, SimpleReference> DELEGATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SwappableDelegatingReference.class, SimpleReference.class, "delegate");
    private volatile SimpleReference<T> delegate;

    public SwappableDelegatingReference(@NotNull SimpleReference<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public void swapDelegate(@NotNull SimpleReference<T> oldDelegate, @NotNull SimpleReference<T> newDelegate) {
        if (!DELEGATE_UPDATER.compareAndSet(this, oldDelegate, newDelegate)) {
            throw new IllegalArgumentException("Previous delegate mismatch: found " + this.delegate + ", expected " + oldDelegate);
        }
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

