/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.MathUtil;
import io.deephaven.base.verify.Assert;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ObjectRingBuffer<T>
implements Serializable {
    static final long FIXUP_THRESHOLD = 0x4000000000000000L;
    final boolean growable;
    T[] storage;
    int mask;
    long head;
    long tail;

    public ObjectRingBuffer(int capacity) {
        this(capacity, true);
    }

    public ObjectRingBuffer(int capacity, boolean growable) {
        Assert.leq(capacity, "ObjectRingBuffer capacity", 0x40000000);
        this.growable = growable;
        this.storage = new Object[MathUtil.roundUpPowerOf2(capacity)];
        this.mask = this.storage.length - 1;
        this.head = 0L;
        this.tail = 0L;
    }

    protected void grow(int increase) {
        int size = this.size();
        long newCapacity = (long)this.storage.length + (long)increase;
        Assert.leq(newCapacity, "ObjectRingBuffer capacity", 0x40000000L);
        Object[] newStorage = new Object[MathUtil.roundUpPowerOf2((int)newCapacity)];
        this.copyRingBufferToArray(newStorage);
        this.storage = newStorage;
        this.mask = this.storage.length - 1;
        this.tail = size;
        this.head = 0L;
    }

    protected void copyRingBufferToArray(T[] dest) {
        int size = this.size();
        int storageHead = (int)(this.head & (long)this.mask);
        int firstCopyLen = Math.min(Math.min(this.storage.length - storageHead, size), dest.length);
        int secondCopyLen = Math.min(size - firstCopyLen, dest.length - firstCopyLen);
        System.arraycopy(this.storage, storageHead, dest, 0, firstCopyLen);
        System.arraycopy(this.storage, 0, dest, firstCopyLen, secondCopyLen);
    }

    public boolean isFull() {
        return this.size() == this.storage.length;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public int size() {
        return Math.toIntExact(this.tail - this.head);
    }

    public int capacity() {
        return this.storage.length;
    }

    public int remaining() {
        return this.storage.length - this.size();
    }

    public void clear() {
        this.head = 0L;
        this.tail = 0L;
    }

    public boolean add(T e) {
        if (this.isFull()) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(1);
        }
        this.addUnsafe(e);
        return true;
    }

    public void ensureRemaining(int count) {
        if (this.remaining() < count) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(count);
        }
    }

    public void addUnsafe(T e) {
        if (this.tail >= 0x4000000000000000L) {
            long thisLength = this.tail - this.head;
            this.head &= (long)this.mask;
            this.tail = this.head + thisLength;
        }
        this.storage[(int)(this.tail++ & (long)this.mask)] = e;
    }

    public T addOverwrite(T e, T notFullResult) {
        T val = notFullResult;
        if (this.isFull()) {
            val = this.remove();
        }
        this.addUnsafe(e);
        return val;
    }

    public boolean offer(T e) {
        if (this.isFull()) {
            return false;
        }
        this.addUnsafe(e);
        return true;
    }

    public T[] remove(int count) {
        int size = this.size();
        if (size < count) {
            throw new NoSuchElementException();
        }
        Object[] result = new Object[count];
        int storageHead = (int)(this.head & (long)this.mask);
        int firstCopyLen = Math.min(Math.min(this.storage.length - storageHead, size), result.length);
        int secondCopyLen = Math.min(size - firstCopyLen, result.length - firstCopyLen);
        System.arraycopy(this.storage, storageHead, result, 0, firstCopyLen);
        Arrays.fill(this.storage, storageHead, storageHead + firstCopyLen, null);
        System.arraycopy(this.storage, 0, result, firstCopyLen, secondCopyLen);
        Arrays.fill(this.storage, 0, secondCopyLen, null);
        this.head += (long)count;
        return result;
    }

    public T remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeUnsafe();
    }

    public T removeUnsafe() {
        int idx = (int)(this.head++ & (long)this.mask);
        T val = this.storage[idx];
        this.storage[idx] = null;
        return val;
    }

    public T poll(T onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.removeUnsafe();
    }

    public T element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public T peek(T onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public T front() {
        return this.front(0);
    }

    public T front(int offset) {
        if (offset < 0 || offset >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head + (long)offset & (long)this.mask)];
    }

    public T back() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public T peekBack(T onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public T[] getAll() {
        Object[] result = new Object[this.size()];
        this.copyRingBufferToArray(result);
        return result;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator {
        int cursor = -1;

        public boolean hasNext() {
            return this.cursor + 1 < ObjectRingBuffer.this.size();
        }

        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return ObjectRingBuffer.this.storage[(int)(ObjectRingBuffer.this.head + (long)this.cursor & (long)ObjectRingBuffer.this.mask)];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

