/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.MathUtil;
import io.deephaven.base.verify.Assert;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class ShortRingBuffer
implements Serializable {
    static final long FIXUP_THRESHOLD = 0x4000000000000000L;
    final boolean growable;
    short[] storage;
    int mask;
    long head;
    long tail;

    public ShortRingBuffer(int capacity) {
        this(capacity, true);
    }

    public ShortRingBuffer(int capacity, boolean growable) {
        Assert.leq(capacity, "ShortRingBuffer capacity", 0x40000000);
        this.growable = growable;
        this.storage = new short[MathUtil.roundUpPowerOf2(capacity)];
        this.mask = this.storage.length - 1;
        this.head = 0L;
        this.tail = 0L;
    }

    protected void grow(int increase) {
        int size = this.size();
        long newCapacity = (long)this.storage.length + (long)increase;
        Assert.leq(newCapacity, "ShortRingBuffer capacity", 0x40000000L);
        short[] newStorage = new short[MathUtil.roundUpPowerOf2((int)newCapacity)];
        this.copyRingBufferToArray(newStorage);
        this.storage = newStorage;
        this.mask = this.storage.length - 1;
        this.tail = size;
        this.head = 0L;
    }

    protected void copyRingBufferToArray(short[] dest) {
        int size = this.size();
        int storageHead = (int)(this.head & (long)this.mask);
        int firstCopyLen = Math.min(Math.min(this.storage.length - storageHead, size), dest.length);
        int secondCopyLen = Math.min(size - firstCopyLen, dest.length - firstCopyLen);
        System.arraycopy(this.storage, storageHead, dest, 0, firstCopyLen);
        System.arraycopy(this.storage, 0, dest, firstCopyLen, secondCopyLen);
    }

    public boolean isFull() {
        return this.size() == this.storage.length;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public int size() {
        return Math.toIntExact(this.tail - this.head);
    }

    public int capacity() {
        return this.storage.length;
    }

    public int remaining() {
        return this.storage.length - this.size();
    }

    public void clear() {
        this.head = 0L;
        this.tail = 0L;
    }

    public boolean add(short e) {
        if (this.isFull()) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(1);
        }
        this.addUnsafe(e);
        return true;
    }

    public void ensureRemaining(int count) {
        if (this.remaining() < count) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(count);
        }
    }

    public void addUnsafe(short e) {
        if (this.tail >= 0x4000000000000000L) {
            long thisLength = this.tail - this.head;
            this.head &= (long)this.mask;
            this.tail = this.head + thisLength;
        }
        this.storage[(int)(this.tail++ & (long)this.mask)] = e;
    }

    public short addOverwrite(short e, short notFullResult) {
        short val = notFullResult;
        if (this.isFull()) {
            val = this.remove();
        }
        this.addUnsafe(e);
        return val;
    }

    public boolean offer(short e) {
        if (this.isFull()) {
            return false;
        }
        this.addUnsafe(e);
        return true;
    }

    public short[] remove(int count) {
        int size = this.size();
        if (size < count) {
            throw new NoSuchElementException();
        }
        short[] result = new short[count];
        this.copyRingBufferToArray(result);
        this.head += (long)count;
        return result;
    }

    public short remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeUnsafe();
    }

    public short removeUnsafe() {
        int idx = (int)(this.head++ & (long)this.mask);
        short val = this.storage[idx];
        return val;
    }

    public short poll(short onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.removeUnsafe();
    }

    public short element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public short peek(short onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public short front() {
        return this.front(0);
    }

    public short front(int offset) {
        if (offset < 0 || offset >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head + (long)offset & (long)this.mask)];
    }

    public short back() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public short peekBack(short onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public short[] getAll() {
        short[] result = new short[this.size()];
        this.copyRingBufferToArray(result);
        return result;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator {
        int cursor = -1;

        public boolean hasNext() {
            return this.cursor + 1 < ShortRingBuffer.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return ShortRingBuffer.this.storage[(int)(ShortRingBuffer.this.head + (long)this.cursor & (long)ShortRingBuffer.this.mask)];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

