/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.stats;

import io.deephaven.base.stats.Item;
import io.deephaven.base.stats.ItemUpdateListener;
import io.deephaven.base.stats.Value;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.LongFunction;

public class Group {
    private String name;
    private String description;
    private ArrayList<Item> items;
    Item[] itemsArray = new Item[0];

    Group(String name, String description) {
        this.name = name;
        this.description = description;
        this.items = new ArrayList();
    }

    void setDescription(String description) {
        this.description = description;
    }

    synchronized <V extends Value> Item<V> makeItem(String name, LongFunction<V> valueFactory, String description, long now) {
        for (Item i : this.items) {
            if (!i.getName().equals(name)) continue;
            return i;
        }
        Item<Value> i = new Item<Value>(this, name, (Value)valueFactory.apply(now), description);
        this.addItem(i);
        return i;
    }

    synchronized <V extends Value, Arg> Item<V> makeItem(String name, BiFunction<Long, Arg, V> valueFactory, String description, long now, Arg arg) {
        for (Item i : this.items) {
            if (!i.getName().equals(name)) continue;
            return i;
        }
        Item<Value> i = new Item<Value>(this, name, (Value)valueFactory.apply(now, arg), description);
        this.addItem(i);
        return i;
    }

    public synchronized Item getItem(String id) {
        for (Item i : this.items) {
            if (!i.name.equals(id)) continue;
            return i;
        }
        return null;
    }

    public synchronized void addItem(Item i) {
        this.items.add(i);
        this.itemsArray = this.items.toArray(this.itemsArray);
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public Item[] getItems() {
        return this.itemsArray;
    }

    public void update(ItemUpdateListener listener, long logInterval, long now, long appNow) {
        Item[] arr = this.itemsArray;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].update(listener, logInterval, now, appNow);
        }
    }
}

