/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.stats;

import io.deephaven.base.stats.State;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.stats.Value;
import java.util.function.BiFunction;

public class HistogramState
extends State {
    public static final char TYPE_TAG = 'H';
    private long rangeMin;
    private long rangeMax;
    private double rangeBucket;
    private State[] buckets;
    public static final BiFunction<Long, Spec, HistogramState> FACTORY = HistogramState::new;

    private int getBucket(long sample) {
        if (sample < this.rangeMin) {
            return 0;
        }
        if (sample >= this.rangeMax) {
            return this.buckets.length - 1;
        }
        return 1 + (int)((double)(sample - this.rangeMin) / this.rangeBucket);
    }

    public HistogramState(long now, Spec spec) {
        super(now);
        this.rangeMin = spec.rangeMin;
        this.rangeMax = spec.rangeMax;
        this.rangeBucket = (double)(this.rangeMax - this.rangeMin) / (double)spec.numBuckets;
        this.buckets = new State[spec.numBuckets + 2];
        this.buckets[0] = Stats.makeItem(spec.groupName, spec.itemName + "[0]", State.FACTORY, "Values of " + spec.itemName + " less than " + this.rangeMin, now).getValue();
        for (int i = 1; i <= spec.numBuckets; ++i) {
            this.buckets[i] = Stats.makeItem(spec.groupName, spec.itemName + "[" + i + "]", State.FACTORY, "Values of " + spec.itemName + " between " + (long)((double)this.rangeMin + (double)(i - 1) * this.rangeBucket) + " (incl.) and " + (long)((double)this.rangeMin + (double)i * this.rangeBucket) + " (excl.)", now).getValue();
        }
        this.buckets[spec.numBuckets + 1] = Stats.makeItem(spec.groupName, spec.itemName + "[" + (spec.numBuckets + 1) + "]", State.FACTORY, "Values of " + spec.itemName + " at least " + this.rangeMax, now).getValue();
    }

    @Override
    public char getTypeTag() {
        return 'H';
    }

    @Override
    public Value alwaysUpdated(boolean b) {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].alwaysUpdated(b);
        }
        return super.alwaysUpdated(b);
    }

    @Override
    public void sample(long x) {
        super.sample(x);
        this.buckets[this.getBucket(x)].sample(x);
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].reset();
        }
    }

    public static class Spec {
        String groupName;
        String itemName;
        long rangeMin;
        long rangeMax;
        int numBuckets;

        public Spec(String groupName, String itemName, long rangeMin, long rangeMax, int numBuckets) {
            this.groupName = groupName;
            this.itemName = itemName;
            this.rangeMin = rangeMin;
            this.rangeMax = rangeMax;
            this.numBuckets = numBuckets;
        }
    }
}

