/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.stats;

import io.deephaven.base.stats.Value;

public class History {
    public static final long[] INTERVALS = new long[]{1000L, 10000L, 60000L, 300000L, 900000L, Long.MAX_VALUE};
    public static final String[] INTERVAL_NAMES = new String[]{"1s", "10s", "1m", "5m", "15m", "total"};
    public static final int INTERVAL_1S_INDEX = 0;
    public static final int INTERVAL_10S_INDEX = 1;
    public static final int INTERVAL_1M_INDEX = 2;
    public static final int INTERVAL_5M_INDEX = 3;
    public static final int INTERVAL_15M_INDEX = 4;
    public static final int INTERVAL_TOTAL_INDEX = 5;
    public static final int DEPTH = 2;
    private long[][] n = new long[INTERVALS.length][2];
    private long[][] last = new long[INTERVALS.length][2];
    private long[][] sum = new long[INTERVALS.length][2];
    private long[][] sum2 = new long[INTERVALS.length][2];
    private long[][] max = new long[INTERVALS.length][2];
    private long[][] min = new long[INTERVALS.length][2];
    private int[] currentDepth = new int[INTERVALS.length];
    private long[] nextUpdate = new long[INTERVALS.length];

    public static int intervalIndex(String s) {
        for (int i = 0; i < INTERVAL_NAMES.length; ++i) {
            if (!s.equals(INTERVAL_NAMES[i])) continue;
            return i;
        }
        return -1;
    }

    public History(long now) {
        int i;
        for (i = 0; i < INTERVALS.length; ++i) {
            for (int d = 0; d < 2; ++d) {
                this.max[i][d] = Long.MIN_VALUE;
                this.min[i][d] = Long.MAX_VALUE;
            }
        }
        for (i = 0; i < INTERVALS.length; ++i) {
            this.nextUpdate[i] = now + INTERVALS[i] - now % INTERVALS[i];
        }
    }

    public int update(Value v, long now) {
        int topInterval = 0;
        long vn = v.n;
        long vlast = v.last;
        long vsum = v.sum;
        long vsum2 = v.sum2;
        long vmin = v.min;
        long vmax = v.max;
        for (int i = 0; i < INTERVALS.length; ++i) {
            int d = this.currentDepth[i];
            long[] lArray = this.n[i];
            int n = d;
            lArray[n] = lArray[n] + vn;
            this.last[i][d] = vlast;
            long[] lArray2 = this.sum[i];
            int n2 = d;
            lArray2[n2] = lArray2[n2] + vsum;
            long[] lArray3 = this.sum2[i];
            int n3 = d;
            lArray3[n3] = lArray3[n3] + vsum2;
            if (vmax > this.max[i][d]) {
                this.max[i][d] = vmax;
            }
            if (vmin < this.min[i][d]) {
                this.min[i][d] = vmin;
            }
            if (now < this.nextUpdate[i]) continue;
            topInterval = i;
            if (--d < 0) {
                d = 1;
            }
            this.currentDepth[i] = d;
            this.n[i][d] = 0L;
            this.last[i][d] = 0L;
            this.sum[i][d] = 0L;
            this.sum2[i][d] = 0L;
            this.max[i][d] = Long.MIN_VALUE;
            this.min[i][d] = Long.MAX_VALUE;
            int n4 = i;
            this.nextUpdate[n4] = this.nextUpdate[n4] + INTERVALS[i];
        }
        return topInterval;
    }

    public long getLast(int i, int d) {
        return this.last[i][(this.currentDepth[i] + d) % 2];
    }

    public long getSum(int i, int d) {
        return this.sum[i][(this.currentDepth[i] + d) % 2];
    }

    public long getSum2(int i, int d) {
        return this.sum2[i][(this.currentDepth[i] + d) % 2];
    }

    public long getN(int i, int d) {
        return this.n[i][(this.currentDepth[i] + d) % 2];
    }

    public long getMax(int i, int d) {
        return this.max[i][(this.currentDepth[i] + d) % 2];
    }

    public long getMin(int i, int d) {
        return this.min[i][(this.currentDepth[i] + d) % 2];
    }

    public long getAvg(int i, int d) {
        long n = this.getN(i, d);
        return n == 0L ? 0L : this.getSum(i, d) / n;
    }

    public long getStdev(int i, int d) {
        long nSamples = this.getN(i, d);
        double sum = this.getSum(i, d);
        double sum2 = this.getSum2(i, d);
        double ave = sum / (double)nSamples;
        if (nSamples <= 1L) {
            return 0L;
        }
        double var = sum2 / (double)(nSamples - 1L) - ave * ave * ((double)nSamples / (double)(nSamples - 1L));
        if (var < 0.0) {
            return -1L;
        }
        return (long)Math.ceil(Math.sqrt(var));
    }
}

