/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.string.cache.CharSequenceUtils;
import io.deephaven.base.string.cache.StringAlike;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCompressedString<TYPE extends AbstractCompressedString>
implements StringAlike<TYPE> {
    private static final long serialVersionUID = -2596527344240947333L;
    private static final Charset ENCODING = StandardCharsets.ISO_8859_1;
    private final byte[] data;
    private int cachedHashCode;

    AbstractCompressedString() {
        this.data = new byte[0];
    }

    AbstractCompressedString(String data) {
        this.data = data.getBytes(ENCODING);
    }

    AbstractCompressedString(char[] data, int offset, int length) {
        this.data = new byte[length];
        for (int bi = 0; bi < length; ++bi) {
            this.data[bi] = (byte)data[offset + bi];
        }
    }

    AbstractCompressedString(char[] data) {
        this(data, 0, data.length);
    }

    AbstractCompressedString(ByteBuffer data, int offset, int length) {
        ByteBuffer readOnlyBufferView = data.asReadOnlyBuffer();
        readOnlyBufferView.position(offset);
        readOnlyBufferView.limit(offset + length);
        this.data = new byte[length];
        readOnlyBufferView.get(this.data);
    }

    AbstractCompressedString(ByteBuffer data) {
        this(data, data.position(), data.remaining());
    }

    AbstractCompressedString(byte[] data, int offset, int length) {
        this.data = Arrays.copyOfRange(data, offset, offset + length);
    }

    AbstractCompressedString(byte[] data) {
        this(data, 0, data.length);
    }

    protected abstract TYPE convertValue(String var1);

    protected abstract TYPE convertValue(byte[] var1, int var2, int var3);

    private TYPE convertValue(byte[] data) {
        return this.convertValue(data, 0, data.length);
    }

    private TYPE[] convertArray(String ... strings) {
        StringAlike[] result = new StringAlike[strings.length];
        for (int si = 0; si < strings.length; ++si) {
            result[si] = this.convertValue(strings[si]);
        }
        return (AbstractCompressedString[])result;
    }

    public final byte[] getData() {
        return this.data;
    }

    @Override
    public final int length() {
        return this.data.length;
    }

    @Override
    public final char charAt(int index) {
        return (char)(this.data[index] & 0xFF);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @Override
    @NotNull
    public final String toString() {
        return new String(this.data, ENCODING);
    }

    @Override
    public final int compareTo(@NotNull CharSequence that) {
        return CharSequenceUtils.CASE_SENSITIVE_COMPARATOR.compare(this, that);
    }

    @Override
    public final int hashCode() {
        int hashCode = this.cachedHashCode;
        if (hashCode == 0 && this.data.length > 0) {
            for (int bi = 0; bi < this.data.length; ++bi) {
                hashCode = 31 * hashCode + this.data[bi];
            }
            this.cachedHashCode = hashCode;
        }
        return hashCode;
    }

    @Override
    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        AbstractCompressedString thatType = (AbstractCompressedString)that;
        if (this.data.length != thatType.length()) {
            return false;
        }
        for (int bi = 0; bi < this.data.length; ++bi) {
            if (this.data[bi] == thatType.getData()[bi]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public final int codePointAt(int index) {
        return this.charAt(index);
    }

    @Override
    public final int codePointBefore(int index) {
        return this.charAt(index - 1);
    }

    @Override
    public final int codePointCount(int beginIndex, int endIndex) {
        return endIndex - beginIndex;
    }

    @Override
    public final void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int di = dstBegin;
        for (int si = srcBegin; si < srcEnd; ++si) {
            dst[di++] = this.charAt(si);
        }
    }

    @Override
    public final byte[] getBytes() {
        return (byte[])this.data.clone();
    }

    @Override
    public final boolean contentEquals(@NotNull CharSequence cs) {
        return this.data.length == cs.length() && (cs.equals(this) || CharSequenceUtils.contentEquals(this, cs));
    }

    @Override
    public final boolean equalsIgnoreCase(@NotNull CharSequence that) {
        return CharSequenceUtils.contentEqualsIgnoreCase(this, that);
    }

    @Override
    public final int compareToIgnoreCase(@NotNull CharSequence that) {
        return CharSequenceUtils.CASE_INSENSITIVE_COMPARATOR.compare(this, that);
    }

    @Override
    public final boolean regionMatches(boolean ignoreCase, int offset, CharSequence that, int thatOffset, int length) {
        return CharSequenceUtils.regionMatches(ignoreCase, this, offset, that, thatOffset, length);
    }

    @Override
    public final boolean startsWith(@NotNull CharSequence prefix, int offset) {
        return CharSequenceUtils.regionMatches(false, this, offset, prefix, 0, prefix.length());
    }

    @Override
    public final boolean startsWith(@NotNull CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    @Override
    public final boolean endsWith(@NotNull CharSequence suffix) {
        return this.startsWith(suffix, this.data.length - suffix.length());
    }

    @Override
    public final int indexOf(int ch, int fromIndex) {
        if (fromIndex >= this.data.length) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int ci = fromIndex; ci < this.data.length; ++ci) {
            if (this.charAt(ci) != ch) continue;
            return ci;
        }
        return -1;
    }

    @Override
    public final int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    @Override
    public final int lastIndexOf(int ch, int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= this.data.length) {
            fromIndex = this.data.length;
        }
        for (int ci = fromIndex; ci >= 0; --ci) {
            if (this.charAt(ci) != ch) continue;
            return ci;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.data.length - 1);
    }

    @Override
    public final TYPE substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.data.length) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        return (TYPE)(beginIndex == 0 && endIndex == this.data.length ? this : this.convertValue(this.data, beginIndex, endIndex - beginIndex));
    }

    @Override
    public final TYPE substring(int beginIndex) {
        return (TYPE)this.substring(beginIndex, this.data.length);
    }

    @Override
    public final TYPE concat(String other) {
        if (other.length() == 0) {
            return (TYPE)this;
        }
        byte[] otherData = other.getBytes(ENCODING);
        byte[] concatenatedData = Arrays.copyOf(this.data, this.data.length + otherData.length);
        System.arraycopy(otherData, 0, concatenatedData, this.data.length, otherData.length);
        return this.convertValue(concatenatedData);
    }

    @Override
    public final TYPE concat(TYPE other) {
        if (((AbstractCompressedString)other).length() == 0) {
            return (TYPE)this;
        }
        byte[] concatenatedData = Arrays.copyOf(this.data, this.data.length + ((AbstractCompressedString)other).length());
        System.arraycopy(((AbstractCompressedString)other).getData(), 0, concatenatedData, this.data.length, ((AbstractCompressedString)other).length());
        return this.convertValue(concatenatedData);
    }

    @Override
    public final boolean matches(CharSequence regex) {
        return Pattern.matches(regex.toString(), this);
    }

    @Override
    public final TYPE trim() {
        int bii;
        int eii = this.data.length - 1;
        for (bii = 0; bii <= eii && this.charAt(bii) <= ' '; ++bii) {
        }
        while (eii > bii && this.charAt(eii) <= ' ') {
            --eii;
        }
        return (TYPE)(bii == 0 && eii == this.data.length - 1 ? this : this.substring(bii, eii + 1));
    }

    @Override
    public final char[] toCharArray() {
        char[] result = new char[this.data.length];
        this.getChars(0, this.data.length, result, 0);
        return result;
    }

    @Override
    public final int indexOf(CharSequence cs, int fromIndex) {
        return this.toString().indexOf(cs.toString(), fromIndex);
    }

    @Override
    public final int indexOf(CharSequence cs) {
        return this.indexOf(cs, 0);
    }

    @Override
    public final int lastIndexOf(CharSequence cs, int fromIndex) {
        return this.toString().lastIndexOf(cs.toString(), fromIndex);
    }

    @Override
    public final int lastIndexOf(CharSequence cs) {
        return this.lastIndexOf(cs, cs.length());
    }

    @Override
    public final TYPE replace(char oldChar, char newChar) {
        return this.convertValue(this.toString().replace(oldChar, newChar));
    }

    @Override
    public final boolean contains(CharSequence cs) {
        return this.indexOf(cs) > -1;
    }

    @Override
    public final TYPE replaceFirst(CharSequence regex, CharSequence replacement) {
        return this.convertValue(Pattern.compile(regex.toString()).matcher(this).replaceFirst(replacement.toString()));
    }

    @Override
    public final TYPE replaceAll(CharSequence regex, CharSequence replacement) {
        return this.convertValue(Pattern.compile(regex.toString()).matcher(this).replaceAll(replacement.toString()));
    }

    @Override
    public final TYPE replace(CharSequence target, CharSequence replacement) {
        return this.convertValue(Pattern.compile(target.toString(), 16).matcher(this.toString()).replaceAll(Matcher.quoteReplacement(replacement.toString())));
    }

    @Override
    public final TYPE[] split(CharSequence regex, int limit) {
        return this.convertArray(this.toString().split(regex.toString(), limit));
    }

    @Override
    public final TYPE[] split(CharSequence regex) {
        return this.split(regex, 0);
    }

    @Override
    public final TYPE toLowerCase(Locale locale) {
        return this.convertValue(this.toString().toLowerCase(locale));
    }

    @Override
    public final TYPE toLowerCase() {
        return (TYPE)this.toLowerCase(Locale.getDefault());
    }

    @Override
    public final TYPE toUpperCase(Locale locale) {
        return this.convertValue(this.toString().toUpperCase(locale));
    }

    @Override
    public final TYPE toUpperCase() {
        return (TYPE)this.toUpperCase(Locale.getDefault());
    }

    @Override
    public final TYPE intern() {
        throw new UnsupportedOperationException();
    }
}

