/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.string.cache.CharSequenceUtils;
import io.deephaven.base.string.cache.StringCompatible;
import org.jetbrains.annotations.NotNull;

public abstract class CharSequenceAdapter
implements StringCompatible {
    int cachedHashCode;

    public abstract CharSequenceAdapter clear();

    @Override
    @NotNull
    public final String toString() {
        return this.makeString();
    }

    protected abstract String makeString();

    @Override
    public final int hashCode() {
        if (this.cachedHashCode == 0 && this.length() > 0) {
            this.cachedHashCode = CharSequenceUtils.hashCode(this);
        }
        return this.cachedHashCode;
    }

    @Override
    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return CharSequenceUtils.contentEquals(this, (CharSequence)that);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int compareTo(@NotNull CharSequence that) {
        return CharSequenceUtils.CASE_SENSITIVE_COMPARATOR.compare(this, that);
    }
}

