/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.MathUtil;
import io.deephaven.base.string.cache.CharSequenceAdapter;
import io.deephaven.base.string.cache.CompressedString;
import io.deephaven.base.string.cache.MappedCompressedString;
import org.jetbrains.annotations.NotNull;

public class CharSequenceAdapterBuilder
extends CharSequenceAdapter {
    private char[] storage = new char[0];
    private int used;

    @Override
    protected final String makeString() {
        return new String(this.storage, 0, this.used);
    }

    @Override
    @NotNull
    public CompressedString toCompressedString() {
        return new CompressedString(this.storage, 0, this.used);
    }

    @Override
    @NotNull
    public MappedCompressedString toMappedCompressedString() {
        return new MappedCompressedString(this.storage, 0, this.used);
    }

    public final void reserveCapacity(int needed) {
        this.ensureSpace(needed);
    }

    private char[] ensureSpace(int needed) {
        if (this.storage.length < this.used + needed) {
            char[] copy = new char[1 << MathUtil.ceilLog2(this.used + needed)];
            if (this.used > 0) {
                System.arraycopy(this.storage, 0, copy, 0, this.used);
            }
            this.storage = copy;
        }
        return this.storage;
    }

    public final CharSequenceAdapterBuilder append(String value, int offset, int length) {
        if (length > 0) {
            value.getChars(offset, offset + length, this.ensureSpace(length), this.used);
            this.used += length;
            this.cachedHashCode = 0;
        }
        return this;
    }

    public final CharSequenceAdapterBuilder append(String value) {
        return this.append(value, 0, value.length());
    }

    public final CharSequenceAdapterBuilder append(CharSequence value, int offset, int length) {
        if (length > 0) {
            this.ensureSpace(length);
            this.cachedHashCode = 0;
            for (int ci = 0; ci < length; ++ci) {
                this.storage[this.used++] = value.charAt(offset + ci);
            }
        }
        return this;
    }

    public final CharSequenceAdapterBuilder append(CharSequence value) {
        return this.append(value, 0, value.length());
    }

    public final CharSequenceAdapterBuilder append(char[] value, int offset, int length) {
        if (length > 0) {
            System.arraycopy(value, offset, this.ensureSpace(length), this.used, length);
            this.used += length;
            this.cachedHashCode = 0;
        }
        return this;
    }

    public final CharSequenceAdapterBuilder append(char[] value) {
        return this.append(value, 0, value.length);
    }

    public final CharSequenceAdapterBuilder append(char value) {
        this.ensureSpace((int)1)[this.used++] = value;
        this.cachedHashCode = 0;
        return this;
    }

    public final CharSequenceAdapterBuilder append(byte[] value, int offset, int length) {
        if (length > 0) {
            this.ensureSpace(length);
            for (int bi = offset; bi < offset + length; ++bi) {
                this.storage[this.used++] = (char)(value[bi] & 0xFF);
            }
            this.cachedHashCode = 0;
        }
        return this;
    }

    public final CharSequenceAdapterBuilder append(byte[] value) {
        return this.append(value, 0, value.length);
    }

    public final CharSequenceAdapterBuilder append(byte value) {
        this.ensureSpace((int)1)[this.used++] = (char)(value & 0xFF);
        this.cachedHashCode = 0;
        return this;
    }

    @Override
    public final CharSequenceAdapterBuilder clear() {
        this.used = 0;
        this.cachedHashCode = 0;
        return this;
    }

    @Override
    public final int length() {
        return this.used;
    }

    @Override
    public final char charAt(int index) {
        return this.storage[index];
    }
}

