/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharSequenceUtils {
    public static final Comparator<CharSequence> CASE_SENSITIVE_COMPARATOR = new CaseSensitiveComparator();
    public static final Comparator<CharSequence> CASE_INSENSITIVE_COMPARATOR = new CaseInsensitiveComparator();

    public static int hashCode(@NotNull CharSequence charSequence) {
        int hashCode = 0;
        int length = charSequence.length();
        for (int ci = 0; ci < length; ++ci) {
            hashCode = 31 * hashCode + charSequence.charAt(ci);
        }
        return hashCode;
    }

    public static int caseInsensitiveHashCode(@NotNull CharSequence charSequence) {
        int hashCode = 0;
        int length = charSequence.length();
        for (int ci = 0; ci < length; ++ci) {
            hashCode = 31 * hashCode + Character.toUpperCase(charSequence.charAt(ci));
        }
        return hashCode;
    }

    public static boolean contentEquals(@NotNull CharSequence cs1, @NotNull CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        int cs1Length = cs1.length();
        if (cs1Length != cs2.length()) {
            return false;
        }
        for (int ci = 0; ci < cs1Length; ++ci) {
            if (cs1.charAt(ci) == cs2.charAt(ci)) continue;
            return false;
        }
        return true;
    }

    public static boolean nullSafeContentEquals(@Nullable CharSequence cs1, @Nullable CharSequence cs2) {
        if (cs1 == null || cs2 == null) {
            return cs1 == cs2;
        }
        return CharSequenceUtils.contentEquals(cs1, cs2);
    }

    public static boolean contentEqualsIgnoreCase(@NotNull CharSequence cs1, @NotNull CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        int cs1Length = cs1.length();
        if (cs1Length != cs2.length()) {
            return false;
        }
        for (int ci = 0; ci < cs1Length; ++ci) {
            char cs2Char;
            char cs1Char = cs1.charAt(ci);
            if (cs1Char == (cs2Char = cs2.charAt(ci)) || (cs1Char = Character.toUpperCase(cs1Char)) == (cs2Char = Character.toUpperCase(cs2Char))) continue;
            return false;
        }
        return true;
    }

    public static boolean nullSafeContentEqualsIgnoreCase(@Nullable CharSequence cs1, @Nullable CharSequence cs2) {
        if (cs1 == null || cs2 == null) {
            return cs1 == cs2;
        }
        return CharSequenceUtils.contentEqualsIgnoreCase(cs1, cs2);
    }

    public static boolean regionMatches(boolean ignoreCase, CharSequence cs1, int cs1Offset, CharSequence cs2, int cs2Offset, int length) {
        for (int ci = 0; ci < length; ++ci) {
            char cs2Char;
            char cs1Char = cs1.charAt(cs1Offset + ci);
            if (cs1Char == (cs2Char = cs2.charAt(cs2Offset + ci)) || ignoreCase && (cs1Char = Character.toUpperCase(cs1Char)) == (cs2Char = Character.toUpperCase(cs2Char))) continue;
            return false;
        }
        return true;
    }

    private static class CaseInsensitiveComparator
    implements Comparator<CharSequence> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(@NotNull CharSequence cs1, @NotNull CharSequence cs2) {
            int cs1Length = cs1.length();
            int cs2Length = cs2.length();
            int minLength = Math.min(cs1Length, cs2Length);
            for (int ci = 0; ci < minLength; ++ci) {
                char cs2Char;
                char cs1Char = cs1.charAt(ci);
                if (cs1Char == (cs2Char = cs2.charAt(ci)) || (cs1Char = Character.toUpperCase(cs1Char)) == (cs2Char = Character.toUpperCase(cs2Char))) continue;
                return cs1Char - cs2Char;
            }
            return cs1Length - cs2Length;
        }
    }

    private static class CaseSensitiveComparator
    implements Comparator<CharSequence> {
        private CaseSensitiveComparator() {
        }

        @Override
        public int compare(@NotNull CharSequence cs1, @NotNull CharSequence cs2) {
            int cs1Length = cs1.length();
            int cs2Length = cs2.length();
            int minLength = Math.min(cs1Length, cs2Length);
            for (int ci = 0; ci < minLength; ++ci) {
                char cs2Char;
                char cs1Char = cs1.charAt(ci);
                if (cs1Char == (cs2Char = cs2.charAt(ci))) continue;
                return cs1Char - cs2Char;
            }
            return cs1Length - cs2Length;
        }
    }
}

