/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.string.cache.CharSequenceUtils;
import io.deephaven.base.string.cache.StringCache;
import io.deephaven.base.string.cache.StringCacheTypeAdapter;
import io.deephaven.base.string.cache.StringCompatible;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.hash.KeyedObjectHash;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import org.jetbrains.annotations.NotNull;

public class ConcurrentUnboundedStringCache<STRING_LIKE_TYPE extends CharSequence>
implements StringCache<STRING_LIKE_TYPE> {
    private final StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter;
    private final KeyedObjectHashMap<CharSequence, STRING_LIKE_TYPE> cache;
    private final KeyedObjectHash.ValueFactory<CharSequence, STRING_LIKE_TYPE> stringCompatibleKeyValueFactory;
    private final KeyedObjectHash.ValueFactory<CharSequence, STRING_LIKE_TYPE> stringKeyValueFactory;

    public ConcurrentUnboundedStringCache(@NotNull StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter, int initialCapacity, boolean debug) {
        this.typeAdapter = Require.neqNull(typeAdapter, "typeAdapter");
        this.cache = new KeyedObjectHashMap(initialCapacity, (KeyedObjectKey)new KeyImpl());
        this.stringCompatibleKeyValueFactory = debug ? new CheckedStringCompatibleKeyValueFactory() : new UncheckedStringCompatibleKeyValueFactory();
        this.stringKeyValueFactory = new StringKeyValueFactory();
    }

    @Override
    public final int capacity() {
        return -1;
    }

    @Override
    @NotNull
    public final Class<STRING_LIKE_TYPE> getType() {
        return this.typeAdapter.getType();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getEmptyString() {
        return this.typeAdapter.empty();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull StringCompatible protoString) {
        CharSequence existingValue = (CharSequence)this.cache.get((Object)protoString);
        if (existingValue != null) {
            return (STRING_LIKE_TYPE)existingValue;
        }
        CharSequence candidateValue = (CharSequence)this.stringCompatibleKeyValueFactory.newValue((Object)protoString);
        existingValue = (CharSequence)this.cache.putIfAbsent((Object)candidateValue, (Object)candidateValue);
        if (existingValue != null) {
            return (STRING_LIKE_TYPE)existingValue;
        }
        return (STRING_LIKE_TYPE)candidateValue;
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull String string) {
        return (STRING_LIKE_TYPE)((CharSequence)this.cache.putIfAbsent((Object)string, this.stringKeyValueFactory));
    }

    private class StringKeyValueFactory
    implements KeyedObjectHash.ValueFactory<CharSequence, STRING_LIKE_TYPE> {
        private StringKeyValueFactory() {
        }

        public STRING_LIKE_TYPE newValue(CharSequence key) {
            return ConcurrentUnboundedStringCache.this.typeAdapter.create((String)key);
        }
    }

    private class CheckedStringCompatibleKeyValueFactory
    implements KeyedObjectHash.ValueFactory<CharSequence, STRING_LIKE_TYPE> {
        private CheckedStringCompatibleKeyValueFactory() {
        }

        public STRING_LIKE_TYPE newValue(CharSequence key) {
            Object value = ConcurrentUnboundedStringCache.this.typeAdapter.create((StringCompatible)key);
            Assert.assertion(CharSequenceUtils.contentEquals(key, value), "CharSequenceUtils.contentEquals(key, value)", key, "key", value, "value");
            Assert.eq(key.hashCode(), "key.hashCode", value.hashCode(), "value.hashCode()");
            return value;
        }
    }

    private class UncheckedStringCompatibleKeyValueFactory
    implements KeyedObjectHash.ValueFactory<CharSequence, STRING_LIKE_TYPE> {
        private UncheckedStringCompatibleKeyValueFactory() {
        }

        public STRING_LIKE_TYPE newValue(CharSequence key) {
            return ConcurrentUnboundedStringCache.this.typeAdapter.create((StringCompatible)key);
        }
    }

    private class KeyImpl
    implements KeyedObjectKey<CharSequence, STRING_LIKE_TYPE> {
        private KeyImpl() {
        }

        public CharSequence getKey(STRING_LIKE_TYPE value) {
            return value;
        }

        public int hashKey(CharSequence key) {
            return key.hashCode();
        }

        public boolean equalKey(CharSequence key, STRING_LIKE_TYPE value) {
            return ConcurrentUnboundedStringCache.this.typeAdapter.areEqual(key, value);
        }
    }
}

