/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.reference.SimpleReference;
import io.deephaven.base.string.cache.AbstractCompressedString;
import io.deephaven.base.string.cache.CompressedString;
import io.deephaven.base.verify.Require;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public final class MappedCompressedString
extends AbstractCompressedString<MappedCompressedString> {
    public static final int NULL_MAPPING_VALUE = -1;
    private static final int NULL_INDEX = -1;
    private transient SimpleReference<?>[] keys = new SimpleReference[1];
    private transient int[] values = new int[1];

    public MappedCompressedString(String data) {
        super(data);
    }

    public MappedCompressedString(char[] data, int offset, int length) {
        super(data, offset, length);
    }

    public MappedCompressedString(char[] data) {
        super(data);
    }

    public MappedCompressedString(ByteBuffer data, int offset, int length) {
        super(data, offset, length);
    }

    public MappedCompressedString(ByteBuffer data) {
        super(data);
    }

    public MappedCompressedString(byte[] data, int offset, int length) {
        super(data, offset, length);
    }

    public MappedCompressedString(byte[] data) {
        super(data);
    }

    @Override
    @NotNull
    public CompressedString toCompressedString() {
        return new CompressedString(this.getData());
    }

    @Override
    @NotNull
    public MappedCompressedString toMappedCompressedString() {
        return this;
    }

    @Override
    protected final MappedCompressedString convertValue(String string) {
        return new MappedCompressedString(string);
    }

    @Override
    protected final MappedCompressedString convertValue(byte[] data, int offset, int length) {
        return new MappedCompressedString(data, offset, length);
    }

    public final synchronized int capacity() {
        return this.keys.length;
    }

    public final synchronized int putIfAbsent(SimpleReference<?> key, int potentialValue) {
        return this.putIfAbsentInternal(Require.neqNull(key, "key"), Require.neq(potentialValue, "potentialValue", -1, "NULL_MAPPING_VALUE"), true);
    }

    private int putIfAbsentInternal(SimpleReference<?> key, int potentialValue, boolean allowRehash) {
        int firstIndex = this.firstIndexFor(key);
        int firstDeletedIndex = -1;
        SimpleReference<?> candidate = this.keys[firstIndex];
        if (candidate == key) {
            return this.values[firstIndex];
        }
        if (candidate == null) {
            this.keys[firstIndex] = key;
            this.values[firstIndex] = potentialValue;
            return -1;
        }
        if (candidate.get() == null) {
            firstDeletedIndex = firstIndex;
        }
        int ki = this.nextIndex(firstIndex);
        while (ki != firstIndex) {
            candidate = this.keys[ki];
            if (candidate == key) {
                return this.values[ki];
            }
            if (candidate == null) {
                if (firstDeletedIndex != -1) {
                    this.keys[firstDeletedIndex] = key;
                    this.values[firstDeletedIndex] = potentialValue;
                    return -1;
                }
                this.keys[ki] = key;
                this.values[ki] = potentialValue;
                return -1;
            }
            if (firstDeletedIndex == -1 && candidate.get() == null) {
                firstDeletedIndex = ki;
            }
            ki = this.nextIndex(ki);
        }
        if (firstDeletedIndex != -1) {
            this.keys[firstDeletedIndex] = key;
            this.values[firstDeletedIndex] = potentialValue;
            return -1;
        }
        if (allowRehash) {
            this.rehash();
            return this.putIfAbsentInternal(key, potentialValue, false);
        }
        throw new IllegalStateException("BUG: No free space found for <" + key + "," + potentialValue + ">, but allowRehash is false!");
    }

    private int firstIndexFor(SimpleReference<?> key) {
        return System.identityHashCode(key) & this.keys.length - 1;
    }

    private int nextIndex(int index) {
        return index + 1 & this.keys.length - 1;
    }

    private void rehash() {
        SimpleReference<?>[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.keys = new SimpleReference[oldKeys.length * 2];
        this.values = new int[this.keys.length];
        for (int rsi = 0; rsi < oldKeys.length; ++rsi) {
            SimpleReference<?> key = oldKeys[rsi];
            if (key.get() == null || this.putIfAbsentInternal(key, oldValues[rsi], false) == -1) continue;
            throw new IllegalStateException("BUG: Mapping for <" + oldKeys[rsi] + "," + oldValues[rsi] + "> already present during rehash!");
        }
    }
}

