/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.string.cache;

import io.deephaven.base.cache.OpenAddressedCanonicalizationCache;
import io.deephaven.base.string.cache.StringCache;
import io.deephaven.base.string.cache.StringCacheTypeAdapter;
import io.deephaven.base.string.cache.StringCompatible;
import org.jetbrains.annotations.NotNull;

public class OpenAddressedWeakUnboundedStringCache<STRING_LIKE_TYPE extends CharSequence>
implements StringCache<STRING_LIKE_TYPE> {
    private final StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter;
    private final OpenAddressedCanonicalizationCache cache;
    private final OpenAddressedCanonicalizationCache.Adapter<String, STRING_LIKE_TYPE> stringC14nAdapter;
    private final OpenAddressedCanonicalizationCache.Adapter<StringCompatible, STRING_LIKE_TYPE> stringCompatibleC14nAdapter;

    public OpenAddressedWeakUnboundedStringCache(@NotNull StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter, int initialCapacity) {
        this(typeAdapter, new OpenAddressedCanonicalizationCache(initialCapacity));
    }

    public OpenAddressedWeakUnboundedStringCache(@NotNull StringCacheTypeAdapter<STRING_LIKE_TYPE> typeAdapter, @NotNull OpenAddressedCanonicalizationCache cache) {
        this.typeAdapter = typeAdapter;
        this.cache = cache;
        this.stringC14nAdapter = new StringCanonicalizationCacheAdapter();
        this.stringCompatibleC14nAdapter = new StringCompatibleCanonicalizationCacheAdapter();
    }

    @Override
    public final int capacity() {
        return -1;
    }

    @Override
    @NotNull
    public final Class<STRING_LIKE_TYPE> getType() {
        return this.typeAdapter.getType();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getEmptyString() {
        return this.typeAdapter.empty();
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull StringCompatible protoString) {
        return (STRING_LIKE_TYPE)((CharSequence)this.cache.getCachedItem(protoString, this.stringCompatibleC14nAdapter));
    }

    @Override
    @NotNull
    public final STRING_LIKE_TYPE getCachedString(@NotNull String string) {
        return (STRING_LIKE_TYPE)((CharSequence)this.cache.getCachedItem(string, this.stringC14nAdapter));
    }

    private class StringCompatibleCanonicalizationCacheAdapter
    implements OpenAddressedCanonicalizationCache.Adapter<StringCompatible, STRING_LIKE_TYPE> {
        private StringCompatibleCanonicalizationCacheAdapter() {
        }

        @Override
        public boolean equals(@NotNull StringCompatible inputItem, @NotNull Object cachedItem) {
            return OpenAddressedWeakUnboundedStringCache.this.typeAdapter.getType() == cachedItem.getClass() && OpenAddressedWeakUnboundedStringCache.this.typeAdapter.areEqual(inputItem, (CharSequence)cachedItem);
        }

        @Override
        public int hashCode(@NotNull StringCompatible inputItem) {
            return inputItem.hashCode();
        }

        @Override
        public STRING_LIKE_TYPE makeCacheableItem(@NotNull StringCompatible inputItem) {
            return OpenAddressedWeakUnboundedStringCache.this.typeAdapter.create(inputItem);
        }
    }

    private class StringCanonicalizationCacheAdapter
    implements OpenAddressedCanonicalizationCache.Adapter<String, STRING_LIKE_TYPE> {
        private StringCanonicalizationCacheAdapter() {
        }

        @Override
        public boolean equals(@NotNull String inputItem, @NotNull Object cachedItem) {
            return OpenAddressedWeakUnboundedStringCache.this.typeAdapter.getType() == cachedItem.getClass() && OpenAddressedWeakUnboundedStringCache.this.typeAdapter.areEqual(inputItem, (CharSequence)cachedItem);
        }

        @Override
        public int hashCode(@NotNull String inputItem) {
            return inputItem.hashCode();
        }

        @Override
        public STRING_LIKE_TYPE makeCacheableItem(@NotNull String inputItem) {
            return OpenAddressedWeakUnboundedStringCache.this.typeAdapter.create(inputItem);
        }
    }
}

