/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.system;

import io.deephaven.base.system.MultipleOutputStreams;
import io.deephaven.base.system.StandardStreamReceiver;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class StandardStreamState {
    private final Set<StandardStreamReceiver> receivers;
    private final AtomicBoolean initialized;

    public StandardStreamState(Set<StandardStreamReceiver> receivers) {
        this.receivers = Objects.requireNonNull(receivers);
        this.initialized = new AtomicBoolean(false);
    }

    public void setupRedirection() throws UnsupportedEncodingException {
        PrintStream err;
        PrintStream out;
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("May only call StandardStreamState#setupRedirection once");
        }
        List<OutputStream> outReceivers = this.receivers.stream().map(StandardStreamReceiver::receiveOut).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List<OutputStream> errReceivers = this.receivers.stream().map(StandardStreamReceiver::receiveErr).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!outReceivers.isEmpty() && (out = StandardStreamState.adapt(outReceivers)) != System.out) {
            System.out.println("# New System.out configured");
            System.setOut(out);
        }
        if (!errReceivers.isEmpty() && (err = StandardStreamState.adapt(errReceivers)) != System.err) {
            System.err.println("# New System.err configured");
            System.setErr(err);
        }
    }

    private static PrintStream adapt(List<OutputStream> outputStreams) throws UnsupportedEncodingException {
        if (outputStreams.size() == 1) {
            OutputStream out = outputStreams.get(0);
            if (out instanceof PrintStream) {
                return (PrintStream)out;
            }
            return new PrintStream(out, true, "ISO-8859-1");
        }
        return new PrintStream(MultipleOutputStreams.of(outputStreams), true, "ISO-8859-1");
    }
}

