/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.text;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class Convert {
    private static final byte[] MIN_SHORT_BYTES = Integer.toString(Short.MIN_VALUE).getBytes();
    private static final byte[] MIN_INT_BYTES = Integer.toString(Integer.MIN_VALUE).getBytes();
    private static final byte[] MIN_LONG_BYTES = Long.toString(Long.MIN_VALUE).getBytes();
    public static int MAX_SHORT_BYTES = 6;
    public static int MAX_INT_BYTES = 11;
    public static int MAX_LONG_BYTES = 20;
    public static int MAX_DOUBLE_BYTES = 24;
    public static final int MAX_ISO8601_BYTES = 28;
    public static final int MAX_ISO8601_MICROS_BYTES = 31;
    public static final int ISO8601_SECOND_OFFSET = 17;
    public static final int ISO8601_MILLIS_OFFSET = 20;
    public static final int ISO8601_MICROS_OFFSET = 23;
    private static final ThreadLocal<StringBuilder> STRING_BUILDER_THREAD_LOCAL = ThreadLocal.withInitial(() -> new StringBuilder(MAX_DOUBLE_BYTES));
    private static final int[] DAYS_SO_FAR = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

    public static ByteBuffer appendShort(short n, ByteBuffer b) {
        if (n < 0) {
            if (n == Short.MIN_VALUE) {
                b.put(MIN_SHORT_BYTES);
                return b;
            }
            b.put((byte)45);
            n = -n;
        }
        int q = b.position();
        do {
            b.put((byte)(n % 10 + 48));
        } while ((n = (short)(n / 10)) > 0);
        int p = b.position() - 1;
        while (q < p) {
            byte tmp = b.get(p);
            b.put(p--, b.get(q));
            b.put(q++, tmp);
        }
        return b;
    }

    public static ByteBuffer appendInt(int n, ByteBuffer b) {
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                b.put(MIN_INT_BYTES);
                return b;
            }
            b.put((byte)45);
            n = -n;
        }
        int q = b.position();
        do {
            b.put((byte)(n % 10 + 48));
        } while ((n /= 10) > 0);
        int p = b.position() - 1;
        while (q < p) {
            byte tmp = b.get(p);
            b.put(p--, b.get(q));
            b.put(q++, tmp);
        }
        return b;
    }

    public static ByteBuffer appendLong(long n, ByteBuffer b) {
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                b.put(MIN_LONG_BYTES);
                return b;
            }
            b.put((byte)45);
            n = -n;
        }
        int q = b.position();
        do {
            b.put((byte)(n % 10L + 48L));
        } while ((n /= 10L) > 0L);
        int p = b.position() - 1;
        while (q < p) {
            byte tmp = b.get(p);
            b.put(p--, b.get(q));
            b.put(q++, tmp);
        }
        return b;
    }

    public static ByteBuffer appendDouble(double input, @NotNull ByteBuffer dest) {
        StringBuilder sb = STRING_BUILDER_THREAD_LOCAL.get();
        sb.setLength(0);
        sb.append(input);
        int length = sb.length();
        for (int ci = 0; ci < length; ++ci) {
            dest.put((byte)sb.charAt(ci));
        }
        return dest;
    }

    private static int yearToDays(int year) {
        int lastYear = year - 1;
        return year * 365 + (0 == year ? 0 : lastYear / 4 - lastYear / 100 + lastYear / 400);
    }

    private static boolean isLeapYear(int year) {
        return 0 == year % 4 && (0 != year % 100 || 0 == year % 400) && 0 != year;
    }

    private static int countLeapDay(int year, int month) {
        return Convert.isLeapYear(year) && month > 2 ? 1 : 0;
    }

    private static int countLeapYear(int year) {
        return Convert.isLeapYear(year) ? 1 : 0;
    }

    public static ByteBuffer appendISO8601Millis(long t, byte[] gmtOffsetSuffix, ByteBuffer b) {
        int month;
        long days = t / 86400000L;
        int millis = (int)(t % 86400000L);
        if (millis < 0) {
            --days;
            millis = (int)((long)millis + 86400000L);
        }
        if ((days += 719527L) < 0L) {
            return Convert.appendISO8601(0, 0, 0, 0, 0, 0, 0, gmtOffsetSuffix, b);
        }
        if (days > 3652423L) {
            return Convert.appendISO8601(9999, 99, 99, 99, 99, 99, 999, gmtOffsetSuffix, b);
        }
        int year = (int)(days * 10000L / 3652425L);
        int daysLeft = (int)(days - (long)Convert.yearToDays(year));
        if (daysLeft > 364 + Convert.countLeapYear(year)) {
            daysLeft -= 365 + Convert.countLeapYear(year++);
        }
        if ((month = daysLeft / 31 + 1) < 12 && DAYS_SO_FAR[month + 1] + Convert.countLeapDay(year, month + 1) < daysLeft + 1) {
            ++month;
        }
        int day = daysLeft - DAYS_SO_FAR[month] - Convert.countLeapDay(year, month) + 1;
        int second = millis / 1000;
        int minute = second / 60;
        int hour = minute / 60;
        return Convert.appendISO8601(year, month, day, hour, minute %= 60, second %= 60, millis %= 1000, gmtOffsetSuffix, b);
    }

    public static ByteBuffer appendISO8601(int year, int month, int day, int hour, int minute, int second, int millis, byte[] gmtOffsetSuffix, ByteBuffer b) {
        b.put((byte)(48 + year / 1000));
        b.put((byte)(48 + year % 1000 / 100));
        b.put((byte)(48 + year % 100 / 10));
        b.put((byte)(48 + year % 10));
        b.put((byte)45);
        b.put((byte)(48 + month / 10));
        b.put((byte)(48 + month % 10));
        b.put((byte)45);
        b.put((byte)(48 + day / 10));
        b.put((byte)(48 + day % 10));
        b.put((byte)84);
        b.put((byte)(48 + hour / 10));
        b.put((byte)(48 + hour % 10));
        b.put((byte)58);
        b.put((byte)(48 + minute / 10));
        b.put((byte)(48 + minute % 10));
        b.put((byte)58);
        b.put((byte)(48 + second / 10));
        b.put((byte)(48 + second % 10));
        b.put((byte)46);
        b.put((byte)(48 + millis / 100));
        b.put((byte)(48 + millis % 100 / 10));
        b.put((byte)(48 + millis % 10));
        if (gmtOffsetSuffix != null) {
            b.put(gmtOffsetSuffix);
        }
        return b;
    }

    public static ByteBuffer appendISO8601Micros(long t, byte[] gmtOffsetSuffix, ByteBuffer b) {
        int month;
        long days = t / 86400000000L;
        long micros = t % 86400000000L;
        if (micros < 0L) {
            --days;
            micros += 86400000000L;
        }
        if ((days += 719527L) < 0L) {
            return Convert.appendISO8601Micros(0, 0, 0, 0, 0, 0, 0, 0, gmtOffsetSuffix, b);
        }
        if (days > 3652423L) {
            return Convert.appendISO8601Micros(9999, 99, 99, 99, 99, 99, 999, 999, gmtOffsetSuffix, b);
        }
        int year = (int)(days * 10000L / 3652425L);
        int daysLeft = (int)(days - (long)Convert.yearToDays(year));
        if (daysLeft > 364 + Convert.countLeapYear(year)) {
            daysLeft -= 365 + Convert.countLeapYear(year++);
        }
        if ((month = daysLeft / 31 + 1) < 12 && DAYS_SO_FAR[month + 1] + Convert.countLeapDay(year, month + 1) < daysLeft + 1) {
            ++month;
        }
        int day = daysLeft - DAYS_SO_FAR[month] - Convert.countLeapDay(year, month) + 1;
        int second = (int)(micros / 1000000L);
        int millis = (int)((micros %= 1000000L) / 1000L);
        int minute = second / 60;
        int hour = minute / 60;
        return Convert.appendISO8601Micros(year, month, day, hour, minute %= 60, second %= 60, millis, (int)(micros %= 1000L), gmtOffsetSuffix, b);
    }

    public static ByteBuffer appendISO8601Micros(int year, int month, int day, int hour, int minute, int second, int millis, int micros, byte[] gmtOffsetSuffix, ByteBuffer b) {
        b.put((byte)(48 + year / 1000));
        b.put((byte)(48 + year % 1000 / 100));
        b.put((byte)(48 + year % 100 / 10));
        b.put((byte)(48 + year % 10));
        b.put((byte)45);
        b.put((byte)(48 + month / 10));
        b.put((byte)(48 + month % 10));
        b.put((byte)45);
        b.put((byte)(48 + day / 10));
        b.put((byte)(48 + day % 10));
        b.put((byte)84);
        b.put((byte)(48 + hour / 10));
        b.put((byte)(48 + hour % 10));
        b.put((byte)58);
        b.put((byte)(48 + minute / 10));
        b.put((byte)(48 + minute % 10));
        b.put((byte)58);
        b.put((byte)(48 + second / 10));
        b.put((byte)(48 + second % 10));
        b.put((byte)46);
        b.put((byte)(48 + millis / 100));
        b.put((byte)(48 + millis % 100 / 10));
        b.put((byte)(48 + millis % 10));
        b.put((byte)(48 + micros / 100));
        b.put((byte)(48 + micros % 100 / 10));
        b.put((byte)(48 + micros % 10));
        if (gmtOffsetSuffix != null) {
            b.put(gmtOffsetSuffix);
        }
        return b;
    }
}

