/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.text;

import io.deephaven.base.text.Convert;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.TimeZone;

public class TimestampBufferMicros {
    private final ZoneRules zoneRules;
    private ThreadLocal<ThreadLocalState> threadLocals = ThreadLocal.withInitial(() -> new ThreadLocalState());

    public TimestampBufferMicros(TimeZone tz) {
        this.zoneRules = tz.toZoneId().getRules();
    }

    @Deprecated
    public TimestampBufferMicros(long localNowMicros, TimeZone tz) {
        this(tz);
    }

    public ByteBuffer getTimestamp(long nowMicros) {
        ThreadLocalState state = this.threadLocals.get();
        state.update(nowMicros);
        state.buffer.position(0);
        return state.buffer;
    }

    public void getTimestamp(long nowMicros, ByteBuffer dest) {
        dest.put(this.getTimestamp(nowMicros));
    }

    private class ThreadLocalState {
        private long currentTimeMicros = Long.MIN_VALUE;
        private long previousDSTTransitionMicros = Long.MAX_VALUE;
        private long nextDSTTransitionMicros = Long.MIN_VALUE;
        private long gmtOffsetMicros;
        private byte[] gmtOffsetSuffix;
        private final ByteBuffer buffer = ByteBuffer.allocate(31);

        private ThreadLocalState() {
        }

        public void update(long nowMicros) {
            if (nowMicros / 60000000L != this.currentTimeMicros / 60000000L) {
                if (nowMicros < this.previousDSTTransitionMicros || nowMicros >= this.nextDSTTransitionMicros) {
                    this.calculateDSTTransitions(nowMicros);
                }
                this.buffer.clear();
                Convert.appendISO8601Micros(nowMicros + this.gmtOffsetMicros, this.gmtOffsetSuffix, this.buffer);
                this.buffer.flip();
            } else {
                long v = (nowMicros + this.gmtOffsetMicros) % 60000000L;
                if (v < 0L) {
                    v += 60000000L;
                }
                this.buffer.put(17, (byte)(48L + v / 10000000L));
                this.buffer.put(18, (byte)(48L + v % 10000000L / 1000000L));
                this.buffer.put(20, (byte)(48L + v % 1000000L / 100000L));
                this.buffer.put(21, (byte)(48L + v % 100000L / 10000L));
                this.buffer.put(22, (byte)(48L + v % 10000L / 1000L));
                this.buffer.put(23, (byte)(48L + v % 1000L / 100L));
                this.buffer.put(24, (byte)(48L + v % 100L / 10L));
                this.buffer.put(25, (byte)(48L + v % 10L));
            }
            this.currentTimeMicros = nowMicros;
        }

        private void calculateDSTTransitions(long nowMicros) {
            Instant nowInstant = Instant.ofEpochMilli(nowMicros / 1000L);
            ZoneOffsetTransition previousTransitionOffset = TimestampBufferMicros.this.zoneRules.previousTransition(nowInstant);
            ZoneOffsetTransition nextTransitionOffset = TimestampBufferMicros.this.zoneRules.nextTransition(nowInstant);
            this.previousDSTTransitionMicros = previousTransitionOffset != null ? previousTransitionOffset.toEpochSecond() * 1000L * 1000L : Long.MIN_VALUE;
            this.nextDSTTransitionMicros = nextTransitionOffset != null ? nextTransitionOffset.toEpochSecond() * 1000L * 1000L : Long.MAX_VALUE;
            this.gmtOffsetMicros = (long)TimestampBufferMicros.this.zoneRules.getOffset(nowInstant).getTotalSeconds() * 1000L * 1000L;
            if (this.gmtOffsetMicros == 0L) {
                this.gmtOffsetSuffix = new byte[]{90};
            } else {
                this.gmtOffsetSuffix = new byte[5];
                this.gmtOffsetSuffix[0] = (byte)(this.gmtOffsetMicros < 0L ? 45 : 43);
                int hours = (int)Math.abs(this.gmtOffsetMicros / 3600000L / 1000L);
                int minutes = (int)((Math.abs(this.gmtOffsetMicros / 1000L) - (long)(hours * 3600000)) / 60000L);
                this.gmtOffsetSuffix[1] = (byte)(48 + hours / 10);
                this.gmtOffsetSuffix[2] = (byte)(48 + hours % 10);
                this.gmtOffsetSuffix[3] = (byte)(48 + minutes / 10);
                this.gmtOffsetSuffix[4] = (byte)(48 + minutes % 10);
            }
        }
    }
}

