/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.verify;

import io.deephaven.base.verify.ExceptionMessageUtil;
import io.deephaven.base.verify.RequirementFailure;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class Require {
    private static volatile Consumer<RequirementFailure> onFailureCallback;

    public static boolean setOnFailureCallback(Consumer<RequirementFailure> newCallback) {
        boolean wasSet = onFailureCallback != null;
        onFailureCallback = newCallback;
        return wasSet;
    }

    private Require() {
    }

    private static void fail(String conditionText, int numCallsBelowRequirer) {
        RequirementFailure requirementFailure = new RequirementFailure(ExceptionMessageUtil.failureMessage("Requirement", "required", conditionText, null), numCallsBelowRequirer + 1);
        if (onFailureCallback != null) {
            try {
                onFailureCallback.accept(requirementFailure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw requirementFailure;
    }

    private static void fail(String conditionText, String detailMessage, int numCallsBelowRequirer) {
        RequirementFailure requirementFailure = new RequirementFailure(ExceptionMessageUtil.failureMessage("Requirement", "required", conditionText, detailMessage), numCallsBelowRequirer + 1);
        if (onFailureCallback != null) {
            try {
                onFailureCallback.accept(requirementFailure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw requirementFailure;
    }

    public static void requirement(boolean condition, String conditionText, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText) {
        Require.requirement(condition, conditionText, 1);
    }

    public static void requirement(boolean condition, String conditionText, String detailMessage, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, detailMessage, numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, String detailMessage) {
        Require.requirement(condition, conditionText, detailMessage, 1);
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0) {
        Require.requirement(condition, conditionText, o0, name0, 1);
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1) {
        Require.requirement(condition, conditionText, o0, name0, o1, name1, 1);
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, long o0, String name0, long o1, String name1, long o2, String name2, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2) {
        Require.requirement(condition, conditionText, o0, name0, o1, name1, o2, name2, 1);
    }

    public static void requirement(boolean condition, String conditionText, long o0, String name0, long o1, String name1, long o2, String name2) {
        Require.requirement(condition, conditionText, o0, name0, o1, name1, o2, name2, 1);
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2, Object o3, String name3, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2, o3, name3), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2, Object o3, String name3) {
        Require.requirement(condition, conditionText, o0, name0, o1, name1, o2, name2, o3, name3, 1);
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0) {
        Require.requirement(condition, conditionText, b0, name0, 1);
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1) {
        Require.requirement(condition, conditionText, b0, name0, b1, name1, 1);
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, double d1, String name1, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.concat(ExceptionMessageUtil.valueAndName(b0, name0), ExceptionMessageUtil.valueAndName(d1, name1)), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, double d1, String name1) {
        Require.requirement(condition, conditionText, b0, name0, d1, name1, 1);
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1, b2, name2), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2) {
        Require.requirement(condition, conditionText, b0, name0, b1, name1, b2, name2, 1);
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2, boolean b3, String name3, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1, b2, name2, b3, name3), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2, boolean b3, String name3) {
        Require.requirement(condition, conditionText, b0, name0, b1, name1, b2, name2, b3, name3, 1);
    }

    public static void requirement(boolean condition, String conditionText, int i0, String name0, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(i0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, int i0, String name0) {
        Require.requirement(condition, conditionText, i0, name0, 1);
    }

    public static void requirement(boolean condition, String conditionText, int i0, String name0, int i1, String name1, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, int i0, String name0, int i1, String name1) {
        Require.requirement(condition, conditionText, i0, name0, i1, name1, 1);
    }

    public static void requirement(boolean condition, String conditionText, long l0, String name0, int numCallsBelowRequirer) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(l0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void requirement(boolean condition, String conditionText, long l0, String name0) {
        Require.requirement(condition, conditionText, l0, name0, 1);
    }

    public static RequirementFailure statementNeverExecuted(int numCallsBelowRequirer) {
        Require.fail("statement is never executed", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure statementNeverExecuted() {
        return Require.statementNeverExecuted(1);
    }

    public static RequirementFailure statementNeverExecuted(String statementDescription, int numCallsBelowRequirer) {
        Require.fail(statementDescription + " is never executed", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure statementNeverExecuted(String statementDescription) {
        return Require.statementNeverExecuted(statementDescription, 1);
    }

    public static RequirementFailure exceptionNeverCaught(Exception e, int numCallsBelowRequirer) {
        try {
            Require.fail(e.getClass().getName() + " is never caught", e.getClass().getName() + "(" + e.getMessage() + ") caught", numCallsBelowRequirer + 1);
        }
        catch (RequirementFailure requirementFailure) {
            requirementFailure.initCause(e);
            throw requirementFailure;
        }
        return null;
    }

    public static RequirementFailure exceptionNeverCaught(Exception e) {
        return Require.exceptionNeverCaught(e, 1);
    }

    public static RequirementFailure exceptionNeverCaught(String tryStatementDescription, Exception e, int numCallsBelowRequirer) {
        try {
            Require.fail(tryStatementDescription + " succeeds", e.getClass().getName() + "(" + e.getMessage() + ") caught", numCallsBelowRequirer + 1);
        }
        catch (RequirementFailure requirementFailure) {
            requirementFailure.initCause(e);
            throw requirementFailure;
        }
        return null;
    }

    public static RequirementFailure exceptionNeverCaught(String tryStatementDescription, Exception e) {
        return Require.exceptionNeverCaught(tryStatementDescription, e, 1);
    }

    public static RequirementFailure valueNeverOccurs(Object o, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(o, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(Object o, String name) {
        return Require.valueNeverOccurs(o, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(boolean b, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(b, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(boolean b, String name) {
        return Require.valueNeverOccurs(b, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(char c, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(c, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(char c, String name) {
        return Require.valueNeverOccurs(c, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(byte b, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(b, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(byte b, String name) {
        return Require.valueNeverOccurs(b, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(short s, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(s, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(short s, String name) {
        return Require.valueNeverOccurs(s, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(int i, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(i, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(int i, String name) {
        return Require.valueNeverOccurs(i, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(long l, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(l, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(long l, String name) {
        return Require.valueNeverOccurs(l, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(float f, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(f, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(float f, String name) {
        return Require.valueNeverOccurs(f, name, 1);
    }

    public static RequirementFailure valueNeverOccurs(double d, String name, int numCallsBelowRequirer) {
        Require.fail(ExceptionMessageUtil.valueAndName(d, name) + " never occurs", numCallsBelowRequirer + 1);
        return null;
    }

    public static RequirementFailure valueNeverOccurs(double d, String name) {
        return Require.valueNeverOccurs(d, name, 1);
    }

    public static void holdsLock(Object o, String name, int numCallsBelowRequirer) {
        Require.neqNull(o, "o");
        if (!Thread.holdsLock(o)) {
            Require.fail("\"" + Thread.currentThread().getName() + "\".holdsLock(" + name + ")", numCallsBelowRequirer + 1);
        }
    }

    public static void holdsLock(Object o, String name) {
        Require.holdsLock(o, name, 1);
    }

    public static void notHoldsLock(Object o, String name, int numCallsBelowRequirer) {
        Require.neqNull(o, "o");
        if (Thread.holdsLock(o)) {
            Require.fail("!\"" + Thread.currentThread().getName() + "\".holdsLock(" + name + ")", numCallsBelowRequirer + 1);
        }
    }

    public static void notHoldsLock(Object o, String name) {
        Require.notHoldsLock(o, name, 1);
    }

    public static <T> void instanceOf(Object o, String name, Class<T> type, int numCallsBelowRequirer) {
        if (!type.isInstance(o)) {
            Require.fail(name + " instanceof " + type, (String)(null == o ? ExceptionMessageUtil.valueAndName(o, name) : name + " instanceof " + o.getClass() + " (" + ExceptionMessageUtil.valueAndName(o, name) + ")"), numCallsBelowRequirer + 1);
        }
    }

    public static <T> void instanceOf(Object o, String name, Class<T> type) {
        Require.instanceOf(o, name, type, 1);
    }

    public static <T> void notInstanceOf(Object o, String name, Class<T> type, int numCallsBelowRequirer) {
        if (type.isInstance(o)) {
            Require.fail("!(" + name + " instanceof " + type + ")", name + " instanceof " + o.getClass() + " (" + ExceptionMessageUtil.valueAndName(o, name) + ")", numCallsBelowRequirer + 1);
        }
    }

    public static <T> void notInstanceOf(Object o, String name, Class<T> type) {
        Require.notInstanceOf(o, name, type, 1);
    }

    public static void isAWTThread() {
        Require.isAWTThread(1);
    }

    public static void isAWTThread(int numCallsBelowRequirer) {
        if (!EventQueue.isDispatchThread()) {
            Require.fail("\"" + Thread.currentThread().getName() + "\".isAWTThread()", numCallsBelowRequirer + 1);
        }
    }

    public static void isNotAWTThread() {
        Require.isNotAWTThread(1);
    }

    public static void isNotAWTThread(int numCallsBelowRequirer) {
        if (EventQueue.isDispatchThread()) {
            Require.fail("!\"" + Thread.currentThread().getName() + "\".isAWTThread()", numCallsBelowRequirer + 1);
        }
    }

    public static void eq(boolean b0, String name0, boolean b1, String name1, int numCallsBelowRequirer) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(boolean b0, String name0, boolean b1, String name1) {
        Require.eq(b0, name0, b1, name1, 1);
    }

    public static void eq(boolean b0, String name0, boolean b1, int numCallsBelowRequirer) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(boolean b0, String name0, boolean b1) {
        Require.eq(b0, name0, b1, 1);
    }

    public static void eq(char c0, String name0, char c1, String name1, int numCallsBelowRequirer) {
        if (c0 != c1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(char c0, String name0, char c1, String name1) {
        Require.eq(c0, name0, c1, name1, 1);
    }

    public static void eq(char c0, String name0, char c1, int numCallsBelowRequirer) {
        if (c0 != c1) {
            Require.fail(name0 + " == " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(char c0, String name0, char c1) {
        Require.eq(c0, name0, c1, 1);
    }

    public static void eq(byte b0, String name0, byte b1, String name1, int numCallsBelowRequirer) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(byte b0, String name0, byte b1, String name1) {
        Require.eq(b0, name0, b1, name1, 1);
    }

    public static void eq(byte b0, String name0, byte b1, int numCallsBelowRequirer) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(byte b0, String name0, byte b1) {
        Require.eq(b0, name0, b1, 1);
    }

    public static void eq(short s0, String name0, short s1, String name1, int numCallsBelowRequirer) {
        if (s0 != s1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(short s0, String name0, short s1, String name1) {
        Require.eq(s0, name0, s1, name1, 1);
    }

    public static void eq(short s0, String name0, short s1, int numCallsBelowRequirer) {
        if (s0 != s1) {
            Require.fail(name0 + " == " + s1, ExceptionMessageUtil.valueAndName(s0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(short s0, String name0, short s1) {
        Require.eq(s0, name0, s1, 1);
    }

    public static void eq(int i0, String name0, int i1, String name1, int numCallsBelowRequirer) {
        if (i0 != i1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(int i0, String name0, int i1, String name1) {
        Require.eq(i0, name0, i1, name1, 1);
    }

    public static void eq(int i0, String name0, int i1, int numCallsBelowRequirer) {
        if (i0 != i1) {
            Require.fail(name0 + " == " + i1, ExceptionMessageUtil.valueAndName(i0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(int i0, String name0, int i1) {
        Require.eq(i0, name0, i1, 1);
    }

    public static void eq(long l0, String name0, long l1, String name1, int numCallsBelowRequirer) {
        if (l0 != l1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(long l0, String name0, long l1, String name1) {
        Require.eq(l0, name0, l1, name1, 1);
    }

    public static void eq(long l0, String name0, long l1, int numCallsBelowRequirer) {
        if (l0 != l1) {
            Require.fail(name0 + " == " + l1, ExceptionMessageUtil.valueAndName(l0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(long l0, String name0, long l1) {
        Require.eq(l0, name0, l1, 1);
    }

    public static void eq(float f0, String name0, float f1, String name1, int numCallsBelowRequirer) {
        if (f0 != f1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(float f0, String name0, float f1, String name1) {
        Require.eq(f0, name0, f1, name1, 1);
    }

    public static void eq(float f0, String name0, float f1, int numCallsBelowRequirer) {
        if (f0 != f1) {
            Require.fail(name0 + " == " + f1, ExceptionMessageUtil.valueAndName(f0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(float f0, String name0, float f1) {
        Require.eq(f0, name0, f1, 1);
    }

    public static void eq(double d0, String name0, double d1, String name1, int numCallsBelowRequirer) {
        if (d0 != d1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(double d0, String name0, double d1, String name1) {
        Require.eq(d0, name0, d1, name1, 1);
    }

    public static void eq(double d0, String name0, double d1, int numCallsBelowRequirer) {
        if (d0 != d1) {
            Require.fail(name0 + " == " + d1, ExceptionMessageUtil.valueAndName(d0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(double d0, String name0, double d1) {
        Require.eq(d0, name0, d1, 1);
    }

    public static void neq(boolean b0, String name0, boolean b1, String name1, int numCallsBelowRequirer) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(boolean b0, String name0, boolean b1, String name1) {
        Require.neq(b0, name0, b1, name1, 1);
    }

    public static void neq(boolean b0, String name0, boolean b1, int numCallsBelowRequirer) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(boolean b0, String name0, boolean b1) {
        Require.neq(b0, name0, b1, 1);
    }

    public static void neq(char c0, String name0, char c1, String name1, int numCallsBelowRequirer) {
        if (c0 == c1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(char c0, String name0, char c1, String name1) {
        Require.neq(c0, name0, c1, name1, 1);
    }

    public static void neq(char c0, String name0, char c1, int numCallsBelowRequirer) {
        if (c0 == c1) {
            Require.fail(name0 + " != " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(char c0, String name0, char c1) {
        Require.neq(c0, name0, c1, 1);
    }

    public static void neq(byte b0, String name0, byte b1, String name1, int numCallsBelowRequirer) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(byte b0, String name0, byte b1, String name1) {
        Require.neq(b0, name0, b1, name1, 1);
    }

    public static void neq(byte b0, String name0, byte b1, int numCallsBelowRequirer) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(byte b0, String name0, byte b1) {
        Require.neq(b0, name0, b1, 1);
    }

    public static void neq(short s0, String name0, short s1, String name1, int numCallsBelowRequirer) {
        if (s0 == s1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(short s0, String name0, short s1, String name1) {
        Require.neq(s0, name0, s1, name1, 1);
    }

    public static void neq(short s0, String name0, short s1, int numCallsBelowRequirer) {
        if (s0 == s1) {
            Require.fail(name0 + " != " + s1, ExceptionMessageUtil.valueAndName(s0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(short s0, String name0, short s1) {
        Require.neq(s0, name0, s1, 1);
    }

    public static int neq(int i0, String name0, int i1, String name1, int numCallsBelowRequirer) {
        if (i0 == i1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int neq(int i0, String name0, int i1, String name1) {
        return Require.neq(i0, name0, i1, name1, 1);
    }

    public static void neq(int i0, String name0, int i1, int numCallsBelowRequirer) {
        if (i0 == i1) {
            Require.fail(name0 + " != " + i1, ExceptionMessageUtil.valueAndName(i0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(int i0, String name0, int i1) {
        Require.neq(i0, name0, i1, 1);
    }

    public static void neq(long l0, String name0, long l1, String name1, int numCallsBelowRequirer) {
        if (l0 == l1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(long l0, String name0, long l1, String name1) {
        Require.neq(l0, name0, l1, name1, 1);
    }

    public static void neq(long l0, String name0, long l1, int numCallsBelowRequirer) {
        if (l0 == l1) {
            Require.fail(name0 + " != " + l1, ExceptionMessageUtil.valueAndName(l0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(long l0, String name0, long l1) {
        Require.neq(l0, name0, l1, 1);
    }

    public static void neq(float f0, String name0, float f1, String name1, int numCallsBelowRequirer) {
        if (f0 == f1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(float f0, String name0, float f1, String name1) {
        Require.neq(f0, name0, f1, name1, 1);
    }

    public static void neq(float f0, String name0, float f1, int numCallsBelowRequirer) {
        if (f0 == f1) {
            Require.fail(name0 + " != " + f1, ExceptionMessageUtil.valueAndName(f0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(float f0, String name0, float f1) {
        Require.neq(f0, name0, f1, 1);
    }

    public static void neq(double d0, String name0, double d1, String name1, int numCallsBelowRequirer) {
        if (d0 == d1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(double d0, String name0, double d1, String name1) {
        Require.neq(d0, name0, d1, name1, 1);
    }

    public static void neq(double d0, String name0, double d1, int numCallsBelowRequirer) {
        if (d0 == d1) {
            Require.fail(name0 + " != " + d1, ExceptionMessageUtil.valueAndName(d0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(double d0, String name0, double d1) {
        Require.neq(d0, name0, d1, 1);
    }

    public static char lt(char c0, String name0, char c1, String name1, int numCallsBelowRequirer) {
        if (c0 >= c1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char lt(char c0, String name0, char c1, String name1) {
        return Require.lt(c0, name0, c1, name1, 1);
    }

    public static char lt(char c0, String name0, char c1, int numCallsBelowRequirer) {
        if (c0 >= c1) {
            Require.fail(name0 + " < " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char lt(char c0, String name0, char c1) {
        return Require.lt(c0, name0, c1, 1);
    }

    public static byte lt(byte b0, String name0, byte b1, String name1, int numCallsBelowRequirer) {
        if (b0 >= b1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte lt(byte b0, String name0, byte b1, String name1) {
        return Require.lt(b0, name0, b1, name1, 1);
    }

    public static byte lt(byte b0, String name0, byte b1, int numCallsBelowRequirer) {
        if (b0 >= b1) {
            Require.fail(name0 + " < " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte lt(byte b0, String name0, byte b1) {
        return Require.lt(b0, name0, b1, 1);
    }

    public static short lt(short s0, String name0, short s1, String name1, int numCallsBelowRequirer) {
        if (s0 >= s1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short lt(short s0, String name0, short s1, String name1) {
        return Require.lt(s0, name0, s1, name1, 1);
    }

    public static short lt(short s0, String name0, short s1, int numCallsBelowRequirer) {
        if (s0 >= s1) {
            Require.fail(name0 + " < " + s1, ExceptionMessageUtil.valueAndName(s0, name0), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short lt(short s0, String name0, short s1) {
        return Require.lt(s0, name0, s1, 1);
    }

    public static int lt(int i0, String name0, int i1, String name1, int numCallsBelowRequirer) {
        if (i0 >= i1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int lt(int i0, String name0, int i1, String name1) {
        return Require.lt(i0, name0, i1, name1, 1);
    }

    public static int lt(int i0, String name0, int i1, int numCallsBelowRequirer) {
        if (i0 >= i1) {
            Require.fail(name0 + " < " + i1, ExceptionMessageUtil.valueAndName(i0, name0), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int lt(int i0, String name0, int i1) {
        return Require.lt(i0, name0, i1, 1);
    }

    public static long lt(long l0, String name0, long l1, String name1, int numCallsBelowRequirer) {
        if (l0 >= l1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long lt(long l0, String name0, long l1, String name1) {
        return Require.lt(l0, name0, l1, name1, 1);
    }

    public static long lt(long l0, String name0, long l1, int numCallsBelowRequirer) {
        if (l0 >= l1) {
            Require.fail(name0 + " < " + l1, ExceptionMessageUtil.valueAndName(l0, name0), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long lt(long l0, String name0, long l1) {
        return Require.lt(l0, name0, l1, 1);
    }

    public static float lt(float f0, String name0, float f1, String name1, int numCallsBelowRequirer) {
        if (!(f0 < f1)) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float lt(float f0, String name0, float f1, String name1) {
        return Require.lt(f0, name0, f1, name1, 1);
    }

    public static float lt(float f0, String name0, float f1, int numCallsBelowRequirer) {
        if (!(f0 < f1)) {
            Require.fail(name0 + " < " + f1, ExceptionMessageUtil.valueAndName(f0, name0), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float lt(float f0, String name0, float f1) {
        return Require.lt(f0, name0, f1, 1);
    }

    public static double lt(double d0, String name0, double d1, String name1, int numCallsBelowRequirer) {
        if (!(d0 < d1)) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double lt(double d0, String name0, double d1, String name1) {
        return Require.lt(d0, name0, d1, name1, 1);
    }

    public static double lt(double d0, String name0, double d1, int numCallsBelowRequirer) {
        if (!(d0 < d1)) {
            Require.fail(name0 + " < " + d1, ExceptionMessageUtil.valueAndName(d0, name0), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double lt(double d0, String name0, double d1) {
        return Require.lt(d0, name0, d1, 1);
    }

    public static char leq(char c0, String name0, char c1, String name1, int numCallsBelowRequirer) {
        if (c0 > c1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char leq(char c0, String name0, char c1, String name1) {
        return Require.leq(c0, name0, c1, name1, 1);
    }

    public static char leq(char c0, String name0, char c1, int numCallsBelowRequirer) {
        if (c0 > c1) {
            Require.fail(name0 + " <= " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char leq(char c0, String name0, char c1) {
        return Require.leq(c0, name0, c1, 1);
    }

    public static byte leq(byte b0, String name0, byte b1, String name1, int numCallsBelowRequirer) {
        if (b0 > b1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte leq(byte b0, String name0, byte b1, String name1) {
        return Require.leq(b0, name0, b1, name1, 1);
    }

    public static byte leq(byte b0, String name0, byte b1, int numCallsBelowRequirer) {
        if (b0 > b1) {
            Require.fail(name0 + " <= " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte leq(byte b0, String name0, byte b1) {
        return Require.leq(b0, name0, b1, 1);
    }

    public static short leq(short s0, String name0, short s1, String name1, int numCallsBelowRequirer) {
        if (s0 > s1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short leq(short s0, String name0, short s1, String name1) {
        return Require.leq(s0, name0, s1, name1, 1);
    }

    public static short leq(short s0, String name0, short s1, int numCallsBelowRequirer) {
        if (s0 > s1) {
            Require.fail(name0 + " <= " + s1, ExceptionMessageUtil.valueAndName(s0, name0), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short leq(short s0, String name0, short s1) {
        return Require.leq(s0, name0, s1, 1);
    }

    public static int leq(int i0, String name0, int i1, String name1, int numCallsBelowRequirer) {
        if (i0 > i1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int leq(int i0, String name0, int i1, String name1) {
        return Require.leq(i0, name0, i1, name1, 1);
    }

    public static int leq(int i0, String name0, int i1, int numCallsBelowRequirer) {
        if (i0 > i1) {
            Require.fail(name0 + " <= " + i1, ExceptionMessageUtil.valueAndName(i0, name0), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int leq(int i0, String name0, int i1) {
        return Require.leq(i0, name0, i1, 1);
    }

    public static long leq(long l0, String name0, long l1, String name1, int numCallsBelowRequirer) {
        if (l0 > l1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long leq(long l0, String name0, long l1, String name1) {
        return Require.leq(l0, name0, l1, name1, 1);
    }

    public static long leq(long l0, String name0, long l1, int numCallsBelowRequirer) {
        if (l0 > l1) {
            Require.fail(name0 + " <= " + l1, ExceptionMessageUtil.valueAndName(l0, name0), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long leq(long l0, String name0, long l1) {
        return Require.leq(l0, name0, l1, 1);
    }

    public static float leq(float f0, String name0, float f1, String name1, int numCallsBelowRequirer) {
        if (!(f0 <= f1)) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float leq(float f0, String name0, float f1, String name1) {
        return Require.leq(f0, name0, f1, name1, 1);
    }

    public static float leq(float f0, String name0, float f1, int numCallsBelowRequirer) {
        if (!(f0 <= f1)) {
            Require.fail(name0 + " <= " + f1, ExceptionMessageUtil.valueAndName(f0, name0), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float leq(float f0, String name0, float f1) {
        return Require.leq(f0, name0, f1, 1);
    }

    public static double leq(double d0, String name0, double d1, String name1, int numCallsBelowRequirer) {
        if (!(d0 <= d1)) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double leq(double d0, String name0, double d1, String name1) {
        return Require.leq(d0, name0, d1, name1, 1);
    }

    public static double leq(double d0, String name0, double d1, int numCallsBelowRequirer) {
        if (!(d0 <= d1)) {
            Require.fail(name0 + " <= " + d1, ExceptionMessageUtil.valueAndName(d0, name0), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double leq(double d0, String name0, double d1) {
        return Require.leq(d0, name0, d1, 1);
    }

    public static char gt(char c0, String name0, char c1, String name1, int numCallsBelowRequirer) {
        if (c0 <= c1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char gt(char c0, String name0, char c1, String name1) {
        return Require.gt(c0, name0, c1, name1, 1);
    }

    public static char gt(char c0, String name0, char c1, int numCallsBelowRequirer) {
        if (c0 <= c1) {
            Require.fail(name0 + " > " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char gt(char c0, String name0, char c1) {
        return Require.gt(c0, name0, c1, 1);
    }

    public static byte gt(byte b0, String name0, byte b1, String name1, int numCallsBelowRequirer) {
        if (b0 <= b1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte gt(byte b0, String name0, byte b1, String name1) {
        return Require.gt(b0, name0, b1, name1, 1);
    }

    public static byte gt(byte b0, String name0, byte b1, int numCallsBelowRequirer) {
        if (b0 <= b1) {
            Require.fail(name0 + " > " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte gt(byte b0, String name0, byte b1) {
        return Require.gt(b0, name0, b1, 1);
    }

    public static short gt(short s0, String name0, short s1, String name1, int numCallsBelowRequirer) {
        if (s0 <= s1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short gt(short s0, String name0, short s1, String name1) {
        return Require.gt(s0, name0, s1, name1, 1);
    }

    public static short gt(short s0, String name0, short s1, int numCallsBelowRequirer) {
        if (s0 <= s1) {
            Require.fail(name0 + " > " + s1, ExceptionMessageUtil.valueAndName(s0, name0), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short gt(short s0, String name0, short s1) {
        return Require.gt(s0, name0, s1, 1);
    }

    public static int gt(int i0, String name0, int i1, String name1, int numCallsBelowRequirer) {
        if (i0 <= i1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int gt(int i0, String name0, int i1, String name1) {
        return Require.gt(i0, name0, i1, name1, 1);
    }

    public static int gt(int i0, String name0, int i1, int numCallsBelowRequirer) {
        if (i0 <= i1) {
            Require.fail(name0 + " > " + i1, ExceptionMessageUtil.valueAndName(i0, name0), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int gt(int i0, String name0, int i1) {
        return Require.gt(i0, name0, i1, 1);
    }

    public static long gt(long l0, String name0, long l1, String name1, int numCallsBelowRequirer) {
        if (l0 <= l1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long gt(long l0, String name0, long l1, String name1) {
        return Require.gt(l0, name0, l1, name1, 1);
    }

    public static long gt(long l0, String name0, long l1, int numCallsBelowRequirer) {
        if (l0 <= l1) {
            Require.fail(name0 + " > " + l1, ExceptionMessageUtil.valueAndName(l0, name0), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long gt(long l0, String name0, long l1) {
        return Require.gt(l0, name0, l1, 1);
    }

    public static float gt(float f0, String name0, float f1, String name1, int numCallsBelowRequirer) {
        if (!(f0 > f1)) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float gt(float f0, String name0, float f1, String name1) {
        return Require.gt(f0, name0, f1, name1, 1);
    }

    public static float gt(float f0, String name0, float f1, int numCallsBelowRequirer) {
        if (!(f0 > f1)) {
            Require.fail(name0 + " > " + f1, ExceptionMessageUtil.valueAndName(f0, name0), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float gt(float f0, String name0, float f1) {
        return Require.gt(f0, name0, f1, 1);
    }

    public static double gt(double d0, String name0, double d1, String name1, int numCallsBelowRequirer) {
        if (!(d0 > d1)) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double gt(double d0, String name0, double d1, String name1) {
        return Require.gt(d0, name0, d1, name1, 1);
    }

    public static double gt(double d0, String name0, double d1, int numCallsBelowRequirer) {
        if (!(d0 > d1)) {
            Require.fail(name0 + " > " + d1, ExceptionMessageUtil.valueAndName(d0, name0), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double gt(double d0, String name0, double d1) {
        return Require.gt(d0, name0, d1, 1);
    }

    public static char geq(char c0, String name0, char c1, String name1, int numCallsBelowRequirer) {
        if (c0 < c1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char geq(char c0, String name0, char c1, String name1) {
        return Require.geq(c0, name0, c1, name1, 1);
    }

    public static char geq(char c0, String name0, char c1, int numCallsBelowRequirer) {
        if (c0 < c1) {
            Require.fail(name0 + " >= " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0), numCallsBelowRequirer + 1);
        }
        return c0;
    }

    public static char geq(char c0, String name0, char c1) {
        return Require.geq(c0, name0, c1, 1);
    }

    public static byte geq(byte b0, String name0, byte b1, String name1, int numCallsBelowRequirer) {
        if (b0 < b1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte geq(byte b0, String name0, byte b1, String name1) {
        return Require.geq(b0, name0, b1, name1, 1);
    }

    public static byte geq(byte b0, String name0, byte b1, int numCallsBelowRequirer) {
        if (b0 < b1) {
            Require.fail(name0 + " >= " + b1, ExceptionMessageUtil.valueAndName(b0, name0), numCallsBelowRequirer + 1);
        }
        return b0;
    }

    public static byte geq(byte b0, String name0, byte b1) {
        return Require.geq(b0, name0, b1, 1);
    }

    public static short geq(short s0, String name0, short s1, String name1, int numCallsBelowRequirer) {
        if (s0 < s1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short geq(short s0, String name0, short s1, String name1) {
        return Require.geq(s0, name0, s1, name1, 1);
    }

    public static short geq(short s0, String name0, short s1, int numCallsBelowRequirer) {
        if (s0 < s1) {
            Require.fail(name0 + " >= " + s1, ExceptionMessageUtil.valueAndName(s0, name0), numCallsBelowRequirer + 1);
        }
        return s0;
    }

    public static short geq(short s0, String name0, short s1) {
        return Require.geq(s0, name0, s1, 1);
    }

    public static int geq(int i0, String name0, int i1, String name1, int numCallsBelowRequirer) {
        if (i0 < i1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int geq(int i0, String name0, int i1, String name1) {
        return Require.geq(i0, name0, i1, name1, 1);
    }

    public static int geq(int i0, String name0, int i1, int numCallsBelowRequirer) {
        if (i0 < i1) {
            Require.fail(name0 + " >= " + i1, ExceptionMessageUtil.valueAndName(i0, name0), numCallsBelowRequirer + 1);
        }
        return i0;
    }

    public static int geq(int i0, String name0, int i1) {
        return Require.geq(i0, name0, i1, 1);
    }

    public static long geq(long l0, String name0, long l1, String name1, int numCallsBelowRequirer) {
        if (l0 < l1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long geq(long l0, String name0, long l1, String name1) {
        return Require.geq(l0, name0, l1, name1, 1);
    }

    public static long geq(long l0, String name0, long l1, int numCallsBelowRequirer) {
        if (l0 < l1) {
            Require.fail(name0 + " >= " + l1, ExceptionMessageUtil.valueAndName(l0, name0), numCallsBelowRequirer + 1);
        }
        return l0;
    }

    public static long geq(long l0, String name0, long l1) {
        return Require.geq(l0, name0, l1, 1);
    }

    public static float geq(float f0, String name0, float f1, String name1, int numCallsBelowRequirer) {
        if (!(f0 >= f1)) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float geq(float f0, String name0, float f1, String name1) {
        return Require.geq(f0, name0, f1, name1, 1);
    }

    public static float geq(float f0, String name0, float f1, int numCallsBelowRequirer) {
        if (!(f0 >= f1)) {
            Require.fail(name0 + " >= " + f1, ExceptionMessageUtil.valueAndName(f0, name0), numCallsBelowRequirer + 1);
        }
        return f0;
    }

    public static float geq(float f0, String name0, float f1) {
        return Require.geq(f0, name0, f1, 1);
    }

    public static double geq(double d0, String name0, double d1, String name1, int numCallsBelowRequirer) {
        if (!(d0 >= d1)) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double geq(double d0, String name0, double d1, String name1) {
        return Require.geq(d0, name0, d1, name1, 1);
    }

    public static double geq(double d0, String name0, double d1, int numCallsBelowRequirer) {
        if (!(d0 >= d1)) {
            Require.fail(name0 + " >= " + d1, ExceptionMessageUtil.valueAndName(d0, name0), numCallsBelowRequirer + 1);
        }
        return d0;
    }

    public static double geq(double d0, String name0, double d1) {
        return Require.geq(d0, name0, d1, 1);
    }

    public static void eqFalse(boolean b, String name, int numCallsBelowRequirer) {
        if (b) {
            Require.fail(name + " == false", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqFalse(boolean b, String name) {
        Require.eqFalse(b, name, 1);
    }

    public static void neqFalse(boolean b, String name, int numCallsBelowRequirer) {
        if (!b) {
            Require.fail(name + " != false", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
    }

    public static void neqFalse(boolean b, String name) {
        Require.neqFalse(b, name, 1);
    }

    public static void eqTrue(boolean b, String name, int numCallsBelowRequirer) {
        if (!b) {
            Require.fail(name + " == true", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqTrue(boolean b, String name) {
        Require.eqTrue(b, name, 1);
    }

    public static void neqTrue(boolean b, String name, int numCallsBelowRequirer) {
        if (b) {
            Require.fail(name + " != true", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
    }

    public static void neqTrue(boolean b, String name) {
        Require.neqTrue(b, name, 1);
    }

    public static void eqZero(char c, String name, int numCallsBelowRequirer) {
        if ('\u0000' != c) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(c, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqZero(char c, String name) {
        Require.eqZero(c, name, 1);
    }

    public static void eqZero(byte b, String name, int numCallsBelowRequirer) {
        if (0 != b) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqZero(byte b, String name) {
        Require.eqZero(b, name, 1);
    }

    public static void eqZero(short s, String name, int numCallsBelowRequirer) {
        if (0 != s) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(s, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqZero(short s, String name) {
        Require.eqZero(s, name, 1);
    }

    public static void eqZero(int i, String name, int numCallsBelowRequirer) {
        if (0 != i) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(i, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqZero(int i, String name) {
        Require.eqZero(i, name, 1);
    }

    public static void eqZero(long l, String name, int numCallsBelowRequirer) {
        if (0L != l) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(l, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqZero(long l, String name) {
        Require.eqZero(l, name, 1);
    }

    public static void eqZero(float f, String name, int numCallsBelowRequirer) {
        if (0.0f != f) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(f, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqZero(float f, String name) {
        Require.eqZero(f, name, 1);
    }

    public static void eqZero(double d, String name, int numCallsBelowRequirer) {
        if (0.0 != d) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(d, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqZero(double d, String name) {
        Require.eqZero(d, name, 1);
    }

    public static char neqZero(char c, String name, int numCallsBelowRequirer) {
        if ('\u0000' == c) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(c, name), numCallsBelowRequirer + 1);
        }
        return c;
    }

    public static char neqZero(char c, String name) {
        return Require.neqZero(c, name, 1);
    }

    public static byte neqZero(byte b, String name, int numCallsBelowRequirer) {
        if (0 == b) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
        return b;
    }

    public static byte neqZero(byte b, String name) {
        return Require.neqZero(b, name, 1);
    }

    public static short neqZero(short s, String name, int numCallsBelowRequirer) {
        if (0 == s) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(s, name), numCallsBelowRequirer + 1);
        }
        return s;
    }

    public static short neqZero(short s, String name) {
        return Require.neqZero(s, name, 1);
    }

    public static int neqZero(int i, String name, int numCallsBelowRequirer) {
        if (0 == i) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(i, name), numCallsBelowRequirer + 1);
        }
        return i;
    }

    public static int neqZero(int i, String name) {
        return Require.neqZero(i, name, 1);
    }

    public static long neqZero(long l, String name, int numCallsBelowRequirer) {
        if (0L == l) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(l, name), numCallsBelowRequirer + 1);
        }
        return l;
    }

    public static long neqZero(long l, String name) {
        return Require.neqZero(l, name, 1);
    }

    public static float neqZero(float f, String name, int numCallsBelowRequirer) {
        if (0.0f == f) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(f, name), numCallsBelowRequirer + 1);
        }
        return f;
    }

    public static float neqZero(float f, String name) {
        return Require.neqZero(f, name, 1);
    }

    public static double neqZero(double d, String name, int numCallsBelowRequirer) {
        if (0.0 == d) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(d, name), numCallsBelowRequirer + 1);
        }
        return d;
    }

    public static double neqZero(double d, String name) {
        return Require.neqZero(d, name, 1);
    }

    public static byte ltZero(byte b, String name, int numCallsBelowRequirer) {
        if (b >= 0) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
        return b;
    }

    public static byte ltZero(byte b, String name) {
        return Require.ltZero(b, name, 1);
    }

    public static short ltZero(short s, String name, int numCallsBelowRequirer) {
        if (s >= 0) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(s, name), numCallsBelowRequirer + 1);
        }
        return s;
    }

    public static short ltZero(short s, String name) {
        return Require.ltZero(s, name, 1);
    }

    public static int ltZero(int i, String name, int numCallsBelowRequirer) {
        if (i >= 0) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(i, name), numCallsBelowRequirer + 1);
        }
        return i;
    }

    public static int ltZero(int i, String name) {
        return Require.ltZero(i, name, 1);
    }

    public static long ltZero(long l, String name, int numCallsBelowRequirer) {
        if (l >= 0L) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(l, name), numCallsBelowRequirer + 1);
        }
        return l;
    }

    public static long ltZero(long l, String name) {
        return Require.ltZero(l, name, 1);
    }

    public static float ltZero(float f, String name, int numCallsBelowRequirer) {
        if (!(f < 0.0f)) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(f, name), numCallsBelowRequirer + 1);
        }
        return f;
    }

    public static float ltZero(float f, String name) {
        return Require.ltZero(f, name, 1);
    }

    public static double ltZero(double d, String name, int numCallsBelowRequirer) {
        if (!(d < 0.0)) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(d, name), numCallsBelowRequirer + 1);
        }
        return d;
    }

    public static double ltZero(double d, String name) {
        return Require.ltZero(d, name, 1);
    }

    public static byte leqZero(byte b, String name, int numCallsBelowRequirer) {
        if (b > 0) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
        return b;
    }

    public static byte leqZero(byte b, String name) {
        return Require.leqZero(b, name, 1);
    }

    public static short leqZero(short s, String name, int numCallsBelowRequirer) {
        if (s > 0) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(s, name), numCallsBelowRequirer + 1);
        }
        return s;
    }

    public static short leqZero(short s, String name) {
        return Require.leqZero(s, name, 1);
    }

    public static int leqZero(int i, String name, int numCallsBelowRequirer) {
        if (i > 0) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(i, name), numCallsBelowRequirer + 1);
        }
        return i;
    }

    public static int leqZero(int i, String name) {
        return Require.leqZero(i, name, 1);
    }

    public static long leqZero(long l, String name, int numCallsBelowRequirer) {
        if (l > 0L) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(l, name), numCallsBelowRequirer + 1);
        }
        return l;
    }

    public static long leqZero(long l, String name) {
        return Require.leqZero(l, name, 1);
    }

    public static float leqZero(float f, String name, int numCallsBelowRequirer) {
        if (!(f <= 0.0f)) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(f, name), numCallsBelowRequirer + 1);
        }
        return f;
    }

    public static float leqZero(float f, String name) {
        return Require.leqZero(f, name, 1);
    }

    public static double leqZero(double d, String name, int numCallsBelowRequirer) {
        if (!(d <= 0.0)) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(d, name), numCallsBelowRequirer + 1);
        }
        return d;
    }

    public static double leqZero(double d, String name) {
        return Require.leqZero(d, name, 1);
    }

    public static byte gtZero(byte b, String name, int numCallsBelowRequirer) {
        if (b <= 0) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
        return b;
    }

    public static byte gtZero(byte b, String name) {
        return Require.gtZero(b, name, 1);
    }

    public static short gtZero(short s, String name, int numCallsBelowRequirer) {
        if (s <= 0) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(s, name), numCallsBelowRequirer + 1);
        }
        return s;
    }

    public static short gtZero(short s, String name) {
        return Require.gtZero(s, name, 1);
    }

    public static int gtZero(int i, String name, int numCallsBelowRequirer) {
        if (i <= 0) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(i, name), numCallsBelowRequirer + 1);
        }
        return i;
    }

    public static int gtZero(int i, String name) {
        return Require.gtZero(i, name, 1);
    }

    public static long gtZero(long l, String name, int numCallsBelowRequirer) {
        if (l <= 0L) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(l, name), numCallsBelowRequirer + 1);
        }
        return l;
    }

    public static long gtZero(long l, String name) {
        return Require.gtZero(l, name, 1);
    }

    public static float gtZero(float f, String name, int numCallsBelowRequirer) {
        if (!(f > 0.0f)) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(f, name), numCallsBelowRequirer + 1);
        }
        return f;
    }

    public static float gtZero(float f, String name) {
        return Require.gtZero(f, name, 1);
    }

    public static double gtZero(double d, String name, int numCallsBelowRequirer) {
        if (!(d > 0.0)) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(d, name), numCallsBelowRequirer + 1);
        }
        return d;
    }

    public static double gtZero(double d, String name) {
        return Require.gtZero(d, name, 1);
    }

    public static byte geqZero(byte b, String name, int numCallsBelowRequirer) {
        if (b < 0) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(b, name), numCallsBelowRequirer + 1);
        }
        return b;
    }

    public static byte geqZero(byte b, String name) {
        return Require.geqZero(b, name, 1);
    }

    public static short geqZero(short s, String name, int numCallsBelowRequirer) {
        if (s < 0) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(s, name), numCallsBelowRequirer + 1);
        }
        return s;
    }

    public static short geqZero(short s, String name) {
        return Require.geqZero(s, name, 1);
    }

    public static int geqZero(int i, String name, int numCallsBelowRequirer) {
        if (i < 0) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(i, name), numCallsBelowRequirer + 1);
        }
        return i;
    }

    public static int geqZero(int i, String name) {
        return Require.geqZero(i, name, 1);
    }

    public static long geqZero(long l, String name, int numCallsBelowRequirer) {
        if (l < 0L) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(l, name), numCallsBelowRequirer + 1);
        }
        return l;
    }

    public static long geqZero(long l, String name) {
        return Require.geqZero(l, name, 1);
    }

    public static float geqZero(float f, String name, int numCallsBelowRequirer) {
        if (!(f >= 0.0f)) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(f, name), numCallsBelowRequirer + 1);
        }
        return f;
    }

    public static float geqZero(float f, String name) {
        return Require.geqZero(f, name, 1);
    }

    public static double geqZero(double d, String name, int numCallsBelowRequirer) {
        if (!(d >= 0.0)) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(d, name), numCallsBelowRequirer + 1);
        }
        return d;
    }

    public static double geqZero(double d, String name) {
        return Require.geqZero(d, name, 1);
    }

    public static void eq(Object o0, String name0, Object o1, String name1, int numCallsBelowRequirer) {
        if (o0 != o1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(Object o0, String name0, Object o1, String name1) {
        Require.eq(o0, name0, o1, name1, 1);
    }

    public static void eq(Object o0, String name0, Object o1, int numCallsBelowRequirer) {
        if (o0 != o1) {
            Require.fail(name0 + " == " + ExceptionMessageUtil.valueString(o1), ExceptionMessageUtil.valueAndName(o0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void eq(Object o0, String name0, Object o1) {
        Require.eq(o0, name0, o1, 1);
    }

    public static void neq(Object o0, String name0, Object o1, String name1, int numCallsBelowRequirer) {
        if (o0 == o1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(Object o0, String name0, Object o1, String name1) {
        Require.neq(o0, name0, o1, name1, 1);
    }

    public static void neq(Object o0, String name0, Object o1, int numCallsBelowRequirer) {
        if (o0 == o1) {
            Require.fail(name0 + " != " + ExceptionMessageUtil.valueString(o1), ExceptionMessageUtil.valueAndName(o0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void neq(Object o0, String name0, Object o1) {
        Require.neq(o0, name0, o1, 1);
    }

    public static void eqNull(Object o, String name, int numCallsBelowRequirer) {
        if (null != o) {
            Require.fail(name + " == null", ExceptionMessageUtil.valueAndName(o, name), numCallsBelowRequirer + 1);
        }
    }

    public static void eqNull(Object o, String name) {
        Require.eqNull(o, name, 1);
    }

    @NotNull
    public static <T> T neqNull(T o, String name, int numCallsBelowRequirer) {
        if (null == o) {
            Require.fail(name + " != null", ExceptionMessageUtil.valueAndName(o, name), numCallsBelowRequirer + 1);
        }
        return o;
    }

    @NotNull
    public static <T> T neqNull(T o, String name) {
        return Require.neqNull(o, name, 1);
    }

    public static double neqNaN(double o, String name, int numCallsBelowRequirer) {
        if (Double.isNaN(o)) {
            Require.fail(name + " != NaN", ExceptionMessageUtil.valueAndName(o, name), numCallsBelowRequirer + 1);
        }
        return o;
    }

    public static double neqNaN(double o, String name) {
        return Require.neqNaN(o, name, 1);
    }

    public static double neqInf(double o, String name, int numCallsBelowRequirer) {
        if (Double.isInfinite(o)) {
            Require.fail(name + " != +/-Inf", ExceptionMessageUtil.valueAndName(o, name), numCallsBelowRequirer + 1);
        }
        return o;
    }

    public static double neqInf(double o, String name) {
        return Require.neqInf(o, name, 1);
    }

    public static void equals(Object o0, String name0, Object o1, String name1, int numCallsBelowRequirer) {
        Require.neqNull(o0, name0, numCallsBelowRequirer + 1);
        Require.neqNull(o1, name1, numCallsBelowRequirer + 1);
        if (!o0.equals(o1)) {
            Require.fail(name0 + ".equals(" + name1 + ")", ExceptionMessageUtil.valueAndName(o0, name0, o1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void equals(Object o0, String name0, Object o1, String name1) {
        Require.equals(o0, name0, o1, name1, 1);
    }

    public static void equals(Object o0, String name0, Object o1, int numCallsBelowRequirer) {
        Require.neqNull(o0, name0, numCallsBelowRequirer + 1);
        Require.neqNull(o1, "o1", numCallsBelowRequirer + 1);
        if (!o0.equals(o1)) {
            Require.fail(name0 + ".equals(" + ExceptionMessageUtil.valueString(o1) + ")", ExceptionMessageUtil.valueAndName(o0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void equals(Object o0, String name0, Object o1) {
        Require.equals(o0, name0, o1, 1);
    }

    public static void notEquals(Object o0, String name0, Object o1, String name1, int numCallsBelowRequirer) {
        Require.neqNull(o0, name0, numCallsBelowRequirer + 1);
        Require.neqNull(o1, name1, numCallsBelowRequirer + 1);
        if (o0.equals(o1)) {
            Require.fail("!" + name0 + ".equals(" + name1 + ")", ExceptionMessageUtil.valueAndName(o0, name0, o1, name1), numCallsBelowRequirer + 1);
        }
    }

    public static void notEquals(Object o0, String name0, Object o1, String name1) {
        Require.notEquals(o0, name0, o1, name1, 1);
    }

    public static void notEquals(Object o0, String name0, Object o1, int numCallsBelowRequirer) {
        Require.neqNull(o0, name0, numCallsBelowRequirer + 1);
        Require.neqNull(o1, "o1", numCallsBelowRequirer + 1);
        if (o0.equals(o1)) {
            Require.fail("!" + name0 + ".equals(" + ExceptionMessageUtil.valueString(o1) + ")", ExceptionMessageUtil.valueAndName(o0, name0), numCallsBelowRequirer + 1);
        }
    }

    public static void notEquals(Object o0, String name0, Object o1) {
        Require.notEquals(o0, name0, o1, 1);
    }

    public static String nonempty(String s, String name, int numCallsBelowRequirer) {
        Require.neqNull(s, name, numCallsBelowRequirer + 1);
        if (s.length() <= 0) {
            Require.fail(name + ".length() > 0", ExceptionMessageUtil.valueAndName(s, name), numCallsBelowRequirer + 1);
        }
        return s;
    }

    public static String nonempty(String s, String name) {
        return Require.nonempty(s, name, 1);
    }

    public static <C extends Collection<T>, T> C contains(C collection, String collectionName, T element, String elementName, int numCallsBelowRequirer) {
        Require.neqNull(collection, collectionName, numCallsBelowRequirer + 1);
        if (!collection.contains(element)) {
            Require.fail(collectionName + ".contains(" + elementName + ")", ExceptionMessageUtil.valueAndName(element, elementName), numCallsBelowRequirer + 1);
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C contains(C collection, String collectionName, T element, String elementName) {
        return Require.contains(collection, collectionName, element, elementName, 1);
    }

    public static <C extends Collection<T>, T> C notContains(C collection, String collectionName, T element, String elementName, int numCallsBelowRequirer) {
        Require.neqNull(collection, collectionName, numCallsBelowRequirer + 1);
        if (collection.contains(element)) {
            Require.fail("!" + collectionName + ".contains(" + elementName + ")", ExceptionMessageUtil.valueAndName(element, elementName), numCallsBelowRequirer + 1);
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C notContains(C collection, String collectionName, T element, String elementName) {
        return Require.notContains(collection, collectionName, element, elementName, 1);
    }

    public static <C extends Collection<T>, T> C notContainsNull(C collection, String collectionName, int numCallsBelowRequirer) {
        Require.neqNull(collection, collectionName, numCallsBelowRequirer + 1);
        if (collection.stream().anyMatch(Objects::isNull)) {
            Require.fail(collectionName + " does not contain null", numCallsBelowRequirer + 1);
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C notContainsNull(C collection, String collectionName) {
        return Require.notContainsNull(collection, collectionName, 1);
    }

    public static <M extends Map<K, V>, K, V> M containsKey(M map, String mapName, K key, String keyName, int numCallsBelowRequirer) {
        Require.neqNull(map, mapName, numCallsBelowRequirer + 1);
        if (!map.containsKey(key)) {
            Require.fail(mapName + ".containsKey(" + keyName + ")", ExceptionMessageUtil.valueAndName(key, keyName), numCallsBelowRequirer + 1);
        }
        return map;
    }

    public static <M extends Map<K, V>, K, V> M containsKey(M map, String mapName, K key, String keyName) {
        return Require.containsKey(map, mapName, key, keyName, 1);
    }

    public static <M extends Map<K, V>, K, V> M notContainsKey(M map, String mapName, K key, String keyName, int numCallsBelowRequirer) {
        Require.neqNull(map, mapName, numCallsBelowRequirer + 1);
        if (map.containsKey(key)) {
            Require.fail("!" + mapName + ".containsKey(" + keyName + ")", ExceptionMessageUtil.valueAndName(key, keyName), numCallsBelowRequirer + 1);
        }
        return map;
    }

    public static <M extends Map<K, V>, K, V> M notContainsKey(M map, String mapName, K key, String keyName) {
        return Require.notContainsKey(map, mapName, key, keyName, 1);
    }

    public static int inRange(int offset, String offsetName, int length, String lengthName, int numCallsBelowRequirer) {
        if (offset < 0) {
            Require.fail(offsetName + " >= 0", ExceptionMessageUtil.valueAndName(offset, offsetName), numCallsBelowRequirer + 1);
        } else if (offset >= length) {
            Require.fail(offsetName + " < " + lengthName, ExceptionMessageUtil.valueAndName(offset, offsetName, length, lengthName), numCallsBelowRequirer + 1);
        }
        return offset;
    }

    public static int inRange(int offset, String offsetName, int length, String lengthName) {
        return Require.inRange(offset, offsetName, length, lengthName, 1);
    }

    public static int inRange(int offset, String offsetName, int start, String startName, int end, String endName, int numCallsBelowRequirer) {
        if (offset < start) {
            Require.fail(offsetName + " >= " + startName, ExceptionMessageUtil.valueAndName(offset, offsetName, start, startName), numCallsBelowRequirer + 1);
        } else if (offset >= end) {
            Require.fail(offsetName + " < " + endName, ExceptionMessageUtil.valueAndName(offset, offsetName, end, endName), numCallsBelowRequirer + 1);
        }
        return offset;
    }

    public static int inRange(int offset, String offsetName, int start, String startName, int end, String endName) {
        return Require.inRange(offset, offsetName, start, startName, end, endName, 1);
    }

    public static long inRange(long offset, String offsetName, long length, String lengthName, int numCallsBelowRequirer) {
        if (offset < 0L) {
            Require.fail(offsetName + " >= 0L", ExceptionMessageUtil.valueAndName(offset, offsetName), numCallsBelowRequirer + 1);
        } else if (offset >= length) {
            Require.fail(offsetName + " < " + lengthName, ExceptionMessageUtil.valueAndName(offset, offsetName, length, lengthName), numCallsBelowRequirer + 1);
        }
        return offset;
    }

    public static long inRange(long offset, String offsetName, long length, String lengthName) {
        return Require.inRange(offset, offsetName, length, lengthName, 1);
    }

    public static long inRange(long offset, String offsetName, long start, String startName, long end, String endName, int numCallsBelowRequirer) {
        if (offset < start) {
            Require.fail(offsetName + " >= " + startName, ExceptionMessageUtil.valueAndName(offset, offsetName, start, startName), numCallsBelowRequirer + 1);
        } else if (offset >= end) {
            Require.fail(offsetName + " < " + endName, ExceptionMessageUtil.valueAndName(offset, offsetName, end, endName), numCallsBelowRequirer + 1);
        }
        return offset;
    }

    public static long inRange(long offset, String offsetName, long start, String startName, long end, String endName) {
        return Require.inRange(offset, offsetName, start, startName, end, endName, 1);
    }

    public static double normalized(double d, String name, int numCallsBelowRequirer) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            Require.fail(name + " is normalized (not infinity or NaN)", ExceptionMessageUtil.valueAndName(d, name), numCallsBelowRequirer + 1);
        }
        return d;
    }

    public static double normalized(double d, String name) {
        return Require.normalized(d, name, 1);
    }

    public static <T> T[] nonEmpty(T[] a, String name, int numCallsBelowRequirer) {
        Require.neqNull(a, name, numCallsBelowRequirer + 1);
        if (a.length <= 0) {
            Require.fail(name + ".length > 0", ExceptionMessageUtil.valueAndName(a, name), numCallsBelowRequirer + 1);
        }
        return a;
    }

    public static <T> T[] nonEmpty(T[] a, String name) {
        return Require.nonEmpty(a, name, 1);
    }

    public static int[] lengthEqual(int[] a, String name, int length, int numCallsBelowRequirer) {
        if (a.length != length) {
            Require.fail(name + ".length == " + length, ExceptionMessageUtil.valueAndName(a, name), numCallsBelowRequirer + 1);
        }
        return a;
    }

    public static int[] lengthEqual(int[] a, String name, int length) {
        return Require.lengthEqual(a, name, length, 1);
    }

    public static <T> T[] elementsNeqNull(T[] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != null) continue;
            Require.neqNull(elements[i], name + "[" + i + "]");
        }
        return elements;
    }

    public static void elementsNeqNaN(double[] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            if (!Double.isNaN(elements[i])) continue;
            Require.neqNaN(elements[i], name + "[" + i + "]");
        }
    }

    public static void elementsNeqNaN(double[][] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            for (int j = 0; j < elements[i].length; ++j) {
                if (!Double.isNaN(elements[i][j])) continue;
                Require.neqNaN(elements[i][j], name + "[" + i + "," + j + "]");
            }
        }
    }

    public static void elementsNeqInf(double[] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            if (!Double.isInfinite(elements[i])) continue;
            Require.neqInf(elements[i], name + "[" + i + "]");
        }
    }

    public static void elementsNeqInf(double[][] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            for (int j = 0; j < elements[i].length; ++j) {
                if (!Double.isInfinite(elements[i][j])) continue;
                Require.neqInf(elements[i][j], name + "[" + i + "," + j + "]");
            }
        }
    }

    public static void isSquare(double[][] m, String name) {
        for (int i = 0; i < m.length; ++i) {
            if (m[i].length == m.length) continue;
            Require.fail("Matrix is not square: " + name, "matrix is not square: " + name, 1);
        }
    }

    public static double inRange(double trialValue, double endPointA, double endPointB, String name) {
        double minRange = endPointA;
        double maxRange = endPointB;
        if (endPointA > endPointB) {
            minRange = endPointB;
            maxRange = endPointA;
        }
        if (trialValue < minRange || maxRange < trialValue) {
            Require.fail(name + " = " + trialValue + " is expected to be in the range of [" + minRange + "," + maxRange + "] but was not", 1);
        }
        return trialValue;
    }

    public static float inRange(float trialValue, float endPointA, float endPointB, String name) {
        float minRange = endPointA;
        float maxRange = endPointB;
        if (endPointA > endPointB) {
            minRange = endPointB;
            maxRange = endPointA;
        }
        if (trialValue < minRange || maxRange < trialValue) {
            Require.fail(name + " = " + trialValue + " is expected to be in the range of [" + minRange + "," + maxRange + "] but was not", 1);
        }
        return trialValue;
    }
}

