/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.verify;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class RequirementFailure
extends RuntimeException {
    private int m_nCallsBelowRequirer;

    public RequirementFailure(String message, int nCallsBelowRequirer) {
        super(message);
        this.m_nCallsBelowRequirer = nCallsBelowRequirer;
    }

    public RequirementFailure(String message, Exception caughtException, int nCallsBelowRequirer) {
        super(message, caughtException);
        this.m_nCallsBelowRequirer = nCallsBelowRequirer;
    }

    public int getNumCallsBelowRequirer() {
        return this.m_nCallsBelowRequirer;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.print(this.getFixedStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.print(this.getFixedStackTrace());
    }

    private StringBuffer getFixedStackTrace() {
        StringBuffer sb = this.getOriginalStackTrace();
        String sStackTrace = sb.toString();
        int nInsertPoint = sStackTrace.indexOf("\n\tat ");
        for (int nCount = this.m_nCallsBelowRequirer; nCount >= 0; --nCount) {
            nInsertPoint = sStackTrace.indexOf("\n\tat ", nInsertPoint + 1);
        }
        if (-1 != nInsertPoint) {
            sb.insert(nInsertPoint, "\n    (culprit:)");
        }
        return sb;
    }

    public StringBuffer getOriginalStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.getBuffer();
    }

    public RequirementFailure adjustForDelegatingMethod() {
        if (this.isThisStackFrameCulprit(1)) {
            ++this.m_nCallsBelowRequirer;
        }
        return this;
    }

    public RequirementFailure adjustForDelegatingMethodAndSyntheticAccessor() {
        if (this.isThisStackFrameCulprit(0)) {
            this.m_nCallsBelowRequirer += 2;
        }
        return this;
    }

    public boolean isThisStackFrameCulprit(int nFramesBelowTargetFrame) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement[] failureStackTrace = this.getStackTrace();
        return failureStackTrace.length - this.m_nCallsBelowRequirer == stackTrace.length - nFramesBelowTargetFrame;
    }
}

