/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.base.text.TimestampBufferMicros;
import java.nio.ByteBuffer;

public class LogOutputStringImpl
implements LogOutput,
CharSequence {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected final StringBuilder builder;

    public LogOutputStringImpl() {
        this.builder = new StringBuilder();
    }

    public LogOutputStringImpl(StringBuilder builder) {
        this.builder = builder;
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    @Override
    public LogOutput markEndOfHeader() {
        return this;
    }

    @Override
    public int getEndOfHeaderOffset() {
        return 0;
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }

    @Override
    public LogOutput start() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LogOutput append(boolean b) {
        if (b) {
            return this.append("true");
        }
        return this.append("false");
    }

    @Override
    public LogOutput append(char c) {
        this.builder.append(c);
        return this;
    }

    @Override
    public LogOutput append(short s) {
        this.builder.append(s);
        return this;
    }

    @Override
    public LogOutput append(int i) {
        this.builder.append(i);
        return this;
    }

    @Override
    public LogOutput append(long l) {
        this.builder.append(l);
        return this;
    }

    @Override
    public LogOutput appendDouble(double d) {
        this.builder.append(d);
        return this;
    }

    @Override
    public LogOutput append(LogOutputAppendable appendable) {
        return appendable == null ? this.append("null") : appendable.append(this);
    }

    @Override
    public LogOutput append(LogOutput.LongFormatter formatter, long n) {
        formatter.format(this, n);
        return this;
    }

    @Override
    public <T> LogOutput append(LogOutput.ObjFormatter<T> objFormatter, T t) {
        objFormatter.format(this, t);
        return this;
    }

    @Override
    public <T> LogOutput append(LogOutput.ObjIntIntFormatter<T> objFormatter, T t, int nOffset, int nLength) {
        objFormatter.format(this, t, nOffset, nLength);
        return this;
    }

    @Override
    public <T, U> LogOutput append(LogOutput.ObjObjFormatter<T, U> objObjFormatter, T t, U u) {
        objObjFormatter.format(this, t, u);
        return this;
    }

    @Override
    public LogOutput append(CharSequence seq) {
        this.builder.append(seq);
        return this;
    }

    @Override
    public LogOutput append(CharSequence seq, int start, int length) {
        this.builder.append(seq, start, length);
        return this;
    }

    @Override
    public LogOutput append(ByteBuffer bb) {
        if (bb == null) {
            return this.append("null");
        }
        int pos = bb.position();
        int limit = bb.limit();
        for (int i = pos; i < limit; ++i) {
            this.builder.append((char)bb.get(i));
        }
        return this;
    }

    @Override
    public LogOutput appendTimestamp(long utcMillis, TimestampBuffer tb) {
        ByteBuffer byteBuffer = tb.getTimestamp(utcMillis);
        for (int bi = byteBuffer.position(); bi < byteBuffer.limit(); ++bi) {
            this.builder.append((char)byteBuffer.get(bi));
        }
        return this;
    }

    @Override
    public LogOutput appendTimestampMicros(long utcMicros, TimestampBufferMicros tb) {
        ByteBuffer byteBuffer = tb.getTimestamp(utcMicros);
        for (int bi = byteBuffer.position(); bi < byteBuffer.limit(); ++bi) {
            this.builder.append((char)byteBuffer.get(bi));
        }
        return this;
    }

    @Override
    public LogOutput append(Throwable t) {
        boolean root = true;
        String delim = "[";
        do {
            if (!root) {
                this.append("; caused by");
            } else {
                root = false;
            }
            this.append(delim);
            this.append(t.getClass().getName()).append(": ").append(t.getMessage());
            for (StackTraceElement e : t.getStackTrace()) {
                this.append(delim).append(e.getClassName()).append(".").append(e.getMethodName()).append("(").append(e.getFileName()).append(":").append(e.getLineNumber()).append(")");
                delim = ";";
            }
        } while ((t = t.getCause()) != null);
        this.append("]");
        return this;
    }

    @Override
    public LogOutput append(byte[] ba) {
        for (int i = 0; i < ba.length; ++i) {
            this.builder.append((char)ba[i]);
        }
        return this;
    }

    @Override
    public LogOutput append(byte[] ba, int pos, int length) {
        for (int i = pos; i < pos + length; ++i) {
            this.builder.append((char)ba[i]);
        }
        return this;
    }

    @Override
    public LogOutput append(byte[] ba, byte terminator) {
        for (int i = 0; i < ba.length && ba[i] != terminator; ++i) {
            this.builder.append((char)ba[i]);
        }
        return this;
    }

    @Override
    public LogOutput nf() {
        this.append(',');
        return this;
    }

    @Override
    public LogOutput nl() {
        this.append(LINE_SEPARATOR);
        return this;
    }

    @Override
    public LogOutput close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int relativeSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBufferCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getBuffer(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LogOutput clear() {
        this.builder.setLength(0);
        return this;
    }
}

