/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ClassUtils;

public final class ClassUtil {
    private static final Map<String, Class<?>> classMap = new ConcurrentHashMap();

    public static <T> Class<T> generify(Class c) {
        return c;
    }

    private static Class<?> getJavaType(String selectedType) throws ClassNotFoundException {
        String noGenerics = selectedType.replaceAll("<.*>", "");
        return ClassUtils.getClass((String)noGenerics, (boolean)false);
    }

    public static Class<?> lookupClass(String name) throws ClassNotFoundException {
        Class<?> result = classMap.get(name);
        if (result == null) {
            try {
                result = ClassUtil.getJavaType(name);
                classMap.put(name, result);
            }
            catch (ClassNotFoundException e) {
                classMap.put(name, FailedToResolve.class);
                throw e;
            }
        } else if (result == FailedToResolve.class) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private static class FailedToResolve {
        private FailedToResolve() {
        }
    }
}

