/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.AtomicUtil;
import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.verify.Assert;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class FIFOSemaphore {
    private final LockFreeArrayQueue<Thread> threads;
    private final AtomicInteger resource;
    private final int spinsUntilPark;

    public FIFOSemaphore(int spinsUntilPark, int resources) {
        this.spinsUntilPark = spinsUntilPark;
        this.threads = new LockFreeArrayQueue(12);
        this.resource = new AtomicInteger(resources);
    }

    public int tryAcquireAll() {
        return AtomicUtil.getAndSetIfGreaterThan(this.resource, 0, 0);
    }

    public boolean tryAcquire(int toAcquire) {
        return this.getAndDecreaseIfCan(toAcquire) >= toAcquire;
    }

    public void acquire(int toAcquire) {
        this.acquire(toAcquire, true);
    }

    private int getAndDecreaseIfCan(int toAcquire) {
        return AtomicUtil.getAndDecreaseIfGreaterThan(this.resource, toAcquire, toAcquire - 1);
    }

    public int acquireAll() {
        int acquired = this.tryAcquireAll();
        if (acquired == 0) {
            this.acquire(1, false);
            acquired = 1 + this.tryAcquireAll();
        }
        return acquired;
    }

    public void release(int toRelease) {
        this.resource.getAndAdd(toRelease);
        LockSupport.unpark(this.threads.peek());
    }

    public int availablePermits() {
        return this.resource.get();
    }

    public void forceAcquire(int toAcquire) {
        this.resource.getAndAdd(-toAcquire);
    }

    private void acquire(int toAcquire, boolean doUnpark) {
        int resourcesAvailable;
        boolean wasInterrupted = false;
        Thread me = Thread.currentThread();
        Assert.eqTrue(this.threads.enqueue(me), "threads.enqueue(me)");
        int spins = 0;
        boolean peekNotMe = true;
        while (peekNotMe && (peekNotMe = this.threads.peek() != me) || (resourcesAvailable = this.getAndDecreaseIfCan(toAcquire)) < toAcquire) {
            if (++spins % this.spinsUntilPark != 0) continue;
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        Thread t = this.threads.dequeue();
        if (t != me) {
            throw new IllegalStateException("Failed to dequeue myself, got " + String.valueOf(t));
        }
        if (doUnpark && resourcesAvailable > toAcquire) {
            LockSupport.unpark(this.threads.peek());
        }
        if (wasInterrupted) {
            me.interrupt();
        }
    }
}

