/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import java.util.Arrays;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class OSUtil {
    public static OSFamily getOSFamily() {
        String name = OSUtil.getOSName();
        OSFamily[] matchingFamilies = (OSFamily[])Arrays.stream(OSFamily.values()).filter(family -> family.matchesName(name)).toArray(OSFamily[]::new);
        if (matchingFamilies.length == 0) {
            throw new IllegalArgumentException("Unknown OS family for OS name " + name);
        }
        if (matchingFamilies.length > 1) {
            throw new IllegalArgumentException("Ambiguous OS family for OS name " + name + ", matches: " + Arrays.toString((Object[])matchingFamilies));
        }
        return matchingFamilies[0];
    }

    public static boolean runningLinux() {
        return OSFamily.LINUX.matchesName(OSUtil.getOSName());
    }

    public static boolean runningWindows() {
        return OSFamily.WINDOWS.matchesName(OSUtil.getOSName());
    }

    public static boolean runningMacOS() {
        return OSFamily.MAC_OS.matchesName(OSUtil.getOSName());
    }

    public static boolean runningSolaris() {
        return OSFamily.SOLARIS.matchesName(OSUtil.getOSName());
    }

    private static String getOSName() {
        return System.getProperty("os.name");
    }

    public static enum OSFamily {
        LINUX(name -> name.startsWith("Linux")),
        WINDOWS(name -> name.contains("Windows")),
        MAC_OS(name -> name.startsWith("Mac OS")),
        SOLARIS(name -> name.startsWith("SunOs"));

        private final Predicate<String> nameMatcher;

        private OSFamily(Predicate<String> nameMatcher) {
            this.nameMatcher = nameMatcher;
        }

        private boolean matchesName(@NotNull String osName) {
            return this.nameMatcher.test(osName);
        }
    }
}

